﻿/*---------------------------------------------------------------------------*
  Copyright (C)2014 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include <nn/TargetConfigs/build_Cpu.h>
#include <nn/TargetConfigs/build_Fpu.h>
#include "os_FiberContextDispatcher-os.horizon.h"

    //-------------------------------------------------------------------------
    //  void DispatchFiberContext( FiberContextForHorizon** currentFiber,
    //                             FiberContextForHorizon** nextFiber );
    //
    //  x0: currentFiber の FiberContextForHorizon 構造体の先頭アドレスの格納アドレス
    //  x1: nextFiber    の FiberContextForHorizon 構造体の先頭アドレスの格納アドレス
    //-------------------------------------------------------------------------

#if defined(NN_BUILD_CONFIG_CPU_ARM64)

    #define NN_OS_DETAIL_DISPATCH_FIBER_CONTEXT   _ZN2nn2os6detail20DispatchFiberContextEPPNS1_22FiberContextForHorizonES4_

    .section .text, "ax"
    .align   2
    .global  NN_OS_DETAIL_DISPATCH_FIBER_CONTEXT
    .type    NN_OS_DETAIL_DISPATCH_FIBER_CONTEXT, %function
NN_OS_DETAIL_DISPATCH_FIBER_CONTEXT:

    // currentFiber のコンテキストを保存
    sub     sp,  sp,  #NN_OS_SIZEOF_FIBER_CONTEXT
    mov     x2,  #0
    stp     x2,  x19, [sp, #0  * 8]
    stp     x20, x21, [sp, #2  * 8]
    stp     x22, x23, [sp, #4  * 8]
    stp     x24, x25, [sp, #6  * 8]
    stp     x26, x27, [sp, #8  * 8]
    stp     x28, x29, [sp, #10 * 8]
    stp     x30, x2,  [sp, #12 * 8]     // x2 is reg_padding

    stp     q8,  q9,  [sp, #14 * 8]
    stp     q10, q11, [sp, #18 * 8]
    stp     q12, q13, [sp, #22 * 8]
    stp     q14, q15, [sp, #26 * 8]

    mov     x2, sp
    str     x2, [x0]

    // nextFiber のコンテキストを復帰
    ldr     x2, [x1]
    mov     sp, x2

    ldp     x0,  x19, [sp, #0 * 8]
    ldp     x20, x21, [sp, #2 * 8]
    ldp     x22, x23, [sp, #4 * 8]
    ldp     x24, x25, [sp, #6 * 8]
    ldp     x26, x27, [sp, #8 * 8]
    ldp     x28, x29, [sp, #10 * 8]
    ldr     x30,      [sp, #12 * 8]

    ldp     q8,  q9,  [sp, #14 * 8]
    ldp     q10, q11, [sp, #18 * 8]
    ldp     q12, q13, [sp, #22 * 8]
    ldp     q14, q15, [sp, #26 * 8]

    add     sp,  sp,  #NN_OS_SIZEOF_FIBER_CONTEXT
    ret
    .size   NN_OS_DETAIL_DISPATCH_FIBER_CONTEXT, [. - NN_OS_DETAIL_DISPATCH_FIBER_CONTEXT]

#elif defined(NN_BUILD_CONFIG_CPU_ARM)

    #define NN_OS_DETAIL_DISPATCH_FIBER_CONTEXT   _ZN2nn2os6detail20DispatchFiberContextEPPNS1_22FiberContextForHorizonES4_

    .section .text, "ax"
    .align   2
    .global  NN_OS_DETAIL_DISPATCH_FIBER_CONTEXT
    .type    NN_OS_DETAIL_DISPATCH_FIBER_CONTEXT, %function
NN_OS_DETAIL_DISPATCH_FIBER_CONTEXT:

    // currentFiber のコンテキストを保存
    sub     sp,  sp,  #NN_OS_SIZEOF_FIBER_CONTEXT
    mov     r2,  #0
    mov     r3,  sp
    stmia   r3!, {r2, r4, r5, r6, r7, r8, r9, r10, r11, lr}
    vstmia.64 r3!, { d8-d15 }

    str     sp, [r0]
    ldr     sp, [r1]

    // nextFiber のコンテキストを復帰
    mov     r3, sp
    ldmia   r3!, {r0, r4, r5, r6, r7, r8, r9, r10, r11, lr}
    vldmia.64 r3!, { d8-d15 }

    add     sp,  sp,  #NN_OS_SIZEOF_FIBER_CONTEXT
    bx lr
    .size   NN_OS_DETAIL_DISPATCH_FIBER_CONTEXT, [. - NN_OS_DETAIL_DISPATCH_FIBER_CONTEXT]

#endif

