﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/TargetConfigs/build_Cpu.h>

    //-------------------------------------------------------------------------
    //  FiberType* CallFiberFunction( FiberFunction function,
    //                                void* argument );
    //
    //  x0: pointer  - pointer to fiber function
    //  x1: argument - fiber function argument
    //
    //  CallFiberFunction() is a wrapper for a fiber function.
    //  CallFiberFunction() does not produce any unwinding information and
    //  serves as a stopping point for libunwind. When libunwind reaches
    //  the wrapper it finds no unwinding info and stops, producing a correct
    //  callstack with the fiber function on the top.
    //
    //  It's important that CallFiberFunction generates no unwinding info.
    //  Please do NOT add any CFI directives here for AArch64, and
    //  do NOT remove the  .cantunwind for ARM32.
    //
    //  Fiber functions are only expected to be called through this function.
    //  If a fiber function is called from a C++ function with unwinding info,
    //  the actual frame layout and the values in the registers would not
    //  correspond to unwinding information, resulting in crash in libunwind.
    //-------------------------------------------------------------------------

#if defined(NN_BUILD_CONFIG_CPU_ARM64)
    #define NN_OS_DETAIL_CALL_FIBER_FUNCTION _ZN2nn2os6detail17CallFiberFunctionEPFPNS0_9FiberTypeEPvES4_

    .section .text, "ax"
    .align   2
    .global  NN_OS_DETAIL_CALL_FIBER_FUNCTION
    .type    NN_OS_DETAIL_CALL_FIBER_FUNCTION, %function
NN_OS_DETAIL_CALL_FIBER_FUNCTION:
    stp     x29, x30, [sp, #-0x10]!
    mov     x29, #0
    mov     x2, x0
    mov     x0, x1
    blr     x2
    ldp     x29, x30, [sp], #0x10
    ret
    .size   NN_OS_DETAIL_CALL_FIBER_FUNCTION, [. - NN_OS_DETAIL_CALL_FIBER_FUNCTION]

#elif defined(NN_BUILD_CONFIG_CPU_ARM)
    #define NN_OS_DETAIL_CALL_FIBER_FUNCTION _ZN2nn2os6detail17CallFiberFunctionEPFPNS0_9FiberTypeEPvES4_

    .section .text, "ax"
    .align   2
    .global  NN_OS_DETAIL_CALL_FIBER_FUNCTION
    .type    NN_OS_DETAIL_CALL_FIBER_FUNCTION, %function
NN_OS_DETAIL_CALL_FIBER_FUNCTION:
    .fnstart
    push    {fp, lr}
    mov     fp, #0
    mov     r2, r0
    mov     r0, r1
    blx     r2
    pop     {fp, pc}
    .cantunwind
    .fnend
    .size   NN_OS_DETAIL_CALL_FIBER_FUNCTION, [. - NN_OS_DETAIL_CALL_FIBER_FUNCTION]
#endif
