﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ncm/ncm_ContentMetaKey.h>
#include <nn/ncm/ncm_IContentMetaDatabase.h>
#include <nn/kvdb/kvdb_FlatMapKeyValueStore.h>
#include <nn/fs/fs_Mount.h>

namespace nn { namespace ncm {

    template<class Kvs>
    Result GetContentMetaSize(size_t* pOutSize, const ContentMetaKey& key, const Kvs* pKvs) NN_NOEXCEPT
    {
        NN_RESULT_TRY(pKvs->GetSize(pOutSize, key))
            NN_RESULT_CATCH(nn::kvdb::ResultKeyNotFound)
            {
                NN_RESULT_THROW(ResultContentMetaNotFound());
            }
        NN_RESULT_END_TRY;

        NN_RESULT_SUCCESS;
    }

    template<class Kvs>
    Result GetContentMetaPointer(const void** pOutBuffer, size_t* pOutSize, const ContentMetaKey& key, const Kvs* pKvs) NN_NOEXCEPT
    {
        NN_RESULT_DO(GetContentMetaSize(pOutSize, key, pKvs));
        NN_RESULT_DO(pKvs->GetPointer(pOutBuffer, key));

        NN_RESULT_SUCCESS;
    }

}} // nn::ncm
