﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/sf/sf_ObjectFactory.h>
#include <nn/ncm/ncm_ContentManagerFactory.h>
#include <nn/ncm/ncm_ContentManagerImpl.h>

namespace nn { namespace ncm {

    sf::SharedPointer<IContentManager> CreateDefaultContentManager(const ContentManagerConfig &config) NN_NOEXCEPT
    {
        auto emplacedRef = sf::CreateSharedObjectEmplaced<IContentManager, ContentManagerImpl>();
        auto& impl = emplacedRef.GetImpl();
        NN_ABORT_UNLESS_RESULT_SUCCESS(impl.Initialize(config));

        return emplacedRef;
    }
}}
