﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/mbuf/mbuf_Macro.h>
#include <nn/mbuf/mbuf_Definitions.h>
#include <nn/mbuf/mbuf_Mbuf.h>

#include <nnc/mbuf/mbuf_Macro.h>
#include <nnc/mbuf/mbuf_Definitions.h>
#include <nnc/mbuf/mbuf_Mbuf.h>

NN_MBUF_EXTERN_C nnmbufMbuf* nnmbufMbufGetm(
    nnmbufMbuf* orig, size_t len, nnmbufMbufAllocationMode how, int type)
{
    return reinterpret_cast<nnmbufMbuf*>(nn::mbuf::MbufGetm(
        reinterpret_cast<nn::mbuf::Mbuf*>(orig),
        len,
        static_cast<nn::mbuf::MbufAllocationMode>(how),
        type));
}

NN_MBUF_EXTERN_C void nnmbufMbufFreem(nnmbufMbuf* pMbuf)
{
    nn::mbuf::MbufFreem(reinterpret_cast<nn::mbuf::Mbuf*>(pMbuf));
}

NN_MBUF_EXTERN_C bool nnmbufMbufAdj(nnmbufMbuf* pMbuf, int len)
{
    return nn::mbuf::MbufAdj(reinterpret_cast<nn::mbuf::Mbuf*>(pMbuf), len);
}


NN_MBUF_EXTERN_C bool nnmbufMbufAppend(nnmbufMbuf* pMbuf, size_t len, const void* cp)
{
    return nn::mbuf::MbufAppend(reinterpret_cast<nn::mbuf::Mbuf*>(pMbuf), len, cp);
}

NN_MBUF_EXTERN_C nnmbufMbuf* nnmbufMbufPrependWithAllocation(
    nnmbufMbuf* pMbuf, size_t len, nnmbufMbufAllocationMode how)
{
    return reinterpret_cast<nnmbufMbuf*>(
            nn::mbuf::MbufPrependWithAllocation( reinterpret_cast<nn::mbuf::Mbuf*>(pMbuf),
                                                 len,
                                                 static_cast<nn::mbuf::MbufAllocationMode>(how) ));
}

NN_MBUF_EXTERN_C nnmbufMbuf* nnmbufMbufPrepend(
    nnmbufMbuf* pMbuf, size_t len, nnmbufMbufAllocationMode how)
{
    return reinterpret_cast<nnmbufMbuf*>(
            nn::mbuf::MbufPrepend( reinterpret_cast<nn::mbuf::Mbuf*>(pMbuf),
                                   len,
                                   static_cast<nn::mbuf::MbufAllocationMode>(how) ));
}

NN_MBUF_EXTERN_C nnmbufMbuf* nnmbufMbufPullup(nnmbufMbuf* pMbuf, size_t len)
{
    return reinterpret_cast<nnmbufMbuf*>(
            nn::mbuf::MbufPullup( reinterpret_cast<nn::mbuf::Mbuf*>(pMbuf),
                                  len ));
}

NN_MBUF_EXTERN_C nnmbufMbuf* nnmbufMbufDup(const nnmbufMbuf* pMbuf, nnmbufMbufAllocationMode how)
{
    return reinterpret_cast<nnmbufMbuf*>(
            nn::mbuf::MbufDup( reinterpret_cast<const nn::mbuf::Mbuf*>(pMbuf),
                               static_cast<nn::mbuf::MbufAllocationMode>(how) ));
}

NN_MBUF_EXTERN_C bool nnmbufMbufCopydata(const nnmbufMbuf* pMbuf, size_t offset,
                                         size_t len, void* buf)
{
    return nn::mbuf::MbufCopydata( reinterpret_cast<const nn::mbuf::Mbuf*>(pMbuf),
                                   offset,
                                   len,
                                   buf );
}

NN_MBUF_EXTERN_C bool nnmbufMbufCopyback(nnmbufMbuf* pMbuf, size_t offset,
                                         size_t len, const void* buf)
{
    return nn::mbuf::MbufCopyback( reinterpret_cast<nn::mbuf::Mbuf*>(pMbuf),
                                   offset,
                                   len,
                                   buf );
}

NN_MBUF_EXTERN_C bool nnmbufMbufCat(nnmbufMbuf* pMbuf, nnmbufMbuf* pMbufNext)
{
    return nn::mbuf::MbufCat( reinterpret_cast<nn::mbuf::Mbuf*>(pMbuf),
                              reinterpret_cast<nn::mbuf::Mbuf*>(pMbufNext) );
}


NN_MBUF_EXTERN_C nnmbufMbuf* nnmbufMbufSplit(nnmbufMbuf* pMbuf, size_t len,
                                             nnmbufMbufAllocationMode how)
{
    return reinterpret_cast<nnmbufMbuf*>(
            nn::mbuf::MbufSplit( reinterpret_cast<nn::mbuf::Mbuf*>(pMbuf),
                                 len,
                                 static_cast<nn::mbuf::MbufAllocationMode>(how) ));
}

NN_MBUF_EXTERN_C size_t nnmbufMbufLength(nnmbufMbuf* pMbuf, nnmbufMbuf** last)
{
    return nn::mbuf::MbufLength( reinterpret_cast<nn::mbuf::Mbuf*>(pMbuf),
                                 reinterpret_cast<nn::mbuf::Mbuf**>(last) );
}

NN_MBUF_EXTERN_C int nnmbufMbufApply(nnmbufMbuf* pMbuf, size_t offset, size_t len,
                                     int (* func)(void* arg, void* data, size_t len), void* arg)
{
    return nn::mbuf::MbufApply( reinterpret_cast<nn::mbuf::Mbuf*>(pMbuf),
                                offset,
                                len,
                                func,
                                arg );
}

NN_MBUF_EXTERN_C bool nnmbufMbufAlignWithOffset(nnmbufMbuf* pMbuf, size_t align, size_t offset)
{
    return nn::mbuf::MbufAlignWithOffset(reinterpret_cast<nn::mbuf::Mbuf*>(pMbuf), align, offset);
}

NN_MBUF_EXTERN_C int nnmbufMbufGetFreeCount(int type)
{
    return nn::mbuf::MbufGetFreeCount(type);
}
