﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>

#include <nn/lr/lr_RegisteredLocationResolver.h>
#include <nn/lr/lr_IRegisteredLocationResolver.h>

namespace nn { namespace lr {

Result RegisteredLocationResolver::ResolveProgramPath(Path* outValue, ncm::ProgramId id) NN_NOEXCEPT
{
    NN_SDK_ASSERT(m_Interface);

    return m_Interface->ResolveProgramPath(outValue, id);
}

Result RegisteredLocationResolver::RegisterProgramPath(ncm::ProgramId id, const Path& path) NN_NOEXCEPT
{
    NN_SDK_ASSERT(m_Interface);

    return m_Interface->RegisterProgramPath(id, path);
}

Result RegisteredLocationResolver::UnregisterProgramPath(ncm::ProgramId id) NN_NOEXCEPT
{
    NN_SDK_ASSERT(m_Interface);

    return m_Interface->UnregisterProgramPath(id);
}

void RegisteredLocationResolver::RedirectProgramPath(ncm::ProgramId id, const Path& redirectedPath) NN_NOEXCEPT
{
    NN_SDK_ASSERT(m_Interface);

    NN_ABORT_UNLESS(m_Interface->RedirectProgramPath(id, redirectedPath).IsSuccess());

}
Result RegisteredLocationResolver::ResolveHtmlDocumentPath(Path* outValue, ncm::ProgramId id) NN_NOEXCEPT
{
    NN_SDK_ASSERT(m_Interface);

    return m_Interface->ResolveHtmlDocumentPath(outValue, id);
}

Result RegisteredLocationResolver::RegisterHtmlDocumentPath(ncm::ProgramId id, const Path& path) NN_NOEXCEPT
{
    NN_SDK_ASSERT(m_Interface);

    return m_Interface->RegisterHtmlDocumentPath(id, path);
}

Result RegisteredLocationResolver::UnregisterHtmlDocumentPath(ncm::ProgramId id) NN_NOEXCEPT
{
    NN_SDK_ASSERT(m_Interface);

    return m_Interface->UnregisterHtmlDocumentPath(id);
}

void RegisteredLocationResolver::RedirectHtmlDocumentPath(ncm::ProgramId id, const Path& redirectedPath) NN_NOEXCEPT
{
    NN_SDK_ASSERT(m_Interface);

    NN_ABORT_UNLESS(m_Interface->RedirectHtmlDocumentPath(id, redirectedPath).IsSuccess());

}
}}
