﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/util/util_StringUtil.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/ncm/ncm_Result.h>

#include <nn/lr/lr_Result.h>
#include <nn/lr/lr_AddOnContentLocationResolverImpl.h>
#include <nn/ncm/ncm_Service.h>
#include <nn/ncm/ncm_ContentMetaDatabase.h>
#include <nn/ncm/ncm_ContentStorage.h>

namespace nn { namespace lr {

namespace
{

Result ResolvePath(sf::Out<lr::Path> outValue, RegisteredStorages<ncm::DataId, AddOnContentLocationResolverImpl::MaxAddOnContentLocationCount>* registered, ncm::DataId id) NN_NOEXCEPT
{
    ncm::StorageId storage;
    NN_RESULT_THROW_UNLESS(registered->Find(&storage, id), lr::ResultAddOnContentNotFound());

    ncm::ContentMetaDatabase db;
    NN_RESULT_DO(ncm::OpenContentMetaDatabase(&db, storage));

    ncm::ContentId contentId;
    NN_RESULT_DO(db.GetLatestData(&contentId, id));

    ncm::ContentStorage cs;
    NN_RESULT_DO(ncm::OpenContentStorage(&cs, storage));

    ncm::Path path;
    cs.GetPath(&path, contentId);

    std::memcpy(outValue.GetPointer()->string, path.string, sizeof(path.string));
    NN_RESULT_SUCCESS;
}

NN_STATIC_ASSERT(sizeof(lr::Path) == sizeof(ncm::Path));

bool RegisterStorage(RegisteredStorages<ncm::DataId, AddOnContentLocationResolverImpl::MaxAddOnContentLocationCount>* registered, ncm::DataId id, ncm::StorageId storageId) NN_NOEXCEPT
{
    if (registered->Register(id, storageId) == true)
    {
        return true;
    }
    return false;
}

}

Result AddOnContentLocationResolverImpl::ResolveAddOnContentPath(sf::Out<lr::Path> outValue, ncm::DataId id) NN_NOEXCEPT
{
    NN_RESULT_DO(::nn::lr::ResolvePath(outValue, &m_RegisteredAddOnContents, id));
    NN_RESULT_SUCCESS;
}

Result AddOnContentLocationResolverImpl::RegisterAddOnContentStorage(ncm::DataId id, ncm::StorageId storageId) NN_NOEXCEPT
{
    NN_RESULT_THROW_UNLESS(::nn::lr::RegisterStorage(&m_RegisteredAddOnContents, id, storageId), nn::lr::ResultTooManyPathRegistered());
    NN_RESULT_SUCCESS;
}

Result AddOnContentLocationResolverImpl::UnregisterAllAddOnContentPath() NN_NOEXCEPT
{
    m_RegisteredAddOnContents.Clear();
    NN_RESULT_SUCCESS;
}

}}
