﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief ヒープ共通 API です。内部実装は mem_DetailCommonHeap.cpp 内にあります。
 */

#include "./detail/lmem_DetailCommonHeap.h"

namespace nn { namespace lmem {

void SetFillValue( FillType type, Bit32 value ) NN_NOEXCEPT
{
    detail::SetHeapFillVal( type, value );
    return;
}

Bit32 GetFillValue( const FillType type ) NN_NOEXCEPT
{
    return detail::GetHeapFillVal( type );
}

size_t GetTotalSize( const HeapHandle heapHandle ) NN_NOEXCEPT
{
    detail::HeapLocker locker(heapHandle);
    return detail::GetHeapTotalSize( heapHandle );
}

void *GetStartAddress( const HeapHandle heapHandle ) NN_NOEXCEPT
{
    detail::HeapLocker locker(heapHandle);
    return detail::GetHeapStartAddress( heapHandle );
}

bool HasAddress( HeapHandle heapHandle, void* address ) NN_NOEXCEPT
{
    detail::HeapLocker locker(heapHandle);
    return detail::HasAddress( heapHandle, address );
}

}}
