﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/TargetConfigs/build_Compiler.h>

#include <nn/nn_Common.h>
#include <nn/nn_SdkLog.h>
#include <nn/init/init_Startup.h>

#if defined(NN_BUILD_CONFIG_TOOLCHAIN_CLANG)
extern "C" void _init_libc0();
extern "C" void _init_libc1();
extern "C" void _init_libc2();
#endif

extern "C" void nninitInitializeSdkModule();
extern "C" void nninitFinalizeSdkModule();
extern "C" void nnosInitialize(uintptr_t handle, uintptr_t argumentRegionAddress) NN_NOEXCEPT;
extern "C" void nnosQuickExit();
extern "C" void nnMain();

namespace nn { namespace init {

    namespace
    {
        extern "C" void InitLibc0()
        {
#if defined(NN_BUILD_CONFIG_TOOLCHAIN_CLANG)
            _init_libc0();
#endif
        }

        extern "C" void InitLibc1()
        {
#if defined(NN_BUILD_CONFIG_TOOLCHAIN_CLANG)
            _init_libc1();
#endif
        }

        extern "C" void InitLibc2()
        {
#if defined(NN_BUILD_CONFIG_TOOLCHAIN_CLANG)
            _init_libc2();
#endif
        }
    }
    // anonymous namespace

    void Start(
        uintptr_t handle,
        uintptr_t argumentRegionAddress,
        void (*pEnableExceptionHandler)(),
        void (*pCallInit)() )
    {
        InitLibc0();
        nnosInitialize(handle, argumentRegionAddress);

        // ユーザランド例外ハンドラ有効化
        pEnableExceptionHandler();

        InitLibc1();
        nninitInitializeSdkModule();
        nninitStartup();
        InitLibc2();

        // 各 nso の初期化ハンドラ呼び出し
        pCallInit();

        nnMain();

        nninitFinalizeSdkModule();
        nnosQuickExit();
    }

}}  // namespace nn::init
