﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdlib>

#include <nn/nn_Windows.h>
#include <nn/hws/hws_Message.h>

#include "hws_MsgProc.h"

namespace nn { namespace hws {

void ProcessMessage() NN_NOEXCEPT
{
    MsgProc::GetInstance().ResetMouseWheel();

    MSG msg;
    while( PeekMessageA( &msg, nullptr, 0, 0, PM_REMOVE ) )
    {
        if( msg.message == WM_QUIT )
        {
            ::_exit( EXIT_SUCCESS );
        }
        TranslateMessage( &msg );
        DispatchMessageA( &msg );
    }
}

}
} // namespace nn
