﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/htc/tenv/htc_TenvIService.h>

namespace nn { namespace htc { namespace tenv {

    typedef std::basic_string<char, std::char_traits<char>, detail::StdAllocator<char>> StdString;

    void InitializeMountHostSuccessEvent() NN_NOEXCEPT;
    void SignalMountHostSuccessEvent() NN_NOEXCEPT;

    class Service
    {
    public:
        NN_IMPLICIT Service(nn::Bit64 processId) NN_NOEXCEPT;

    public:
        nn::Result GetVariable(nn::sf::Out<std::int64_t> outValue, const nn::sf::OutBuffer& outBuffer, const nn::htc::tenv::VariableName& variableName) NN_NOEXCEPT;
        nn::Result GetVariableLength(nn::sf::Out<std::int64_t> outValue, const nn::htc::tenv::VariableName& variableName) NN_NOEXCEPT;
        nn::Result WaitUntilVariableAvailable(std::int64_t timeOutMilliSeconds) NN_NOEXCEPT;

    private:
        Result GetVariableImpl(StdString* outStr, const nn::htc::tenv::VariableName& variableName) NN_NOEXCEPT;
        const char* GetDefinitionFilePath() NN_NOEXCEPT;
        nn::Bit64 m_ProcessId;
    };

}}}
