﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <new>
#include <type_traits>
#include <nn/htc/htc_ResultPrivate.h>
#include <nn/htc/tenv/htc_Tenv.h>
#include <nn/htc/tenv/htc_TenvPath.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/sf/sf_HipcServer.h>
#include <nn/util/util_StringUtil.h>

#include "htc_TenvAllocator.h"
#include "htc_TenvService.h"
#include "htc_TenvImpl.h"

namespace nn { namespace htc { namespace tenv {

    void Initialize(AllocateFunction alloc, DeallocateFunction dealloc) NN_NOEXCEPT
    {
        detail::InitializeAllocator(alloc, dealloc);
        InitializeMountHostSuccessEvent();
    }

    Result RegisterDefinitionFilePath(nn::os::ProcessId processId, const char* path, size_t size) NN_NOEXCEPT
    {
        // size は NULL 終端を含まないバイトサイズを想定
        if (size >= PathLengthMax)
        {
            return ResultTooLongFilePath();
        }
        Path tmpPath;
        std::memset(tmpPath.string, 0, sizeof(tmpPath.string));
        util::Strlcpy(tmpPath.string, path, static_cast<int>(size) + 1);
        return detail::RegisterDefinitionFilePath(processId.value, &tmpPath);
    }

    void UnregisterDefinitionFilePath(nn::os::ProcessId processId) NN_NOEXCEPT
    {
        detail::UnregisterDefinitionFilePath(processId.value);
    }

    void NotifyMountHostSuccess() NN_NOEXCEPT
    {
        SignalMountHostSuccessEvent();
    }

}}}
