﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using nn;
using nn.sf;
using std;

namespace nn.fs
{
    [LargeData]
    [CppRefPath(@"<nn/fs/fs_SaveDataTypes.h>")]
    [ExternalStruct(96, 8)]
    public struct SaveDataInfo
    {
    }

    [CppRefPath(@"<nn/fs/fs_SaveDataTypes.h>")]
    [ExternalStruct(16, 8)]
    public struct UserId
    {
    }

    namespace detail
    {

        [CppRefPath(@"<nn/fs/fs_SaveDataTransferType.h>")]
        [ExternalStruct(16, 8)]
        public struct KeySeed
        {
        }

        [CppRefPath(@"<nn/fs/fs_SaveDataTransferType.h>")]
        [ExternalStruct(16, 8)]
        public struct InitialDataMac
        {
        }

        [CppRefPath(@"<nn/fs/fs_SaveDataTransferType.h>")]
        [ExternalStruct(32, 8)]
        public struct InitialDataAad
        {
        }

    }
}

namespace nn.fssrv.sf
{
    [CppRefPath(@"<nn/fssrv/sf/fssrv_ISaveDataTransfer.h>")]
    public interface ISaveDataExporter : IServiceObject
    {
        [MethodId(0)]
        Result GetSaveDataInfo(Out<fs.SaveDataInfo> outValue);

        [MethodId(1)]
        Result GetRestSize(Out<uint64_t> outValue);

        [MethodId(16)]
        Result Pull(Out<uint64_t> outValue, OutBuffer buffer);

        [MethodId(17)]
        Result PullInitialData(OutBuffer buffer);
    }

    [CppRefPath(@"<nn/fssrv/sf/fssrv_ISaveDataTransfer.h>")]
    public interface ISaveDataImporter : IServiceObject
    {
        [MethodId(0)]
        Result GetSaveDataInfo(Out<fs.SaveDataInfo> outValue);

        [MethodId(1)]
        Result GetRestSize(Out<uint64_t> outValue);

        [MethodId(16)]
        Result Push(InBuffer buffer);

        [MethodId(17)]
        Result Finalize();
    }

    [CppRefPath(@"<nn/fssrv/sf/fssrv_ISaveDataTransfer.h>")]
    public interface ISaveDataTransferManager : IServiceObject
    {
        [MethodId(0)]
        Result GetChallenge(OutBuffer buffer);

        [MethodId(16)]
        Result SetToken(InBuffer buffer);

        [MethodId(32)]
        Result OpenSaveDataExporter(Out<ISaveDataExporter> outValue, uint8_t saveDataSpaceId, uint64_t saveDataId);

        [MethodId(64)]
        Result OpenSaveDataImporter(Out<ISaveDataImporter> outValue, Out<int64_t> outRequiredSize, InBuffer buffer, fs.UserId userId, uint8_t saveDataSpaceId);
    }



    [CppRefPath(@"<nn/fssrv/sf/fssrv_ISaveDataTransfer.h>")]
    public interface ISaveDataChunkIterator : IServiceObject
    {
        [MethodId(0)]
        Result Next();

        [MethodId(1)]
        Result IsEnd(Out<bool> outValue);

        [MethodId(16)]
        Result GetId(Out<uint32_t> outValue);
    }

    [CppRefPath(@"<nn/fssrv/sf/fssrv_ISaveDataTransfer.h>")]
    public interface ISaveDataChunkExporter : IServiceObject
    {
        [MethodId(0)]
        Result Pull(Out<uint64_t> outValue, OutBuffer buffer, uint64_t size);

        [MethodId(16)]
        Result GetRestRawDataSize(Out<int64_t> outValue);
    }

    [CppRefPath(@"<nn/fssrv/sf/fssrv_ISaveDataTransfer.h>")]
    public interface ISaveDataChunkImporter : IServiceObject
    {
        [MethodId(0)]
        Result Push(InBuffer buffer, uint64_t size);
    }

    [CppRefPath(@"<nn/fssrv/sf/fssrv_ISaveDataTransfer.h>")]
    public interface ISaveDataDivisionExporter : IServiceObject
    {
        [MethodId(0)]
        Result SetDivisionCount(int32_t count);

        [MethodId(16)]
        Result OpenSaveDataDiffChunkIterator(Out<ISaveDataChunkIterator> outValue);

        [MethodId(48)]
        Result OpenSaveDataChunkExporter(Out<ISaveDataChunkExporter> outValue, uint32_t saveDataChunkId);

        [MethodId(64)]
        Result FinalizeFullExport(Out<nn.fs.detail.KeySeed> outKeySeed, Out<nn.fs.detail.InitialDataMac> outInitialDataMac);

        [MethodId(65)]
        Result FinalizeDiffExport(Out<nn.fs.detail.InitialDataMac> outInitialDataMac);

        [MethodId(66)]
        Result CancelExport();

        [MethodId(80)]
        Result GetImportInitialDataAad(Out<nn.fs.detail.InitialDataAad> outValue);

        [MethodId(81)]
        Result SetExportInitialDataAad(nn.fs.detail.InitialDataAad aad);
    }

    [CppRefPath(@"<nn/fssrv/sf/fssrv_ISaveDataTransfer.h>")]
    public interface ISaveDataDivisionImporter : IServiceObject
    {
        [MethodId(16)]
        Result OpenSaveDataDiffChunkIterator(Out<ISaveDataChunkIterator> outValue);

        [MethodId(32)]
        Result InitializeImport(Out<int64_t> outRestSize, int64_t processSize);

        [MethodId(33)]
        Result FinalizeImport();

        [MethodId(34)]
        Result CancelImport();

        [MethodId(48)]
        Result OpenSaveDataChunkImporter(Out<ISaveDataChunkImporter> outValue, uint32_t saveDataChunkId);

        [MethodId(64)]
        Result GetImportInitialDataAad(Out<nn.fs.detail.InitialDataAad> outValue);
    }

    [CppRefPath(@"<nn/fssrv/sf/fssrv_ISaveDataTransfer.h>")]
    public interface ISaveDataTransferManagerWithDivision : IServiceObject
    {
        [MethodId(0)]
        Result GetChallenge(OutBuffer buffer);

        [MethodId(16)]
        Result SetKeySeedPackage(InBuffer buffer);

        [MethodId(32)]
        Result OpenSaveDataExporter(Out<ISaveDataDivisionExporter> outValue, uint8_t saveDataSpaceId, uint64_t saveDataId);

        [MethodId(33)]
        Result OpenSaveDataExporterForDiffExport(Out<ISaveDataDivisionExporter> outValue, InBuffer initialData, uint8_t saveDataSpaceId, uint64_t saveDataId);

        [MethodId(64)]
        Result OpenSaveDataImporter(Out<ISaveDataDivisionImporter> outValue, InBuffer buffer, fs.UserId userId, uint8_t saveDataSpaceId);

        [MethodId(65)]
        Result OpenSaveDataImporterForDiffImport(Out<ISaveDataDivisionImporter> outValue, InBuffer buffer, uint8_t saveDataSpaceId, uint64_t saveDataId);

        [MethodId(66)]
        Result OpenSaveDataImporterForDuplicateDiffImport(Out<ISaveDataDivisionImporter> outValue, InBuffer buffer, uint8_t saveDataSpaceId, uint64_t saveDataId);

    }

    [CppRefPath(@"<nn/fssrv/sf/fssrv_ISaveDataTransfer.h>")]
    public interface ISaveDataTransferProhibiter : IServiceObject
    {
    }

}
