﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <memory>

#include <nn/nn_Abort.h>
#include <nn/fs/fs_Result.h>
#include <nn/result/result_HandlingUtility.h>

#include "../detail/fssrv_SdmmcStorageService.h"
#include <nn/fssystem/fs_AllocatorUtility.h>
#include <nn/fs/fs_SubStorage.h>

#include <nn/fssrv/fscreator/fssrv_SdStorageCreator.h>

namespace nn { namespace fssrv { namespace fscreator {

namespace
{
    class SdCardStorage : public fs::SubStorage
    {
    public:
        SdCardStorage(IStorage* pBaseStorage, int64_t offset, int64_t size) NN_NOEXCEPT
            : SubStorage(pBaseStorage, offset, size)
        {
        }

        ~SdCardStorage()
        {
            detail::CloseSdStorage();
        }
    };
}

    // TODO: fssrv_SdmmcStorageService を解体してこちらに組み込む
    SdStorageCreator::SdStorageCreator() NN_NOEXCEPT
    {
    }

    Result SdStorageCreator::Create(std::shared_ptr<fs::IStorage>* outValue) NN_NOEXCEPT
    {
#if defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK1) || defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK2) || defined(NN_BUILD_CONFIG_HARDWARE_NX) || defined(NN_BUILD_CONFIG_HARDWARE_JETSONTX2)
        // TORIAEZU
        fs::IStorage* sdmmc;
        NN_RESULT_DO(detail::OpenSdStorage(&sdmmc));
        int64_t size;
        NN_RESULT_DO(sdmmc->GetSize(&size));
        std::shared_ptr<fs::IStorage> storage = fssystem::AllocateShared<SdCardStorage>(sdmmc, 0, size);
        NN_RESULT_THROW_UNLESS(storage, nn::fs::ResultAllocationMemoryFailedInSdStorageCreatorA());
        *outValue = std::move(storage);
        NN_RESULT_SUCCESS;
#else
        NN_UNUSED(outValue);
        return nn::fs::ResultPartitionNotFound();
#endif
    }

}}}
