﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <mutex>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_SdkLog.h>
#include <nn/fs/fs_Result.h>
#include <nn/fs/fs_ResultPrivate.h>
#include <nn/result/result_HandlingUtility.h>

#include "fssrv_SystemDataUpdateEventManager.h"
#include "fssrv_SystemDataUpdateEventNotifier.h"

namespace nn { namespace fssrv { namespace detail {

    SystemDataUpdateEventManager::SystemDataUpdateEventManager() NN_NOEXCEPT : m_Mutex(false)
    {
    }

    SystemDataUpdateEventManager::~SystemDataUpdateEventManager() NN_NOEXCEPT
    {
        // NN_SDK_ASSERT(m_List.empty());
    }

    Result SystemDataUpdateEventManager::CreateNotifier(std::unique_ptr<SystemDataUpdateEventNotifier>* outValue) NN_NOEXCEPT
    {
        std::lock_guard<nn::os::Mutex> scopedLock(m_Mutex);

        std::unique_ptr<SystemDataUpdateEventNotifier> pEventNotifier(new SystemDataUpdateEventNotifier(this));
        NN_RESULT_THROW_UNLESS(pEventNotifier, nn::fs::ResultAllocationMemoryFailedNew());

        NN_RESULT_DO(nn::os::CreateSystemEvent(pEventNotifier->GetEvent(), nn::os::EventClearMode_ManualClear, true));
        m_List.push_back(*(pEventNotifier.get()));

        *outValue = std::move(pEventNotifier);

        NN_RESULT_SUCCESS;
    }

    Result SystemDataUpdateEventManager::NotifySystemDataUpdateEvent() NN_NOEXCEPT
    {
        std::lock_guard<nn::os::Mutex> scopedLock(m_Mutex);

        for (auto& eventNotifier : m_List)
        {
            nn::os::SignalSystemEvent(eventNotifier.GetEvent());
        }

        NN_RESULT_SUCCESS;
    }

    // この関数は直接実行しないでください。 SystemDataUpdateEventManager のデストラクタでのみ呼ばれる想定です。
    void SystemDataUpdateEventManager::DeleteNotifier(SystemDataUpdateEventNotifier* pEventNotifier) NN_NOEXCEPT
    {
        std::lock_guard<nn::os::Mutex> scopedLock(m_Mutex);

        m_List.erase(m_List.iterator_to(*pEventNotifier));
    }

}}}
