﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <mutex>
#include <nn/nn_Common.h>
#include <nn/fs/fs_Result.h>
#include <nn/util/util_IntrusiveList.h>
#include <nn/os/os_Mutex.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/fs/detail/fs_Newable.h>

namespace nn { namespace fssrv { namespace detail {

class SaveDataPorterManager;

class Prohibitee : public nn::util::IntrusiveListBaseNode<Prohibitee>
{
public:
    explicit Prohibitee(SaveDataPorterManager* pPorterManager) NN_NOEXCEPT;
    Result Initialize() NN_NOEXCEPT;

public:
    virtual ~Prohibitee() NN_NOEXCEPT;
    virtual void Invalidate() NN_NOEXCEPT = 0;
    virtual ncm::ApplicationId GetApplicationId() NN_NOEXCEPT = 0;

private:
    bool m_IsRegistered = false;
    SaveDataPorterManager* m_pPorterManager;
};


class SaveDataPorterProhibiter : public nn::util::IntrusiveListBaseNode<SaveDataPorterProhibiter>, public fs::detail::Newable
{
public:
    SaveDataPorterProhibiter(SaveDataPorterManager* pPorterManager, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
        : m_pPorterManager(pPorterManager)
        , m_ApplicationId(applicationId)
    {
    }

    ~SaveDataPorterProhibiter() NN_NOEXCEPT;

    nn::ncm::ApplicationId GetApplicationId() const NN_NOEXCEPT
    {
        return m_ApplicationId;
    }

private:
    SaveDataPorterManager* m_pPorterManager;
    nn::ncm::ApplicationId m_ApplicationId;
};


class SaveDataPorterManager
{
public:
    SaveDataPorterManager() NN_NOEXCEPT
        : m_Mutex(false)
    {}

    // 既に禁止されている場合、リスト追加は失敗し false が返る
    bool RegisterPorter(Prohibitee* pPorter, ncm::ApplicationId applicationId) NN_NOEXCEPT;

    void UnregisterPorter(Prohibitee* pPorter) NN_NOEXCEPT;

    // 既に存在する porter を全て無効化する
    void RegisterProhibiter(SaveDataPorterProhibiter* pProhibiter) NN_NOEXCEPT;

    void UnregisterProhibiter(SaveDataPorterProhibiter* pProhibiter) NN_NOEXCEPT;

private:
    typedef nn::util::IntrusiveList<Prohibitee, nn::util::IntrusiveListBaseNodeTraits<Prohibitee>> PorterList;
    typedef nn::util::IntrusiveList<SaveDataPorterProhibiter, nn::util::IntrusiveListBaseNodeTraits<SaveDataPorterProhibiter>> ProhibiterList;

private:
    PorterList     m_PorterList;
    ProhibiterList m_ProhibiterList;
    os::Mutex      m_Mutex; // m_PorterList と m_ProhibiterList が対象
};


}}}

