﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/crypto/crypto_Aes128GcmEncryptor.h>
#include <nn/fssrv/fssrv_SaveDataIndexerTypes.h>
#include <nn/fssrv/sf/fssrv_ISaveDataTransfer.h>
#include <nn/fs/fsa/fs_IFile.h>

namespace nn { namespace fssrv { namespace detail {

    class SaveDataExporter
    {
    public:
        SaveDataExporter(
            std::unique_ptr<fs::SaveDataExtraData> pSaveDataExtraData,
            const fs::SaveDataInfo& info,
            std::shared_ptr<fs::fsa::IFile>&& file,
            int64_t fileSize,
            std::unique_ptr<crypto::Aes128GcmEncryptor>&& initialDataEncryptor,
            std::unique_ptr<crypto::Aes128GcmEncryptor>&& encryptor,
            uint32_t version) NN_NOEXCEPT;

        // sf
        nn::Result GetSaveDataInfo(nn::sf::Out<nn::fs::SaveDataInfo> outValue) NN_NOEXCEPT;
        nn::Result GetRestSize(nn::sf::Out<std::uint64_t> outValue) NN_NOEXCEPT;
        nn::Result Pull(nn::sf::Out<std::uint64_t> outValue, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT;
        nn::Result PullInitialData(const nn::sf::OutBuffer& buffer) NN_NOEXCEPT;

    private:
        std::unique_ptr<fs::SaveDataExtraData> m_pSaveDataExtraData;
        fs::SaveDataInfo m_SaveDataInfo;
        uint64_t m_Pulled;
        uint64_t m_Length;
        std::shared_ptr<fs::fsa::IFile> m_pFile;
        int64_t m_FileOffset;
        std::unique_ptr<crypto::Aes128GcmEncryptor> m_pInitialDataEncryptor;
        std::unique_ptr<crypto::Aes128GcmEncryptor> m_pEncryptor;
        uint32_t m_Version;
    };

}}}
