﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>

#include <nn/nn_Common.h>
#include <nn/fs/fs_Result.h>
#include <nn/fs/fs_Bis.h>
#include <nn/fs/fs_IStorage.h>

namespace nn { namespace fssrv { namespace detail {


struct Guid
{
    uint32_t data1;
    uint16_t data2;
    uint16_t data3;
    uint16_t data4;
    uint8_t  data5[6];
};
NN_STATIC_ASSERT(std::is_pod<Guid>::value);

Result OpenGptPartition(std::unique_ptr<nn::fs::IStorage>* outValue, nn::fs::IStorage* baseStorage, const Guid* pTargetGuid) NN_NOEXCEPT;

}}}
