﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace fssrv { namespace detail {

    class AccessControlBits
    {
    public:
        NN_IMPLICIT AccessControlBits(Bit64 value) NN_NOEXCEPT
          : m_Value(value)
        {
        }

#define DEFINE_ACCESS(all, bits, name) bool name() const NN_NOEXCEPT { return (all) || (m_Value & (bits)); }

        // Content Mount (RO)
        DEFINE_ACCESS(0, 0x8000000000000801ULL, CanMountLogoRead)
        DEFINE_ACCESS(0, 0x8000000000000801ULL, CanMountContentMetaRead)
        DEFINE_ACCESS(0, 0x8000000000000801ULL, CanMountContentControlRead)
        DEFINE_ACCESS(0, 0x8000000000000801ULL, CanMountContentManualRead)
        DEFINE_ACCESS(0, 0x8000000000000801ULL, CanMountContentDataRead)
        DEFINE_ACCESS(0, 0x8000000000000801ULL, CanMountApplicationPackageRead)

        // SystemData Mount (RO) TORIAEZU: SystemSaveData 権限でもアクセス可能
        DEFINE_ACCESS(0, 0x8000000000100008ULL, CanMountSystemDataPrivateRead)

        // SystemData Update Event TORIAEZU: SystemSaveData 権限でもアクセス可能
        DEFINE_ACCESS(0, 0x8000000000100008ULL, CanOpenSystemDataUpdateEventNotifier)

        // Notify SystemData Update Event
        DEFINE_ACCESS(0, 0x8000000000010000ULL, CanNotifySystemDataUpdateEvent)

        // System Storage Mount (R/W)
        DEFINE_ACCESS(0, 0x8000000000000000ULL, CanMountSaveDataStorageRead)
        DEFINE_ACCESS(0, 0x8000000000000000ULL, CanMountSaveDataStorageWrite)
        DEFINE_ACCESS(0, 0x8000000000000800ULL, CanMountContentStorageRead)
        DEFINE_ACCESS(0, 0x8000000000000800ULL, CanMountContentStorageWrite)
        DEFINE_ACCESS(0, 0x8000000000001000ULL, CanMountImageAndVideoStorageRead)
        DEFINE_ACCESS(0, 0x8000000000001000ULL, CanMountImageAndVideoStorageWrite)

        // Bis Mount (R/W)
        DEFINE_ACCESS(0, 0x8000000000000084ULL, CanMountBisCalibrationFileRead)
        DEFINE_ACCESS(0, 0x8000000000000084ULL, CanMountBisCalibrationFileWrite)
        DEFINE_ACCESS(0, 0x8000000000000080ULL, CanMountBisSafeModeRead)
        DEFINE_ACCESS(0, 0x8000000000000080ULL, CanMountBisSafeModeWrite)
        DEFINE_ACCESS(0, 0x8000000000008080ULL, CanMountBisUserRead)
        DEFINE_ACCESS(0, 0x8000000000008080ULL, CanMountBisUserWrite)
        DEFINE_ACCESS(0, 0x8000000000008080ULL, CanMountBisSystemRead)
        DEFINE_ACCESS(0, 0x8000000000008080ULL, CanMountBisSystemWrite)
        DEFINE_ACCESS(0, 0x8000000000000080ULL, CanMountBisSystemProperEncryptionRead)
        DEFINE_ACCESS(0, 0x8000000000000080ULL, CanMountBisSystemProperEncryptionWrite)
        DEFINE_ACCESS(0, 0x8000000000000080ULL, CanMountBisSystemProperPartitionRead)
        DEFINE_ACCESS(0, 0x8000000000000080ULL, CanMountBisSystemProperPartitionWrite)

        // SD Mount (R/W)
        DEFINE_ACCESS(0, 0xC000000000200000ULL, CanMountSdCardRead)
        DEFINE_ACCESS(0, 0xC000000000200000ULL, CanMountSdCardWrite)

        // GC Mount (RO)
        DEFINE_ACCESS(0, 0x8000000000000010ULL, CanMountGameCardRead)

        // Host Mount (R/W)
        DEFINE_ACCESS(0, 0xC000000000400000ULL, CanMountHostRead)
        DEFINE_ACCESS(0, 0xC000000000400000ULL, CanMountHostWrite)

        // Save Mount (R/W)
        DEFINE_ACCESS(0, 0x8000000000040020ULL, CanMountDeviceSaveDataRead)
        DEFINE_ACCESS(0, 0x8000000000040020ULL, CanMountDeviceSaveDataWrite)
        DEFINE_ACCESS(0, 0x8000000000000028ULL, CanMountSystemSaveDataRead)
        DEFINE_ACCESS(0, 0x8000000000000028ULL, CanMountSystemSaveDataWrite)
        DEFINE_ACCESS(0, 0x8000000000000020ULL, CanMountOthersSaveDataRead)
        DEFINE_ACCESS(0, 0x8000000000000020ULL, CanMountOthersSaveDataWrite)
        DEFINE_ACCESS(0, 0x8000000000000020ULL, CanMountOthersSystemSaveDataRead)
        DEFINE_ACCESS(0, 0x8000000000000020ULL, CanMountOthersSystemSaveDataWrite)

        // Upp Mount (RO)
        DEFINE_ACCESS(0, 0x8000000000010000ULL, CanMountRegisteredUpdatePartitionRead)

        // Bis Raw (R/W)
        DEFINE_ACCESS(0, 0x8000000000010082ULL, CanOpenBisPartitionBootPartition1RootRead)
        DEFINE_ACCESS(0, 0x8000000000010082ULL, CanOpenBisPartitionBootPartition1RootWrite)
        DEFINE_ACCESS(0, 0x8000000000010080ULL, CanOpenBisPartitionBootPartition2RootRead)
        DEFINE_ACCESS(0, 0x8000000000010080ULL, CanOpenBisPartitionBootPartition2RootWrite)
        DEFINE_ACCESS(0, 0x8000000000000080ULL, CanOpenBisPartitionUserDataRootRead)
        DEFINE_ACCESS(0, 0x8000000000000080ULL, CanOpenBisPartitionUserDataRootWrite)
        DEFINE_ACCESS(0, 0x8000000000010080ULL, CanOpenBisPartitionBootConfigAndPackage2Part1Read)
        DEFINE_ACCESS(0, 0x8000000000010080ULL, CanOpenBisPartitionBootConfigAndPackage2Part1Write)
        DEFINE_ACCESS(0, 0x8000000000010080ULL, CanOpenBisPartitionBootConfigAndPackage2Part2Read)
        DEFINE_ACCESS(0, 0x8000000000010080ULL, CanOpenBisPartitionBootConfigAndPackage2Part2Write)
        DEFINE_ACCESS(0, 0x8000000000010080ULL, CanOpenBisPartitionBootConfigAndPackage2Part3Read)
        DEFINE_ACCESS(0, 0x8000000000010080ULL, CanOpenBisPartitionBootConfigAndPackage2Part3Write)
        DEFINE_ACCESS(0, 0x8000000000010080ULL, CanOpenBisPartitionBootConfigAndPackage2Part4Read)
        DEFINE_ACCESS(0, 0x8000000000010080ULL, CanOpenBisPartitionBootConfigAndPackage2Part4Write)
        DEFINE_ACCESS(0, 0x8000000000010080ULL, CanOpenBisPartitionBootConfigAndPackage2Part5Read)
        DEFINE_ACCESS(0, 0x8000000000010080ULL, CanOpenBisPartitionBootConfigAndPackage2Part5Write)
        DEFINE_ACCESS(0, 0x8000000000010080ULL, CanOpenBisPartitionBootConfigAndPackage2Part6Read)
        DEFINE_ACCESS(0, 0x8000000000010080ULL, CanOpenBisPartitionBootConfigAndPackage2Part6Write)
        DEFINE_ACCESS(0, 0x8000000000000084ULL, CanOpenBisPartitionCalibrationBinaryRead)
        DEFINE_ACCESS(0, 0x8000000000000084ULL, CanOpenBisPartitionCalibrationBinaryWrite)
        DEFINE_ACCESS(0, 0x8000000000000084ULL, CanOpenBisPartitionCalibrationFileRead)
        DEFINE_ACCESS(0, 0x8000000000000084ULL, CanOpenBisPartitionCalibrationFileWrite)
        DEFINE_ACCESS(0, 0x8000000000000080ULL, CanOpenBisPartitionSafeModeRead)
        DEFINE_ACCESS(0, 0x8000000000000080ULL, CanOpenBisPartitionSafeModeWrite)
        DEFINE_ACCESS(0, 0x8000000000000080ULL, CanOpenBisPartitionUserRead)
        DEFINE_ACCESS(0, 0x8000000000000080ULL, CanOpenBisPartitionUserWrite)
        DEFINE_ACCESS(0, 0x8000000000000080ULL, CanOpenBisPartitionSystemRead)
        DEFINE_ACCESS(0, 0x8000000000000080ULL, CanOpenBisPartitionSystemWrite)
        DEFINE_ACCESS(0, 0x8000000000000080ULL, CanOpenBisPartitionSystemProperEncryptionRead)
        DEFINE_ACCESS(0, 0x8000000000000080ULL, CanOpenBisPartitionSystemProperEncryptionWrite)
        DEFINE_ACCESS(0, 0x8000000000000080ULL, CanOpenBisPartitionSystemProperPartitionRead)
        DEFINE_ACCESS(0, 0x8000000000000080ULL, CanOpenBisPartitionSystemProperPartitionWrite)

        // SD Raw (R/W)
        DEFINE_ACCESS(0, 0xC000000000200000ULL, CanOpenSdCardStorageRead)
        DEFINE_ACCESS(0, 0xC000000000200000ULL, CanOpenSdCardStorageWrite)
        DEFINE_ACCESS(0, 0x8000000004000000ULL, CanFormatSdCard)

        // GC Raw (R/W)
        DEFINE_ACCESS(0, 0x8000000000000100ULL, CanOpenGameCardStorageRead)
        DEFINE_ACCESS(0, 0x8000000000000100ULL, CanOpenGameCardStorageWrite)

        // Bis Operation
        DEFINE_ACCESS(0, 0x8000000000000080ULL, CanInvalidateBisCache)
        DEFINE_ACCESS(0, 0x8000000000000080ULL, CanEraseMmc)
        DEFINE_ACCESS(0, 0xC000000000800000ULL, CanFillBis)

        // GC Operation
        DEFINE_ACCESS(0, 0x8000000000000010ULL, CanGetGameCardDeviceCertificate)
        DEFINE_ACCESS(0, 0x8000000000000010ULL, CanGetGameCardIdSet)
        DEFINE_ACCESS(0, 0x8000000000000200ULL, CanFinalizeGameCardDriver)
        DEFINE_ACCESS(0, 0x8000000000000200ULL, CanGetGameCardAsicInfo)

        // Save Operation
        DEFINE_ACCESS(0, 0x8000000000002020ULL, CanCreateSaveData)
        DEFINE_ACCESS(0, 0x8000000000000060ULL, CanDeleteSaveData)
        DEFINE_ACCESS(0, 0x8000000000000028ULL, CanCreateSystemSaveData)
        DEFINE_ACCESS(0, 0x8000000000000020ULL, CanCreateOthersSystemSaveData)
        DEFINE_ACCESS(0, 0x8000000000004028ULL, CanDeleteSystemSaveData)
        DEFINE_ACCESS(0, 0x8000000000000060ULL, CanOpenSaveDataInfoReader)
        DEFINE_ACCESS(0, 0x8000000000004020ULL, CanOpenSaveDataInfoReaderForSystem)
        DEFINE_ACCESS(0, 0x8000000000000000ULL, CanOpenSaveDataInfoReaderForInternal)
        DEFINE_ACCESS(0, 0x8000000000020000ULL, CanOpenSaveDataMetaFile)
        DEFINE_ACCESS(0, 0x8000000000004060ULL, CanReadSaveDataFileSystemExtraData)
        DEFINE_ACCESS(0, 0x8000000000000020ULL, CanWriteSaveDataFileSystemExtraDataTimeStamp)
        DEFINE_ACCESS(0, 0x8000000000004020ULL, CanWriteSaveDataFileSystemExtraDataFlags)
        DEFINE_ACCESS(0, 0x8000000000000020ULL, CanWriteSaveDataFileSystemExtraDataCommitId)
        DEFINE_ACCESS(0, 0x8000000000000000ULL, CanWriteSaveDataFileSystemExtraDataAll)
        DEFINE_ACCESS(0, 0xC000000001000000ULL, CanCorruptSaveData)
        DEFINE_ACCESS(0, 0x8000000001000060ULL, CanCorruptSystemSaveData)
        DEFINE_ACCESS(0, 0x8000000000000060ULL, CanVerifySaveData)
        DEFINE_ACCESS(0, 0xC000000002000000ULL, CanDebugSaveData)
        DEFINE_ACCESS(0, 0x8000000000002020ULL, CanExtendSaveData)
        DEFINE_ACCESS(0, 0x8000000000000028ULL, CanExtendSystemSaveData)

        // Time Operation
        DEFINE_ACCESS(0, 0x8000000000000400ULL, CanSetCurrentPosixTime)

        // Settings Control Operation
        DEFINE_ACCESS(0, 0x8000000000080000ULL, CanSetGlobalAccessLogMode)
        DEFINE_ACCESS(0, 0x8000000000080000ULL, CanSetSpeedEmulationMode)
        DEFINE_ACCESS(0, 0x8000000000080000ULL, CanSetDataStorageRedirectTarget)

        // Rights Id Operation
        DEFINE_ACCESS(0, 0x8000000008000000ULL, CanGetRightsId)
        DEFINE_ACCESS(0, 0x8000000010000000ULL, CanRegisterExternalKey)

        // Encryption Setting Operation
        DEFINE_ACCESS(0, 0x8000000000000800ULL, CanSetEncryptionSeed)

        // Updater Operation
        DEFINE_ACCESS(0, 0x8000000020000000ULL, CanRegisterUpdatePartition)

        // Save Data Transfer Operation
        DEFINE_ACCESS(0, 0x8000000040000000ULL, CanOpenSaveDataTransferManager)
        DEFINE_ACCESS(0, 0x8000000040000000ULL, CanQuerySaveDataInternalStorageTotalSize)

        // Save Data Transfer Operation for Cloud Backup
        DEFINE_ACCESS(0, 0x8000000200000000ULL, CanOpenSaveDataTransferManagerVersion2)
        DEFINE_ACCESS(0, 0x8000000200000000ULL, CanOpenSaveDataTransferProhibiter)
        DEFINE_ACCESS(0, 0x8000000200000020ULL, CanGetSaveDataCommitId)
        DEFINE_ACCESS(0, 0x8000000200000000ULL, CanMountCloudBackupWorkStorageRead)
        DEFINE_ACCESS(0, 0x8000000200000000ULL, CanMountCloudBackupWorkStorageWrite)
        DEFINE_ACCESS(0, 0x8000000200002000ULL, CanListAccessibleSaveDataOwnerId)

        // Mmc Patrol Operation
        DEFINE_ACCESS(0, 0x8000000000000000ULL, CanControlMmcPatrol)

        // Save Data Transfer Debug Operation
        DEFINE_ACCESS(0, 0x8000000000000000ULL, CanOverrideSaveDataTransferTokenSignVerificationKey)

        // Save Data Dump and Restore Debug Operation
        DEFINE_ACCESS(0, 0x8000000000000000ULL, CanOpenSaveDataInternalStorageRead)
        DEFINE_ACCESS(0, 0x8000000000000000ULL, CanOpenSaveDataInternalStorageWrite)
        DEFINE_ACCESS(0, 0x8000000000000000ULL, CanCreateSaveDataWithHashSalt)

        // Device Detection
        DEFINE_ACCESS(0, 0x8000000080200000ULL, CanOpenSdCardDetectionEventNotifier)
        DEFINE_ACCESS(0, 0x8000000080000110ULL, CanOpenGameCardDetectionEventNotifier)

        // Device Simulation Operation
        DEFINE_ACCESS(0, 0xC000000000000000ULL, CanSimulateDevice)

        // Access Failure Resolution
        DEFINE_ACCESS(0, 0x8000000100000000ULL, CanOpenAccessFailureDetectionEventNotifier)
        DEFINE_ACCESS(0, 0x8000000100000000ULL, CanGetAccessFailureDetectionEvent)
        DEFINE_ACCESS(0, 0x8000000100000000ULL, CanIsAccessFailureDetected)
        DEFINE_ACCESS(0, 0x8000000100000000ULL, CanResolveAccessFailure)
        DEFINE_ACCESS(0, 0x8000000100000000ULL, CanAbandonAccessFailure)

        DEFINE_ACCESS(0, 0x8000000000200000ULL, CanSetSdCardAccessibility)

        const Bit64 GetValue() NN_NOEXCEPT
        {
            return m_Value;
        }

    private:
        const Bit64 m_Value;
    };

}}}
