﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/fs/fs_Result.h>
#include <nn/fs/fs_SdmmcControl.h>
#include <nn/fs/detail/fs_ResultHandlingUtility.h>
#include <nn/fssrv/sf/fssrv_IFileSystemProxy.h>
#include <nn/fssrv/sf/fssrv_IDeviceOperator.h>
#include "fs_FileSystemProxyServiceObject.h"

namespace nn { namespace fs {

Result GetSdmmcConnectionStatus(SdmmcSpeedMode* pOutSdmmcSpeedMode, SdmmcBusWidth* pOutSdmmcBusWidth, SdmmcPort sdmmcPort) NN_NOEXCEPT
{
    NN_FS_RESULT_THROW_UNLESS(pOutSdmmcSpeedMode != nullptr, ResultNullptrArgument());
    NN_FS_RESULT_THROW_UNLESS(pOutSdmmcBusWidth != nullptr, ResultNullptrArgument());

    nn::sf::SharedPointer<nn::fssrv::sf::IFileSystemProxy> fileSystemProxy = detail::GetFileSystemProxyServiceObject();
    nn::sf::SharedPointer<nn::fssrv::sf::IDeviceOperator> deviceOperator;
    NN_FS_RESULT_DO(fileSystemProxy->OpenDeviceOperator(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IDeviceOperator>>(&deviceOperator)));
    int32_t sdmmcSpeedMode = static_cast<int32_t>(SdmmcSpeedMode_Unknown);
    int32_t sdmmcBusWidth = static_cast<int32_t>(SdmmcBusWidth_Unknown);
    // nn::sdmmc::Result も含めて、そのまま返したいため NN_FS_RESULT_DO は使用しない
    NN_RESULT_DO(deviceOperator->GetSdmmcConnectionStatus(nn::sf::Out<int32_t>(&sdmmcSpeedMode), nn::sf::Out<int32_t>(&sdmmcBusWidth), static_cast<int32_t>(sdmmcPort)));
    *pOutSdmmcSpeedMode = static_cast<SdmmcSpeedMode>(sdmmcSpeedMode);
    *pOutSdmmcBusWidth = static_cast<SdmmcBusWidth>(sdmmcBusWidth);
    NN_RESULT_SUCCESS;
}

Result SuspendSdmmcControl() NN_NOEXCEPT
{
    nn::sf::SharedPointer<nn::fssrv::sf::IFileSystemProxy> fileSystemProxy = detail::GetFileSystemProxyServiceObject();
    nn::sf::SharedPointer<nn::fssrv::sf::IDeviceOperator> deviceOperator;
    NN_FS_RESULT_DO(fileSystemProxy->OpenDeviceOperator(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IDeviceOperator>>(&deviceOperator)));
    NN_FS_RESULT_DO(deviceOperator->SuspendSdmmcControl());
    NN_RESULT_SUCCESS;
}

Result ResumeSdmmcControl() NN_NOEXCEPT
{
    nn::sf::SharedPointer<nn::fssrv::sf::IFileSystemProxy> fileSystemProxy = detail::GetFileSystemProxyServiceObject();
    nn::sf::SharedPointer<nn::fssrv::sf::IDeviceOperator> deviceOperator;
    NN_FS_RESULT_DO(fileSystemProxy->OpenDeviceOperator(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IDeviceOperator>>(&deviceOperator)));
    NN_FS_RESULT_DO(deviceOperator->ResumeSdmmcControl());
    NN_RESULT_SUCCESS;
}

}}
