﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>

#include <nn/nn_Common.h>


namespace nn { namespace fs { namespace fsa {

class IFile;
class IFileSystem;

}}}  // namespace nn::fs::fsa


namespace nn { namespace fs { namespace detail {

class IFileDataCache;
class FileDataCacheAccessResult;

class FileDataCacheAccessor
{
private:
    IFileDataCache* m_pFileDataCache;

public:
    explicit FileDataCacheAccessor(IFileDataCache* pFileDataCache) NN_NOEXCEPT;

    Result Read(
        fsa::IFile* pFile,
        size_t* outValue,
        int64_t offset,
        void* pBuffer,
        size_t size,
        const ReadOption& option,
        FileDataCacheAccessResult* pAccessResult) NN_NOEXCEPT;

    void Purge(fsa::IFileSystem* pFileSystem) NN_NOEXCEPT;
};

}}}  // namespace nn::fs::detail
