﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <memory>

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include <nn/fs/detail/fs_IFileDataCache.h>

#include "fs_FileDataCacheAccessor.h"


namespace nn { namespace fs { namespace detail {

FileDataCacheAccessor::FileDataCacheAccessor(IFileDataCache* pFileDataCache) NN_NOEXCEPT
    : m_pFileDataCache(pFileDataCache)
{
}

Result FileDataCacheAccessor::Read(
    fsa::IFile* pFile,
    size_t* outValue,
    int64_t offset,
    void* pBuffer,
    size_t size,
    const ReadOption& option,
    FileDataCacheAccessResult* pAccessResult) NN_NOEXCEPT
{
    return m_pFileDataCache->Read(pFile, outValue, offset, pBuffer, size, option, pAccessResult);
}

void FileDataCacheAccessor::Purge(fsa::IFileSystem* pFileSystem) NN_NOEXCEPT
{
    m_pFileDataCache->Purge(pFileSystem);
}

}}}  // namespace nn::fs::detail
