﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace nn { namespace fs { namespace detail {

    class FileSystemAccessor;

    Result Register(std::unique_ptr<FileSystemAccessor>&& fileSystem) NN_NOEXCEPT;
    Result Find(detail::FileSystemAccessor** outValue, const char* name) NN_NOEXCEPT;
    void Unregister(const char* name) NN_NOEXCEPT;
}}}
