﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkAssert.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/fs/fs_FileSystem.h>
#include <nn/fs/fs_FileSystemForDebug.h>
#include <nn/fs/fs_Result.h>
#include <nn/fs/detail/fs_AccessLog.h>
#include "shim/fs_Library.h"
#include "fs_FileSystemAccessor.h"
#include "fs_MountUtility.h"
#include <nn/fs/detail/fs_ResultHandlingUtility.h>

namespace nn { namespace fs {

Result GetFileTimeStampRawForDebug(FileTimeStampRaw *outTimeStamp, const char* path) NN_NOEXCEPT
{
    detail::FileSystemAccessor* system;
    NN_FS_RESULT_DO(detail::FindFileSystem(&system, path));

    NN_FS_RESULT_DO(system->GetFileTimeStampRaw(outTimeStamp, detail::GetSubPath(path)));
    NN_RESULT_SUCCESS;
}

}}
