﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

struct ifnet;

namespace nn     {
namespace eth    {
namespace device {

class SocketIf
{
private:
    struct ifnet*      m_pIfnet;
    bool               m_LinkState;
    int                m_Mtu;

public:
    virtual nn::Result GetFrameFromStack(size_t* pLenthOut, uint8_t* pData, int length) NN_NOEXCEPT;
    virtual nn::Result SendFrameToStack(uint8_t* pData, int length) NN_NOEXCEPT;
    virtual nn::Result UpdateMtu(int mtu) NN_NOEXCEPT;
    virtual nn::Result UpdateMultiFilter(struct ifnet *pIfnet) NN_NOEXCEPT;
    int                GetMtu() NN_NOEXCEPT;
    virtual int        Ioctl(uint32_t command, char* pData) NN_NOEXCEPT;
    virtual void       Init() NN_NOEXCEPT;
    virtual void       Start() NN_NOEXCEPT;
    virtual void       Stop() NN_NOEXCEPT;
    static  void       StartEntry(struct ifnet *pIfnet) NN_NOEXCEPT;
    static  int        IoctlEntry(struct ifnet *pIfnet, unsigned long command, char* pData) NN_NOEXCEPT;
    static  void       InitEntry(void* argument) NN_NOEXCEPT;
    void               SetLinkState(bool linkStateUp) NN_NOEXCEPT;
    nn::Result         Initialize(char* pInterfaceName, int interfaceInstance, uint8_t* pMacAddress) NN_NOEXCEPT;
    nn::Result         Finalize() NN_NOEXCEPT;
};

}}}
