﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * このファイルは直接編集しないで下さい。
 * このファイルは自動生成されます。
 * Don't edit this file directly.
 * This file is generated automatically.
 */

#include <nnc/nn_Common.h>
#include <nnc/result/result_CConverter.h>

#include <nnc/dt/dt_Api.h>
#include <nn/dt.h>
#include <nn/dt/dt_DebugApi.h>

extern "C"
{


nnResult nndtGetInterruptCount(int * pOutCount, const nndtNode * pNode)
{
    auto result = ::nn::dt::GetInterruptCount
    (
        pOutCount, reinterpret_cast<const nn::dt::Node *>(pNode)
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetInterrupt(nndtInterruptInfo * pOutInfo, const nndtNode * pNode)
{
    auto result = ::nn::dt::GetInterrupt
    (
        reinterpret_cast<nn::dt::InterruptInfo *>(pOutInfo), reinterpret_cast<const nn::dt::Node *>(pNode)
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetInterruptArray(nndtInterruptInfo * pOutArray, int count, const nndtNode * pNode)
{
    auto result = ::nn::dt::GetInterruptArray
    (
        reinterpret_cast<nn::dt::InterruptInfo *>(pOutArray), count, reinterpret_cast<const nn::dt::Node *>(pNode)
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetInterruptList(nndtInterruptInfo * pOutList, int * pOutCount, int maxCount, const nndtNode * pNode)
{
    auto result = ::nn::dt::GetInterruptList
    (
        reinterpret_cast<nn::dt::InterruptInfo *>(pOutList), pOutCount, maxCount, reinterpret_cast<const nn::dt::Node *>(pNode)
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtFindNodeByPath(nndtNode * pOutNode, const char * path)
{
    auto result = ::nn::dt::FindNodeByPath
    (
        reinterpret_cast<nn::dt::Node *>(pOutNode), path
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtFindNodeByPHandle(nndtNode * pOutNode, nndtPHandle phandle)
{
    auto result = ::nn::dt::FindNodeByPHandle
    (
        reinterpret_cast<nn::dt::Node *>(pOutNode), static_cast<nn::dt::PHandle>(phandle)
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetCompatibleNodeCount(int * pOutCount, const char * compatible)
{
    auto result = ::nn::dt::GetCompatibleNodeCount
    (
        pOutCount, compatible
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtListCompatibleNode(nndtNode * pOutNodeList, int * pOutCount, int maxCount, const char * compatible)
{
    auto result = ::nn::dt::ListCompatibleNode
    (
        reinterpret_cast<nn::dt::Node *>(pOutNodeList), pOutCount, maxCount, compatible
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetParentNode(nndtNode * pOutNode, const nndtNode * pCurrentNode)
{
    auto result = ::nn::dt::GetParentNode
    (
        reinterpret_cast<nn::dt::Node *>(pOutNode), reinterpret_cast<const nn::dt::Node *>(pCurrentNode)
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetChildNodeByName(nndtNode * pOutNode, const nndtNode * pCurrentNode, const char * name)
{
    auto result = ::nn::dt::GetChildNodeByName
    (
        reinterpret_cast<nn::dt::Node *>(pOutNode), reinterpret_cast<const nn::dt::Node *>(pCurrentNode), name
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetChildNodeCount(int * pOutCount, const nndtNode * pCurrentNode)
{
    auto result = ::nn::dt::GetChildNodeCount
    (
        pOutCount, reinterpret_cast<const nn::dt::Node *>(pCurrentNode)
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtListChildNode(nndtNode * pOutNodeList, int * pOutCount, int maxCount, const nndtNode * pCurrentNode)
{
    auto result = ::nn::dt::ListChildNode
    (
        reinterpret_cast<nn::dt::Node *>(pOutNodeList), pOutCount, maxCount, reinterpret_cast<const nn::dt::Node *>(pCurrentNode)
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetFirstChildNode(nndtNode * pOutNode, const nndtNode * pCurrentNode)
{
    auto result = ::nn::dt::GetFirstChildNode
    (
        reinterpret_cast<nn::dt::Node *>(pOutNode), reinterpret_cast<const nn::dt::Node *>(pCurrentNode)
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetNextSiblingNode(nndtNode * pOutNode, const nndtNode * pCurrentNode)
{
    auto result = ::nn::dt::GetNextSiblingNode
    (
        reinterpret_cast<nn::dt::Node *>(pOutNode), reinterpret_cast<const nn::dt::Node *>(pCurrentNode)
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetValueOfAddressCells(uint32_t * pOutValue, const nndtNode * pNode)
{
    auto result = ::nn::dt::GetValueOfAddressCells
    (
        pOutValue, reinterpret_cast<const nn::dt::Node *>(pNode)
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetValueOfSizeCells(uint32_t * pOutValue, const nndtNode * pNode)
{
    auto result = ::nn::dt::GetValueOfSizeCells
    (
        pOutValue, reinterpret_cast<const nn::dt::Node *>(pNode)
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtIsPropertyExist(bool * pOut, const nndtNode * pNode, const char * name)
{
    auto result = ::nn::dt::IsPropertyExist
    (
        pOut, reinterpret_cast<const nn::dt::Node *>(pNode), name
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtGetPropertySize(size_t * pOutSize, const nndtNode * pNode, const char * name)
{
    auto result = ::nn::dt::GetPropertySize
    (
        pOutSize, reinterpret_cast<const nn::dt::Node *>(pNode), name
    );
    return nn::result::ConvertToC(result);
}

/* template function
nnResult nndtGetPropertyCount(int * pOutCount, const nndtNode * pNode, const char * name)
{
    auto result = ::nn::dt::GetPropertyCount
    (
        pOutCount, reinterpret_cast<const nn::dt::Node *>(pNode), name
    );
    return nn::result::ConvertToC(result);
}
*/

/* template function
nnResult nndtGetProperty(T * pOutValue, const nndtNode * pNode, const char * name)
{
    auto result = ::nn::dt::GetProperty
    (
        pOutValue, reinterpret_cast<const nn::dt::Node *>(pNode), name
    );
    return nn::result::ConvertToC(result);
}
*/

/* template function
nnResult nndtGetProperty(T * pOutValue, const nndtNode * pNode, const char * name, int index)
{
    auto result = ::nn::dt::GetProperty
    (
        pOutValue, reinterpret_cast<const nn::dt::Node *>(pNode), name, index
    );
    return nn::result::ConvertToC(result);
}
*/

/* template function
nnResult nndtGetPropertyArray(T * pOutArray, int count, const nndtNode * pNode, const char * name)
{
    auto result = ::nn::dt::GetPropertyArray
    (
        pOutArray, count, reinterpret_cast<const nn::dt::Node *>(pNode), name
    );
    return nn::result::ConvertToC(result);
}
*/

/* template function
nnResult nndtGetPropertyList(T * pOutList, int * pOutCount, int maxCount, const nndtNode * pNode, const char * name)
{
    auto result = ::nn::dt::GetPropertyList
    (
        pOutList, pOutCount, maxCount, reinterpret_cast<const nn::dt::Node *>(pNode), name
    );
    return nn::result::ConvertToC(result);
}
*/

nnResult nndtGetPropertyString(size_t * pOutSize, char * pOutBuffer, size_t bufferSize, const nndtNode * pNode, const char * name)
{
    auto result = ::nn::dt::GetPropertyString
    (
        pOutSize, pOutBuffer, bufferSize, reinterpret_cast<const nn::dt::Node *>(pNode), name
    );
    return nn::result::ConvertToC(result);
}

/* template function
nnResult nndtGetRegisterAddress(T * pOutAddress, const nndtNode * pNode)
{
    auto result = ::nn::dt::GetRegisterAddress
    (
        pOutAddress, reinterpret_cast<const nn::dt::Node *>(pNode)
    );
    return nn::result::ConvertToC(result);
}
*/

/* template function
nnResult nndtGetRegisterAddressArray(T * pOutArray, int count, const nndtNode * pNode)
{
    auto result = ::nn::dt::GetRegisterAddressArray
    (
        pOutArray, count, reinterpret_cast<const nn::dt::Node *>(pNode)
    );
    return nn::result::ConvertToC(result);
}
*/

/* template function
nnResult nndtGetRegisterAddressList(T * pOutList, int * pOutCount, int maxCount, const nndtNode * pNode)
{
    auto result = ::nn::dt::GetRegisterAddressList
    (
        pOutList, pOutCount, maxCount, reinterpret_cast<const nn::dt::Node *>(pNode)
    );
    return nn::result::ConvertToC(result);
}
*/

/* template function
nnResult nndtGetRegisterSize(T * pOutSize, const nndtNode * pNode)
{
    auto result = ::nn::dt::GetRegisterSize
    (
        pOutSize, reinterpret_cast<const nn::dt::Node *>(pNode)
    );
    return nn::result::ConvertToC(result);
}
*/

/* template function
nnResult nndtGetRegisterSizeArray(T * pOutArray, int count, const nndtNode * pNode)
{
    auto result = ::nn::dt::GetRegisterSizeArray
    (
        pOutArray, count, reinterpret_cast<const nn::dt::Node *>(pNode)
    );
    return nn::result::ConvertToC(result);
}
*/

/* template function
nnResult nndtGetRegisterSizeList(T * pOutList, int * pOutCount, int maxCount, const nndtNode * pNode)
{
    auto result = ::nn::dt::GetRegisterSizeList
    (
        pOutList, pOutCount, maxCount, reinterpret_cast<const nn::dt::Node *>(pNode)
    );
    return nn::result::ConvertToC(result);
}
*/

nnResult nndtGetNodePath(char * pOutBuffer, size_t bufferSize, const nndtNode * pNode)
{
    auto result = ::nn::dt::GetNodePath
    (
        pOutBuffer, bufferSize, reinterpret_cast<const nn::dt::Node *>(pNode)
    );
    return nn::result::ConvertToC(result);
}

nnResult nndtDumpNode(const nndtNode * pNode, int depth)
{
    auto result = ::nn::dt::DumpNode
    (
        reinterpret_cast<const nn::dt::Node *>(pNode), depth
    );
    return nn::result::ConvertToC(result);
}


}
