﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/svc/svc_MemoryMapSelect.h>

namespace nn { namespace drivers { namespace eth {

const uint64_t EnetRegionAddr = 0x02188000;
const size_t   EnetRegionSize = 0x1000;
extern uintptr_t g_EnetBegin;

#define ENET_EIR    (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x004))
#define ENET_EIMR   (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x008))
#define ENET_RDAR   (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x010))
#define ENET_TDAR   (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x014))
#define ENET_ECR    (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x024))
#define ENET_MMFR   (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x040))
#define ENET_MSCR   (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x044))
#define ENET_MIBC   (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x064))
#define ENET_RCR    (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x084))
#define ENET_TCR    (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x0c4))
#define ENET_PALR   (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x0e4))
#define ENET_PAUR   (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x0e8))
#define ENET_OPD    (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x0ec))
#define ENET_IAUR   (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x118))
#define ENET_IALR   (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x11c))
#define ENET_GAUR   (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x120))
#define ENET_GALR   (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x124))
#define ENET_TFWR   (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x144))
#define ENET_RDSR   (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x180))
#define ENET_TDSR   (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x184))
#define ENET_MRBR   (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x188))
#define ENET_RSFL   (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x190))
#define ENET_RSEM   (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x194))
#define ENET_RAEM   (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x198))
#define ENET_RAFL   (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x19c))
#define ENET_TSEM   (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x1a0))
#define ENET_TAEM   (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x1a4))
#define ENET_TAFL   (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x1a8))
#define ENET_TIPG   (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x1ac))
#define ENET_FTRL   (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x1b0))
#define ENET_TACC   (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x1c0))
#define ENET_RACC   (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x1c4))
#define ENET_ATCR   (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x400))
#define ENET_ATVR   (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x404))
#define ENET_ATOFF  (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x408))
#define ENET_ATPER  (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x40c))
#define ENET_ATCOR  (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x410))
#define ENET_ATINC  (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x414))
#define ENET_ATSTMP (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x418))
#define ENET_TGSR   (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x604))
#define ENET_TCSR0  (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x608))
#define ENET_TCCR0  (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x60c))
#define ENET_TCSR1  (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x610))
#define ENET_TCCR1  (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x614))
#define ENET_TCSR2  (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x618))
#define ENET_TCCR2  (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x61c))
#define ENET_TCSR3  (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x620))
#define ENET_TCCR3  (*reinterpret_cast<volatile uint32_t *>(g_EnetBegin + 0x624))

const uint32_t ENET_EIR_TXF             = (1u << 27);
const uint32_t ENET_EIR_RXF             = (1u << 25);

const uint32_t ENET_EIMR_TXF            = (1u << 27);
const uint32_t ENET_EIMR_RXF            = (1u << 25);
const uint32_t ENET_EIMR_MII            = (1u << 23);

const uint32_t ENET_ECR_DBSWP           = (1u << 8);
const uint32_t ENET_ECR_SPEED           = (1u << 5);
const uint32_t ENET_ECR_EN1588          = (1u << 4);
const uint32_t ENET_ECR_ETHEREN         = (1u << 1);
const uint32_t ENET_ECR_RESET           = (1u << 0);

const uint32_t ENET_RCR_NLC             = (1u << 30);
const uint32_t ENET_RCR_MAX_FL_SHIFT    = 16;
const uint32_t ENET_RCR_RMII_10T        = (1u << 9);
const uint32_t ENET_RCR_RGMII_EN        = (1u << 6);
const uint32_t ENET_RCR_FCE             = (1u << 5);
const uint32_t ENET_RCR_MII_MODE        = (1u << 2);

const uint32_t ENET_TCR_FDEN            = (1u << 2);

const uint32_t ENET_EIR_MII             = (1u << 23);

const uint32_t ENET_MMFR_PA_SHIFT       = 23;
const uint32_t ENET_MMFR_RA_SHIFT       = 18;
const uint32_t ENET_MMFR_ST             = (1u<<30);
const uint32_t ENET_MMFR_OP_READ        = (1u<<29);
const uint32_t ENET_MMFR_OP_WRITE       = (1u<<28);
const uint32_t ENET_MMFR_TA             = (1u<<17);

const uint32_t ENET_RDAR_RDAR           = (1u<<24);

const uint32_t ENET_TFWR_STRFWD         = (1u << 8);

const uint32_t ENET_RXBD_STS0_E      = (1u << 15);
const uint32_t ENET_RXBD_STS0_RO1    = (1u << 14);
const uint32_t ENET_RXBD_STS0_W      = (1u << 13);
const uint32_t ENET_RXBD_STS0_RO2    = (1u << 12);
const uint32_t ENET_RXBD_STS0_L      = (1u << 11);
const uint32_t ENET_RXBD_STS0_M      = (1u << 8);
const uint32_t ENET_RXBD_STS0_BC     = (1u << 7);
const uint32_t ENET_RXBD_STS0_MC     = (1u << 6);
const uint32_t ENET_RXBD_STS0_LG     = (1u << 5);
const uint32_t ENET_RXBD_STS0_NO     = (1u << 4);
const uint32_t ENET_RXBD_STS0_CR     = (1u << 2);
const uint32_t ENET_RXBD_STS0_OV     = (1u << 1);
const uint32_t ENET_RXBD_STS0_TR     = (1u << 0);
const uint32_t ENET_RXBD_STS0_ERROR  =
    ENET_RXBD_STS0_LG | ENET_RXBD_STS0_NO | ENET_RXBD_STS0_CR |
    ENET_RXBD_STS0_OV | ENET_RXBD_STS0_TR;

const uint32_t ENET_RXBD_STS1_ME     = (1u << 31);
const uint32_t ENET_RXBD_STS1_PE     = (1u << 26);
const uint32_t ENET_RXBD_STS1_CE     = (1u << 25);
const uint32_t ENET_RXBD_STS1_UC     = (1u << 24);
const uint32_t ENET_RXBD_STS1_INT    = (1u << 23);
const uint32_t ENET_RXBD_STS1_ICE    = (1u << 5);
const uint32_t ENET_RXBD_STS1_PCR    = (1u << 4);
const uint32_t ENET_RXBD_STS1_VLAN   = (1u << 2);
const uint32_t ENET_RXBD_STS1_UPV6   = (1u << 1);
const uint32_t ENET_RXBD_STS1_FRAG   = (1u << 0);
const uint32_t ENET_RXBD_STS1_ERROR  =
    ENET_RXBD_STS1_ME | ENET_RXBD_STS1_PE | ENET_RXBD_STS1_CE;

const uint32_t ENET_RXBD_STS2_BDU    = (1u << 31);

const uint32_t ENET_TXBD_STS0_R      = (1u << 15);
const uint32_t ENET_TXBD_STS0_TO1    = (1u << 14);
const uint32_t ENET_TXBD_STS0_W      = (1u << 13);
const uint32_t ENET_TXBD_STS0_TO2    = (1u << 12);
const uint32_t ENET_TXBD_STS0_L      = (1u << 11);
const uint32_t ENET_TXBD_STS0_TC     = (1u << 10);

const uint32_t ENET_TXBD_STS1_INT    = (1u << 30);
const uint32_t ENET_TXBD_STS1_TS     = (1u << 29);
const uint32_t ENET_TXBD_STS1_PINS   = (1u << 28);
const uint32_t ENET_TXBD_STS1_IINS   = (1u << 27);
const uint32_t ENET_TXBD_STS1_TXE    = (1u << 15);
const uint32_t ENET_TXBD_STS1_UE     = (1u << 13);
const uint32_t ENET_TXBD_STS1_EE     = (1u << 12);
const uint32_t ENET_TXBD_STS1_FE     = (1u << 11);
const uint32_t ENET_TXBD_STS1_LCE    = (1u << 10);
const uint32_t ENET_TXBD_STS1_OE     = (1u << 9);
const uint32_t ENET_TXBD_STS1_TSE    = (1u << 8);

const uint32_t ENET_TXBD_STS2_BDU    = (1u << 31);

struct RxBd
{
    volatile uint16_t length;
    volatile uint16_t status0;
    volatile uint32_t pointer;
    volatile uint32_t status1;
    volatile uint32_t header;
    volatile uint32_t status2;
    volatile uint32_t timestamp;
    volatile uint32_t dummy1;
    volatile uint32_t dummy2;
};

struct TxBd
{
    volatile uint16_t length;
    volatile uint16_t status0;
    volatile uint32_t pointer;
    volatile uint32_t status1;
    volatile uint32_t dummy0;
    volatile uint32_t status2;
    volatile uint32_t timestamp;
    volatile uint32_t dummy1;
    volatile uint32_t dummy2;
};


}}}

