﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
* @file
* @brief   文字列出力に利用する非公開関数の宣言
*/

#include <nn/nn_Common.h>

namespace nn { namespace diag { namespace detail {

// 長さ length バイトの文字列 text をデバッグ出力します。ヌル終端を要求しません。
void PrintDebugString(const char* text, size_t length) NN_NOEXCEPT;

// ヌル終端の文字列 text をデバッグ出力します。
void PrintDebugString(const char* text) NN_NOEXCEPT;

// text を UTF-8 から現在のコードページに変換して、PrintDebugString を呼び出します。ヌル終端を要求しません。
void PrintDebugStringWithConversion(const char* text, size_t length) NN_NOEXCEPT;

}}}
