﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/diag/diag_Config.h>

#if !NN_BUILD_CONFIG_OS_SUPPORTS_COS
    #error  "COS の機能が利用出来るビルド条件ではありません。"
#endif

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <cafe/os.h>
#include "diag_PrintDebugString.h"

namespace nn { namespace diag { namespace detail {

void PrintDebugString(const char* text, size_t length) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(text || length == 0);
    if (length == 0)
    {
        return;
    }
    OSReport("%.*s", sizeof(char) * length, text);
}

}}}
