﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <crtdbg.h>
#include <limits>

#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN
#endif
#ifndef NOMINMAX
#define NOMINMAX
#endif
#include <nn/nn_Windows.h>

#if !NN_BUILD_CONFIG_TOOLCHAIN_SUPPORTS_VC
    #error  "VC コンパイラが利用出来るビルド条件ではありません。"
#endif

#pragma warning(push)
#pragma warning(disable: 4100)

namespace nn { namespace diag { namespace detail {
    // _IGNORE_BLOCK からメモリ確保を行うカスタムアロケータ
    template <typename T>
    class IgnoreBlockAllocator
    {
    public:
        typedef size_t size_type;
        typedef intptr_t difference_type;
        typedef T* pointer;
        typedef const T* const_pointer;
        typedef T& reference;
        typedef const T& const_reference;
        typedef T value_type;

        template <class U>
        struct rebind
        {
            typedef IgnoreBlockAllocator<U> other;
        };

        IgnoreBlockAllocator() NN_NOEXCEPT
        {
        }

        IgnoreBlockAllocator(const IgnoreBlockAllocator&) NN_NOEXCEPT
        {
        }

        template <class U>
        IgnoreBlockAllocator(const IgnoreBlockAllocator<U>&) NN_NOEXCEPT
        {
        }

        ~IgnoreBlockAllocator() NN_NOEXCEPT
        {
        }

        pointer address(reference& x) const
        {
            return &x;
        }

        const_pointer address(const_reference& x) const
        {
            return &x;
        }

        pointer allocate(size_type n, void* = 0)
        {
            return static_cast<T*>(_malloc_dbg(n * sizeof(T), _IGNORE_BLOCK, __FILE__, __LINE__));
        }

        void deallocate(pointer p, size_type)
        {
            _free_dbg(static_cast<void*>(p), _IGNORE_BLOCK);
        }

        size_type max_size() const NN_NOEXCEPT
        {
            return std::numeric_limits<size_type>::max() / sizeof(T);
        }

        void construct(pointer p, const T& val)
        {
            new (static_cast<void*>(p)) T(val);
        }

        void destroy(pointer p)
        {
            p->~T();
        }
    };
}}}
#pragma warning(pop)
