﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Windows.h>
#include <nn/util/util_ScopeExit.h>
#include "diag_DbgHelp.h"

// SIGLO-21432: DbgHelp.h を VS2015 でビルドすると警告が出るので、抑制
#pragma warning(push)
#pragma warning(disable: 4091)
#include <DbgHelp.h>
#pragma warning(pop)

namespace nn { namespace diag { namespace detail {

int GetBacktraceImpl(uintptr_t *pOutArray, int arrayCountMax) NN_NOEXCEPT
{
    diag::detail::LockDbgHelpMutex();
    NN_UTIL_SCOPE_EXIT { diag::detail::UnlockDbgHelpMutex(); };

    return static_cast<int>(CaptureStackBackTrace(
              0, static_cast<DWORD>(arrayCountMax), reinterpret_cast<PVOID*>(pOutArray), nullptr));
}

}}} // nn::diag::detail
