﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
* @file
* @brief   Abort 関数の内部実装の宣言
*/

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/diag/diag_AbortTypes.h>
#include <nn/diag/diag_AbortTypesForSystem.h>

namespace nn { namespace diag { namespace detail {

NN_NORETURN void Abort(const Result* result) NN_NOEXCEPT;

// アボートオブザーバを呼び出す関数です。Abort する前に呼び出してください。
void InvokeAbortObserver(const AbortInfo& abortInfo) NN_NOEXCEPT;
void InvokeSdkAbortObserver(const SdkAbortInfo& abortInfo) NN_NOEXCEPT;

}}}
