﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief List of include files used internally
 *
 * @details Centralized management of all private includes
 */

#pragma once

#include <mutex>
#include <cstdio>
#include <cstring>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_Abort.h>
#include <nn/nn_TimeSpan.h>
#include <nn/util/util_IntrusiveList.h>
#include <nn/util/util_FormatString.h>
#include <nn/util/util_StringUtil.h>
#include <nn/dd.h>
#include <nn/os.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/os/os_TickApi.h>
#include <nn/os/os_TimerEvent.h>
#include <nn/nn_SystemThreadDefinition.h>

#include <nn/socket/socket_Api.h>
#include <nn/socket/socket_ApiPrivate.h>
#include <nn/socket/net/bpf.h>
#include <nn/socket/net/if_arp.h>
#include <nn/socket/net/if.h>
#include <nn/socket/net/if_dl.h>
#include <nn/socket/netinet/udp.h>
#include <nn/socket/sys/errno.h>
#include <nn/socket/net/ethernet.h>
#include <nn/socket/private/thread.h>

#include <nn/bsdsocket/bsdsocket_Result.private.h>
#include <nn/bsdsocket/dhcpc/dhcpc_Result.h>
#include <nn/bsdsocket/dhcpc/dhcpc_Protocol.h>
#include <nn/bsdsocket/dhcpc/dhcpc_Types.h>
#include <nn/bsdsocket/dhcpc/dhcpc_Api.h>

#include "dhcpc_Macros.h"
#include "dhcpc_Standard.h"
#include "dhcpc_Util.h"
#include "dhcpc_LocalEvent.h"
#include "dhcpc_Fsm.h"
#include "dhcpc_DeferredRequest.h"
#include "dhcpc_PacketManager.h"
#include "dhcpc_FdMonitor.h"
#include "dhcpc_Interface.h"
#include "dhcpc_Main.h"




