﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief BSD Configuration
 *
 * @details Top level BSD configuration management
 */

#pragma once

namespace nn { namespace bsdsocket { namespace cfg {

class Ipv4
{
public:
    struct Route
    {
        nn::socket::InAddr  dest;
        nn::socket::InAddr  net;
        nn::socket::InAddr  gate;
        nn::socket::InAddr  src;
        Interface           *pIf;
        uint32_t            metric;
        uint8_t             flags;
    };
    enum Operation
    {
        Operation_Delete,
        Operation_Add,
        Operation_Change,
    };

    static Result IfAddress(int s, const char *ifname, nn::socket::InAddr addr, nn::socket::InAddr mask,
                            nn::socket::InAddr bcast, int metric, Ipv4::Operation op);
    static Result VerifyIfAddress(int s, const char *name, nn::socket::InAddr inaddr, nn::socket::InAddr inmask, int metric);
    static Result IfRoute(int s, nn::socket::InAddr ifNet, nn::socket::InAddr ifAddr, uint16_t sdlIndex, Route *pRt, Ipv4::Operation op);
    static void GetAddrs(int type, char *cp, nn::socket::SockAddr **sa);

private:

};

} // namespace cfg
} // namespace bsdsocket
} // namespace nn

