﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/TargetConfigs/build_Cpu.h>
#include <nn/nn_Common.h>
#include "../kern_Platform.h"
#include "../kern_Kernel.h"
#include "kern_SvcHandlers.h"
#include "kern_SystemControl.h"

namespace nn { namespace kern { namespace svc {
namespace {
void SvcSleepSystem()
{
    KSystemControl::SleepSystem();
}
}

#if defined(NN_BUILD_CONFIG_CPU_SVC_32)
void SvcCallSecureMonitor32(Bit32* pBuf)
{
    KSystemControl::CallSecureMonitor32(pBuf);
}

void SvcSleepSystem32()
{
    SvcSleepSystem();
}

#endif

#if defined(NN_BUILD_CONFIG_CPU_SVC_64)
void SvcCallSecureMonitor64(Bit64* pBuf)
{
    KSystemControl::CallSecureMonitor64(pBuf);
}

void SvcSleepSystem64()
{
    SvcSleepSystem();
}

#endif

#if defined(NN_BUILD_CONFIG_CPU_SVC_64FROM32)
void SvcCallSecureMonitor64From32(Bit64* pBuf)
{
    KSystemControl::CallSecureMonitor64(pBuf);
}

void SvcSleepSystem64From32()
{
    SvcSleepSystem();
}

#endif // #if defined(NN_BUILD_CONFIG_CPU_SVC_64FROM32)

}}}
