﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/TargetConfigs/build_Cpu.h>
#if defined(NN_BUILD_CONFIG_CPU_SVC_32)
#include "../ip/ARM/svc/kern_SvcHandlers.32.autogen.h"
#endif
#if defined(NN_BUILD_CONFIG_CPU_SVC_64FROM32)
#include "../ip/ARM64/svc/kern_SvcHandlers.64from32.autogen.h"
#endif
#if defined(NN_BUILD_CONFIG_CPU_SVC_64)
#include "../ip/ARM64/svc/kern_SvcHandlers.64.autogen.h"
#endif
#include "kern_SvcValueCheck.h"

namespace nn { namespace kern { namespace svc {
#if defined NN_BUILD_CONFIG_CPU_ARM
inline void ClearSvcOutRegisters()
{
    register uintptr_t r0 asm ("r0") = 0;
    register uintptr_t r1 asm ("r1") = 0;
    register uintptr_t r2 asm ("r2") = 0;
    register uintptr_t r3 asm ("r3") = 0;
    asm volatile ("" ::"r"(r0), "r"(r1), "r"(r2), "r"(r3));
}
inline void ClearSvcOutRegistersReturnResult()
{
    register uintptr_t r1 asm ("r1") = 0;
    register uintptr_t r2 asm ("r2") = 0;
    register uintptr_t r3 asm ("r3") = 0;
    asm volatile ("" ::"r"(r1), "r"(r2), "r"(r3));
}
inline void ClearSvcOutRegistersReturnInt32()
{
    register uintptr_t r1 asm ("r1") = 0;
    register uintptr_t r2 asm ("r2") = 0;
    register uintptr_t r3 asm ("r3") = 0;
    asm volatile ("" ::"r"(r1), "r"(r2), "r"(r3));
}
inline void ClearSvcOutRegistersReturnInt64()
{
    register uintptr_t r2 asm ("r2") = 0;
    register uintptr_t r3 asm ("r3") = 0;
    asm volatile ("" ::"r"(r2), "r"(r3));
}

#elif defined NN_BUILD_CONFIG_CPU_ARM64
inline void ClearSvcOutRegisters()
{
    register uintptr_t x0 asm ("x0") = 0;
    register uintptr_t x1 asm ("x1") = 0;
    register uintptr_t x2 asm ("x2") = 0;
    register uintptr_t x3 asm ("x3") = 0;
    register uintptr_t x4 asm ("x4") = 0;
    register uintptr_t x5 asm ("x5") = 0;
    register uintptr_t x6 asm ("x6") = 0;
    register uintptr_t x7 asm ("x7") = 0;
    asm volatile ("" ::
            "r"(x0), "r"(x1), "r"(x2), "r"(x3),
            "r"(x4), "r"(x5), "r"(x6), "r"(x7));
}
inline void ClearSvcOutRegistersReturnResult()
{
    register uintptr_t x1 asm ("x1") = 0;
    register uintptr_t x2 asm ("x2") = 0;
    register uintptr_t x3 asm ("x3") = 0;
    register uintptr_t x4 asm ("x4") = 0;
    register uintptr_t x5 asm ("x5") = 0;
    register uintptr_t x6 asm ("x6") = 0;
    register uintptr_t x7 asm ("x7") = 0;
    asm volatile ("" ::
            "r"(x1), "r"(x2), "r"(x3),
            "r"(x4), "r"(x5), "r"(x6), "r"(x7));
}
inline void ClearSvcOutRegistersReturnInt32()
{
    register uintptr_t x1 asm ("x1") = 0;
    register uintptr_t x2 asm ("x2") = 0;
    register uintptr_t x3 asm ("x3") = 0;
    register uintptr_t x4 asm ("x4") = 0;
    register uintptr_t x5 asm ("x5") = 0;
    register uintptr_t x6 asm ("x6") = 0;
    register uintptr_t x7 asm ("x7") = 0;
    asm volatile ("" ::
            "r"(x1), "r"(x2), "r"(x3),
            "r"(x4), "r"(x5), "r"(x6), "r"(x7));
}
inline void ClearSvcOutRegistersReturnInt64()
{
    register uintptr_t x1 asm ("x1") = 0;
    register uintptr_t x2 asm ("x2") = 0;
    register uintptr_t x3 asm ("x3") = 0;
    register uintptr_t x4 asm ("x4") = 0;
    register uintptr_t x5 asm ("x5") = 0;
    register uintptr_t x6 asm ("x6") = 0;
    register uintptr_t x7 asm ("x7") = 0;
    asm volatile ("" ::
            "r"(x1), "r"(x2), "r"(x3),
            "r"(x4), "r"(x5), "r"(x6), "r"(x7));
}
#else
#error not defined NN_BUILD_CONFIG_CPU_
#endif
}}}

