﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/svc/svc_Kernel.h>
#include "kern_KObjectAdaptor.h"
#include "kern_KLightMutex.h"
#include "kern_KLightConditionvariable.h"

namespace nn { namespace kern {

class KResourceLimit
    : public KObjectAdaptor<KResourceLimit, KAutoObjectWithList>
{
private:
    int64_t     m_Limits[nn::svc::LimitableResource_Num];
    int64_t     m_Values[nn::svc::LimitableResource_Num];
    int64_t     m_Hints[nn::svc::LimitableResource_Num];
    mutable KLightMutex m_Mutex;
    int         m_NumWaiter;
    KLightConditionvariable m_Conditionvariable;

public:
    static const nn::svc::Tick DefaultTimeout;
    explicit        KResourceLimit() {}
    virtual         ~KResourceLimit() {}

    void            Initialize();
    virtual void    Finalize();
    static void     PostFinalize(uintptr_t arg) { NN_UNUSED(arg); }

    Result          SetLimitValue(nn::svc::LimitableResource resource, int64_t value);
    int64_t         GetLimitValue(nn::svc::LimitableResource resource) const;
    int64_t         GetCurrentValue(nn::svc::LimitableResource resource) const;
    int64_t         GetCurrentFreeValue(nn::svc::LimitableResource resource) const;

    bool            TestLimit(nn::svc::LimitableResource resource, int64_t value);
    bool            TestLimit(nn::svc::LimitableResource resource, int64_t value, int64_t timeout);
    void            ReleaseLimit(nn::svc::LimitableResource resource, int64_t value);
    void            ReleaseLimit(nn::svc::LimitableResource resource, int64_t value, int64_t hint);

    //! KAutoObjectのプリセット関数セット定義です。クラスの末尾に記述する必要があります
    NN_AUTOOBJECT_DERIVED_FUNCSET(KResourceLimit, KAutoObject)
};

}}

