﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include "kern_Platform.h"
#include "kern_KAutoObject.h"
#include "kern_KObjectAdaptor.h"
#include "kern_KSynchronizationObject.h"
#include "kern_KSlabAllocator.h"
#include "kern_KObjectContainer.h"
#include "kern_KInterruptEvent.h"
#include "kern_DebugSelect.h"
#include "kern_KEvent.h"
#include "kern_KPort.h"
#include "kern_KProcess.h"
#include "kern_KSession.h"
#include "kern_KLightSession.h"
#include "kern_KSharedMemory.h"
#include "kern_KTransferMemory.h"
#include "kern_KCodeMemory.h"
#include "kern_KDeviceAddressSpace.h"
#include "kern_KMemoryManager.h"
#include "kern_KThread.h"
#include "kern_KResourceLimit.h"

namespace nn { namespace kern {

template class KObjectAdaptor<KEvent,           KAutoObjectWithList>;
template class KObjectAdaptor<KInterruptEvent,  KReadableEvent>;
template class KObjectAdaptor<KPort,            KAutoObjectWithList>;
template class KObjectAdaptor<KProcess,         KSynchronizationObject>;
template class KObjectAdaptor<KSession,         KAutoObjectWithList>;
template class KObjectAdaptor<KLightSession,    KAutoObjectWithList>;
template class KObjectAdaptor<KSharedMemory,    KAutoObjectWithList>;
template class KObjectAdaptor<KTransferMemory,  KAutoObjectWithList>;
template class KObjectAdaptor<KCodeMemory,      KAutoObjectWithList>;
template class KObjectAdaptor<KDeviceAddressSpace, KAutoObjectWithList>;
template class KObjectAdaptor<KThread,          KSynchronizationObject>;
template class KObjectAdaptor<KDebug,           KDebugBase>;
template class KObjectAdaptor<KResourceLimit,   KAutoObjectWithList>;

template <typename T, class U> KSlabAllocator<T> KObjectAdaptor<T, U>::s_SlabAllocator;
template <typename T, class U> KObjectContainer KObjectAdaptor<T, U>::s_Container;



}}
