﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/svc/svc_Kernel.h>
#include "kern_KObjectAdaptor.h"
#include "kern_KThread.h"
#include "kern_KScheduler.h"
#include "kern_KRbTree.h"

namespace nn { namespace kern {

struct KConditionVariableCompare
{
    int operator() (const KThread& a, const KThread& b)
    {
        uintptr_t cvKeyA = a.GetConditionVariableKeyValue();
        uintptr_t cvKeyB = b.GetConditionVariableKeyValue();

        if (cvKeyA < cvKeyB)
        {
            return -1;
        }
        else if (cvKeyA == cvKeyB)
        {
            int priA = a.GetPriority();
            int priB = b.GetPriority();
            if (priA < priB)
            {
                return -1;
            }
        }
        return 1;
    }
};

class KLockWithPriorityInheritance
{
private:
    typedef IntrusiveRbTree<KThread, IntrusiveRbTreeMemberNodeTraits<KThread, &KThread::m_ConditionVariableNode>, KConditionVariableCompare> ConditionVariableList;

    //! 待機対象のスレッドが格納されるキュー
    ConditionVariableList   m_CvList;
    KThread* SignalConditionVariableImpl(KThread* pThread);
public:
    Result WaitForAddress(nn::svc::Handle handle, KProcessAddress addr, Bit32 ownValue);
    Result SignalToAddress(KProcessAddress addr);
    Result WaitConditionVariable(KProcessAddress addr, uintptr_t cvKey, Bit32 ownValue, int64_t ns);
    void SignalConditionVariable(uintptr_t cvKey, int32_t num);

    NN_FORCEINLINE void BeforePriorityUpdate(KThread* pThread)
    {
        NN_KERN_ASSERT(KScheduler::IsSchedulerLocked());

        m_CvList.erase(m_CvList.iterator_to(*pThread));
    }
    NN_FORCEINLINE void AfterPriorityUpdate(KThread* pThread)
    {
        NN_KERN_ASSERT(KScheduler::IsSchedulerLocked());
        m_CvList.insert(*pThread);
    }
private:
};

}}

