﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*!
    @file

    @brief イベントに関する API の宣言

*/

#pragma once

#include <nn/nn_Common.h>
#include "kern_Assert.h"
#include "kern_KObjectAdaptor.h"
#include "kern_KAutoObject.h"
#include "kern_KReadableEvent.h"
#include "kern_KWritableEvent.h"

namespace nn { namespace kern {

class KProcess;
/*!
  @brief      イベント クラスの定義です。
*/
class KEvent :
    public KObjectAdaptor<KEvent, KAutoObjectWithList>
{
private:
    KReadableEvent  m_ReadableEvent;
    KWritableEvent  m_WritableEvent;
    KProcess*       m_pOwner;
    bool            m_IsInitialized;

public:
    explicit KEvent(): m_pOwner(nullptr), m_IsInitialized(false) {}
    virtual  ~KEvent() {}

    KProcess* GetOwner() const { return m_pOwner; }
    void Initialize();
    virtual void    Finalize();

    virtual bool IsInitialized() const { return m_IsInitialized; }
    virtual uintptr_t GetPostFinalizeArgument() const { return reinterpret_cast<uintptr_t>(m_pOwner); }
    static void PostFinalize(uintptr_t arg);

    KReadableEvent& GetReadableEvent()
    {
        return m_ReadableEvent;
    }

    KWritableEvent& GetWritableEvent()
    {
        return m_WritableEvent;
    }

    NN_AUTOOBJECT_DERIVED_FUNCSET(KEvent, KAutoObject)
};

}}

