﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include "kern_Result.h"

namespace nn { namespace kern {

class KContextBase
{
public:
    explicit KContextBase(){}
    KContextBase& operator=(const KContextBase&) = delete;
    KContextBase(const KContextBase&) = delete;

    Result Initialize(uintptr_t initialPc, uintptr_t kernelSp, uintptr_t userSp, uintptr_t firstArg, bool isUserMode, bool is64Bit);
    Result Finalize();

    bool Save(void);
    void Restore(void);

    // for debug
    void Show(void);
};

}}

