﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_BitTypes.h>
#include "kern_PageTableSelect.h"
#include "kern_KPageGroup.h"
#include "kern_KObjectAdaptor.h"
#include "kern_KLightMutex.h"

namespace nn { namespace kern {

class KCodeMemory : public KObjectAdaptor<KCodeMemory, KAutoObjectWithList>
{
private:
    KPageGroup  m_Memory;
    KProcess*   m_pOwner;
    KProcessAddress m_Addr;
    KLightMutex m_Lock;
    bool        m_IsInitialized;
    bool        m_IsOwnerMapped;
    bool        m_IsMapped;
public:
    explicit KCodeMemory();
    virtual ~KCodeMemory();

    virtual void    Finalize();

    virtual bool IsInitialized() const { return m_IsInitialized; }

    Result  Initialize(
                KProcessAddress     addr,
                size_t              size);

    Result  Map(
                KProcessAddress     addr,
                size_t              size);

    Result  Unmap(
                KProcessAddress     addr,
                size_t              size);

    Result  MapToOwner(
                KProcessAddress     addr,
                size_t              size,
                nn::svc::MemoryPermission permission);

    Result  UnmapFromOwner(
                KProcessAddress     addr,
                size_t              size);

    // for debug
    KProcess* GetOwner() const { return m_pOwner; }
    KProcessAddress GetFromAddress() const { return m_Addr; }
    size_t GetSize() const { return m_Memory.GetTotalNumPages() * NN_KERN_FINEST_PAGE_SIZE; }

    static void PostFinalize(uintptr_t arg) { NN_UNUSED(arg); }

    //! KAutoObjectのプリセット関数セット定義です。クラスの末尾に記述する必要があります
    NN_AUTOOBJECT_DERIVED_FUNCSET(KCodeMemory, KAutoObjectWithList)
};

}}

