﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/TargetConfigs/build_Cpu.h>

#if defined(NN_BUILD_CONFIG_CPU_CORTEX_A9)

#include "CortexA9/kern_KHardwareTimer.h"
namespace nn { namespace kern {
    using nn::kern::CortexA9::KHardwareTimer;
}}

#elif defined(NN_BUILD_CONFIG_CPU_CORTEX_A15) || defined(NN_BUILD_CONFIG_CPU_CORTEX_A7)

#include "ip/ARMv7A/kern_KHardwareTimer.h"
namespace nn { namespace kern {
    using nn::kern::ARMv7A::KHardwareTimer;
}}

#elif defined(NN_BUILD_CONFIG_CPU_ARM_V8A)
#include "ip/ARMv8A/kern_KHardwareTimer.h"
namespace nn { namespace kern {
    using nn::kern::ARMv8A::KHardwareTimer;
}}

#elif defined(NN_BUILD_CONFIG_CPU_PPC32)

#include "PPC32/kern_KHardwareTimer.h"
namespace nn { namespace kern {
    using nn::kern::PPC32::KHardwareTimer;
}}

#else
#error no KHardwareTimer is selected
#endif

