﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_BitTypes.h>
#include "kern_Assert.h"
#include "../../kern_CPUSelect.h"

namespace nn { namespace kern {

namespace ARMv8A {
class KSimpleLock
{
private:
    NN_ALIGNAS(KCPU::DATA_CACHE_LINE_SIZE) Bit16    m_CurrentTicket;
    NN_ALIGNAS(KCPU::DATA_CACHE_LINE_SIZE) Bit16    m_NextTicket;

public:
    KSimpleLock() : m_CurrentTicket(0), m_NextTicket(0)
    {
        NN_KERN_THIS_ASSERT();
    }

    void Lock()
    {
        NN_KERN_THIS_ASSERT();
        Bit32 tmp0;
        Bit32 tmp1;
        Bit32 tmp2;

        asm volatile(
                "    prfm   pstl1keep, %3;"
                "1:  ldaxrh %w0, %3;"
                "    add    %w1, %w0, #0x1;"
                "    stxrh  %w2, %w1, %3;"
                "    cbnz   %w2, 1b;"

                "    sevl;"
                "2:  wfe;"
                "    ldaxrh %w1, %4;"
                "    cmp    %w1, %w0;"
                "    b.ne   2b;"
                :"=&r"(tmp0), "=&r"(tmp1), "=&r"(tmp2), "+Q"(m_NextTicket)
                :"Q"(m_CurrentTicket)
                : "memory", "cc");
    }

    void Unlock()
    {
        NN_KERN_THIS_ASSERT();
        Bit32 v = m_CurrentTicket + 1;

        asm volatile(
                "    stlrh  %w1, %0;"
                :"+Q"(m_CurrentTicket)
                :"r"(v)
                : "memory");
    }
};

}
}}

