﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "kern_AssemblyOffset.h"
#include "../ARM/kern_Assembly.h"

/* =======================================================================
     VFPv3, VFPv4はVFP例外を発生しない。
     ・VFPv3UはVFP例外を発生するが、今のところ実装したCPUはない?
     ・HWでIEEEに準拠できるので、そもそも例外を発生させる必要がない(らしい)
   　・VFPv3でfpinstを読みだそうとすると、未定義命令例外が発生する。
   　・VFP例外を発生するHWの判定は、以下で判定可能。(VFPv2と共通化可能)
        FPEXC.EX = 1と設定しとき
            FPEXC.EX = 1となる場合：VFP例外を発生するHW
            FPEXC.EX = 0となる場合：VFP例外を発生しないHW
     IFARについて。
        Thumb-2をサポートするARMv6-T2以降のアーキテクチャでは
        プリフェッチアボートの要因となったアドレスと取得するIFARが
        実装された。
        Thumb-2 32bit命令は、16Byteアラインのミドルエンディアンであり、
        ページ境界にまたがることがある。このとき例外を発生させたアドレスは
        必ずしもPCと一致しない。
   ======================================================================== */


EXP_VECTOR_ENTRY(_ZN2nn4kern6ARMv7A42CallExceptionHandlerAndReturnFromExceptionEv)
    // SVC モード -------

    // 関数呼び出し時点の状況
    //      +---------
    //      |   cpsr
    //      +---------
    //      |   pc
    //      +---------
    //      |   ハンドラのアドレス
    //      +---------
    //      |   r12
    //   SP +---------
    //
    //   r13 はカレントスレッドの SVC モードスタック
    //      スタックのトップには AbortHandler とパディングが格納され、
    //      その下に srs で例外発生時の PC, CPSR が保存されている

    // 例外発生時のレジスタの関数呼び出し時点での保存先
    //   r0-r12 → r0-r12
    //   r13    → 例外発生時のモードの r13
    //   r14    → 例外発生時のモードの r14
    //   r15    → [sp, #0]
    //   CPSR   → [sp, #4]

    // 各レジスタを保存
    mrc     p15, 0, ip, c13, c0, 2
    push    {ip, lr}

    stmdb   sp, {r13-r14}^
    sub     sp, sp, #8
    push    {r0-r11}

    mov     r1, #1
    add     r0, r1, sp, LSR #NN_KERN_THREAD_SVC_STACK_SIZE_SHIFT
    mov     r0, r0, LSL #NN_KERN_THREAD_SVC_STACK_SIZE_SHIFT
    sub     r0, r0, #PARAMS_ON_STACK_SIZE
    strb    r1, [r0,#PARAMS_ON_STACK_INEXCEPTIONHANDLER]

    // ハンドラを呼ぶ
    cpsie   fa
    mov     r0, sp
    ldr     r1, [sp, #EXCEPTION_CONTEXT_WRITE]
    blx     r1
    cpsid   ifa

    mov     r1, #1
    add     r0, r1, sp, LSR #NN_KERN_THREAD_SVC_STACK_SIZE_SHIFT
    mov     r0, r0, LSL #NN_KERN_THREAD_SVC_STACK_SIZE_SHIFT
    sub     r0, r0, #PARAMS_ON_STACK_SIZE
    mov     r1, #0
    strb    r1, [r0,#PARAMS_ON_STACK_INEXCEPTIONHANDLER]

    // コンテキストを復帰
    pop     {r0-r11}
    ldmia   sp, {r13-r14}^
    add     sp, sp, #8
    pop     {ip, lr}
    mcr     p15, 0, ip, c13, c0, 2
    pop     {ip, lr}

    // 例外から復帰
    rfeia   sp!
SET_SIZE(_ZN2nn4kern6ARMv7A42CallExceptionHandlerAndReturnFromExceptionEv)


EXP_VECTOR_ENTRY(_ZN2nn4kern6ARMv7A55CallExceptionHandlerAndReturnFromExceptionPrivilegeModeEv)
    // SVC / SYS 以外の特権モード -------

    // 関数呼び出し時点のレジスタ使用状況
    //   r0-r2 は自由に使用可能
    //   r3 に AbortHandler が格納されている
    //   r4-r12 は例外発生時の値が保存されている
    //   r13 は現在のモードのスタック
    //     スタックのトップには例外発生時の r0-r3 が保存されている
    //   lr に例外発生時の PC が格納されている

    // 例外発生時のレジスタの関数呼び出し時点での保存先
    //   r0-r3  → [sp, #0-#12]
    //   r4-r12 → r4-r12
    //   r13    → 例外発生時のモードの r13
    //   r14    → 例外発生時のモードの r14
    //   r15    → lr
    //   CPSR   → SPSR

    // SVC モードのスタック残量をチェックする
    mrs     r2, cpsr
    cps     #HW_PSR_SVC_MODE
    // SVC モード -----------
    sub     r0, sp, #1
    mov     r1, r0, LSR #NN_KERN_THREAD_SVC_STACK_SIZE_SHIFT    // 2 命令で and r1, r0, #0xFFFFF000 を行う
    mov     r1, r1, LSL #NN_KERN_THREAD_SVC_STACK_SIZE_SHIFT    // r1 が SVC スタックの TOP になる
    sub     r1, r0, r1                  // r1 が SVC スタックの残量になる
    msr     cpsr_cxsf, r2
    // 元のモード -----------

    // 残量が少ないなら KernelPanic
    subs    r1, r1, #0x0400
    ldrlt   sp, = NN_KERN_V_ADDR_STACK_CMN_END
    blt     _ZN2nn4kern6ARMv7A20PanicByTooSmallStackEv

    // 残量があるなら処理継続

    // 割り込み発生時のコンテキストを保存
    srsdb   #HW_PSR_SVC_MODE!           // 元のモードの PC と CPSR を SVC スタックに保存
    cps     #HW_PSR_SVC_MODE
    // SVC モード -----------
    push    {r3, r4}                    // AbortHandler とパディングを SVC スタックに保存
    msr     cpsr_cxsf, r2
    // 元のモード -----------
    pop     {r0-r3}                     // 例外発生時の r0-r3 を復帰
    cps     #HW_PSR_SVC_MODE
    // SVC モード -----------

    // ハンドラを呼び、例外から復帰する
    b       _ZN2nn4kern6ARMv7A42CallExceptionHandlerAndReturnFromExceptionEv
SET_SIZE(_ZN2nn4kern6ARMv7A55CallExceptionHandlerAndReturnFromExceptionPrivilegeModeEv)

