﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace kern { namespace ARM64 {

    void BeginUserMemoryCopyFunctionArea();
    void EndUserMemoryCopyFunctionArea();

    bool CopyMemoryFromUser     (void* dstKernel,   const void* srcUser,    size_t length);
    bool CopyMemoryToUser       (void* dstUser,     const void* srcKernel,  size_t length);
    int32_t  CopyStringFromUser     (void* dstKernel,   const void* srcUser,    size_t length);
    int32_t  CopyStringToUser       (void* dstUser,     const void* srcKernel,  size_t length);
    bool ClearUserMemory        (void* dstUser,     size_t length);

    bool CopyMemoryFromUserAlign8(void* dstKernel,  const void* srcUser,    size_t length);
    bool CopyMemoryToUserAlign8 (void* dstUser,     const void* srcKernel,  size_t length);

    bool CopyMemoryFromUserAlign4(void* dstKernel,  const void* srcUser,    size_t length);
    bool CopyMemoryToUserAlign4 (void* dstUser,     const void* srcKernel,  size_t length);
    bool ClearUserMemoryAlign4  (void* dstUser,     size_t length);

    bool CopyMemoryFromUserOnly4(void* dstKernel,   const void* srcUser);
    bool CopyMemoryToUserOnly4  (void* dstUser,     const void* srcKernel);
    bool ClearUserMemoryOnly4   (void* dstUser);

    bool ReadIoMemory32(void* dstUser, const void* srcUser, size_t length);
    bool ReadIoMemory16(void* dstUser, const void* srcUser, size_t length);
    bool ReadIoMemory8(void* dstUser, const void* srcUser, size_t length);
    bool WriteIoMemory32(void* dstUser, const void* srcUser, size_t length);
    bool WriteIoMemory16(void* dstUser, const void* srcUser, size_t length);
    bool WriteIoMemory8(void* dstUser, const void* srcUser, size_t length);

    bool StoreDataCache(uintptr_t begin, uintptr_t end);
    bool FlushDataCache(uintptr_t begin, uintptr_t end);
    bool InvalidateDataCache(uintptr_t begin, uintptr_t end);
    bool InvalidateInstructionCache(uintptr_t begin, uintptr_t end);
}}}

