﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "kern_AssemblyOffset.h"
#include "../ARM64/kern_Assembly.h"
#include "../ARM64/kern_RegisterDefinition.h"

    .section ".text","xa"

    .balign 0x800
    .globl  ExceptionVector
    .type   ExceptionVector, @function
ExceptionVector:

/*
 * Current Exception level with SP_EL0
 */
    .balign 0x80
    .globl  SynchronousExceptionFromEL1t
    .type   SynchronousExceptionFromEL1t, @function
SynchronousExceptionFromEL1t:
    clrex
    nop
    b SynchronousExceptionFromEL1t

    .balign 0x80
    .globl  IrqExceptionFromEL1t
    .type   IrqExceptionFromEL1t, @function
IrqExceptionFromEL1t:
    clrex
    nop
    b IrqExceptionFromEL1t

    .balign 0x80
    .globl  FiqExceptionFromEL1t
    .type   FiqExceptionFromEL1t, @function
FiqExceptionFromEL1t:
    clrex
    nop
    b FiqExceptionFromEL1t

    .balign 0x80
    .globl  SErrorInterruptExceptionFromEL1t
    .type   SErrorInterruptExceptionFromEL1t, @function
SErrorInterruptExceptionFromEL1t:
    clrex
    nop
    b SErrorInterruptExceptionFromEL1t


/*
 * Current Exception level with SP_EL1
 */
    .balign 0x80
    .globl  SynchronousExceptionFromEL1h
    .type   SynchronousExceptionFromEL1h, @function
SynchronousExceptionFromEL1h:
    clrex
    b SynchronousExceptionHandlerEL1

    .balign 0x80
    .globl  IrqExceptionFromEL1h
    .type   IrqExceptionFromEL1h, @function
IrqExceptionFromEL1h:
    clrex
    b InterruptRequestHandlerEL1

    .balign 0x80
    .globl  FiqExceptionFromEL1h
    .type   FiqExceptionFromEL1h, @function
FiqExceptionFromEL1h:
    clrex
    nop
    b FiqExceptionFromEL1h

    .balign 0x80
    .globl  SErrorInterruptExceptionFromEL1h
    .type   SErrorInterruptExceptionFromEL1h, @function
SErrorInterruptExceptionFromEL1h:
    clrex
    nop
    b SystemErrorHandlerEL1


/*
 * Lower Exception level using AAarch64
 */
    .balign 0x80
    .globl  SynchronousExceptionFromEL0InAarch64
    .type   SynchronousExceptionFromEL0InAarch64, @function
SynchronousExceptionFromEL0InAarch64:
    clrex
    b SynchronousExceptionHandlerEL0

    .balign 0x80
    .globl  IrqExceptionFromEL0InAArch64
    .type   IrqExceptionFromEL0InAArch64, @function
IrqExceptionFromEL0InAArch64:
    clrex
    b InterruptRequestHandlerEL0

    .balign 0x80
    .globl  FiqExceptionFromEL0InAArch64
    .type   FiqExceptionFromEL0InAArch64, @function
FiqExceptionFromEL0InAArch64:
    clrex
    nop
    b FiqExceptionFromEL0InAArch64

    .balign 0x80
    .globl  SErrorInterruptExceptionFromEL0InAArch64
    .type   SErrorInterruptExceptionFromEL0InAArch64, @function
SErrorInterruptExceptionFromEL0InAArch64:
    clrex
    nop
    b SystemErrorHandlerEL0


/*
 * Lower Exception level using AAarch32
 */
 /*
  * x15 ～ x30 はユーザモードでは使用されないので、自由に使うことができる。
  */
    .balign 0x80
    .globl  SynchronousExceptionFromEL0InAarch32
    .type   SynchronousExceptionFromEL0InAarch32, @function
SynchronousExceptionFromEL0InAarch32:
    clrex
    b SynchronousExceptionHandlerEL0

    .balign 0x80
    .globl  IrqExceptionFromEL0InAArch32
    .type   IrqExceptionFromEL0InAArch32, @function
IrqExceptionFromEL0InAArch32:
    clrex
    b InterruptRequestHandlerEL0

    .balign 0x80
    .globl  FiqExceptionFromEL0InAArch32
    .type   FiqExceptionFromEL0InAArch32, @function
FiqExceptionFromEL0InAArch32:
    clrex
    nop
    b FiqExceptionFromEL0InAArch32

    .balign 0x80
    .globl  SErrorInterruptExceptionFromEL0InAArch32
    .type   SErrorInterruptExceptionFromEL0InAArch32, @function
SErrorInterruptExceptionFromEL0InAArch32:
    clrex
    nop
    b SystemErrorHandlerEL0



ENTRY(InterruptRequestHandlerEL1)
    /*
     * r19-r29, SPがcallee save
     */
    sub sp, sp, #(8*24)

    stp x0, x1, [sp, #(8 * 0)]
    stp x2, x3, [sp, #(8 * 2)]
    stp x4, x5, [sp, #(8 * 4)]
    stp x6, x7, [sp, #(8 * 6)]
    stp x8, x9, [sp, #(8 * 8)]
    stp x10, x11, [sp, #(8 * 10)]
    stp x12, x13, [sp, #(8 * 12)]
    stp x14, x15, [sp, #(8 * 14)]
    stp x16, x17, [sp, #(8 * 16)]
    stp x18, x19, [sp, #(8 * 18)]
    stp x20, x21, [sp, #(8 * 20)]
    stp x22, x30, [sp, #(8 * 22)]

    mrs x18, tpidr_el1
    mrs x19, sp_el0
    mrs x20, elr_el1
    mrs x21, spsr_el1
    mov w21, w21

    mov x0, #0
    bl _ZN2nn4kern6ARMv8A17KInterruptManager23InterruptRequestHandlerEb

    msr sp_el0, x19
    msr elr_el1, x20
    msr spsr_el1, x21

    ldp x0, x1, [sp, #(8 * 0)]
    ldp x2, x3, [sp, #(8 * 2)]
    ldp x4, x5, [sp, #(8 * 4)]
    ldp x6, x7, [sp, #(8 * 6)]
    ldp x8, x9, [sp, #(8 * 8)]
    ldp x10, x11, [sp, #(8 * 10)]
    ldp x12, x13, [sp, #(8 * 12)]
    ldp x14, x15, [sp, #(8 * 14)]
    ldp x16, x17, [sp, #(8 * 16)]
    ldp x18, x19, [sp, #(8 * 18)]
    ldp x20, x21, [sp, #(8 * 20)]
    ldp x22, x30, [sp, #(8 * 22)]

    add sp, sp, #(8*24)
    eret
SET_SIZE(InterruptRequestHandlerEL1)

ENTRY(InterruptRequestHandlerEL0)
    /*
     * r19-r29, SPがcallee save
     * r15-r30 は AArch32では未使用なので、最適化可能
     */
    sub      sp,  sp, #STACK_OFFSET
    stp      x0,  x1, [sp, #(EXCEPTION_CONTEXT_X0)]
    stp      x2,  x3, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 2)]
    stp      x4,  x5, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 4)]
    stp      x6,  x7, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 6)]
    stp      x8,  x9, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 8)]
    stp     x10, x11, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 10)]
    stp     x12, x13, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 12)]
    stp     x14, x15, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 14)]
    stp     x16, x17, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 16)]
    stp     x18, x19, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 18)]
    stp     x20, x21, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 20)]
    stp     x22, x23, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 22)]
    stp     x24, x25, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 24)]
    stp     x26, x27, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 26)]
    stp     x28, x29, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 28)]
    mrs     x20, sp_el0
    mrs     x21, elr_el1
    mrs     x22, spsr_el1
    mrs     x23, tpidr_el0
    mov     w22, w22
    stp     x30, x20, [sp, #(EXCEPTION_CONTEXT_X30)]
    stp     x21, x22, [sp, #(EXCEPTION_CONTEXT_PC)]
    str     x23,      [sp, #(EXCEPTION_CONTEXT_TPIDR)]

    mrs x18, tpidr_el1
    mov x0, #1
    bl _ZN2nn4kern6ARMv8A17KInterruptManager23InterruptRequestHandlerEb

    ldp     x30, x20, [sp, #(EXCEPTION_CONTEXT_X30)]
    ldp     x21, x22, [sp, #(EXCEPTION_CONTEXT_PC)]
    ldr     x23,      [sp, #(EXCEPTION_CONTEXT_TPIDR)]
    msr     sp_el0,   x20
    msr     elr_el1,  x21
    msr     spsr_el1, x22
    msr     tpidr_el0, x23
    ldp      x0,  x1, [sp, #(EXCEPTION_CONTEXT_X0)]
    ldp      x2,  x3, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 2)]
    ldp      x4,  x5, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 4)]
    ldp      x6,  x7, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 6)]
    ldp      x8,  x9, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 8)]
    ldp     x10, x11, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 10)]
    ldp     x12, x13, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 12)]
    ldp     x14, x15, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 14)]
    ldp     x16, x17, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 16)]
    ldp     x18, x19, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 18)]
    ldp     x20, x21, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 20)]
    ldp     x22, x23, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 22)]
    ldp     x24, x25, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 24)]
    ldp     x26, x27, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 26)]
    ldp     x28, x29, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 28)]
    add     sp,   sp, #STACK_OFFSET

    eret
SET_SIZE(InterruptRequestHandlerEL0)


ENTRY(SynchronousExceptionHandlerEL0)
    stp x16, x17, [sp, #(-8*2)]!

    mrs x16, esr_el1
    lsr x17, x16, #HW_ESR_EC_SHIFT

    cmp x17, #HW_ESR_EC_SVC32
    b.eq 1f
    cmp x17, #HW_ESR_EC_SVC64
    b.eq 2f
    cmp x17, #HW_ESR_EC_FPACC
    b.eq 3f
    cmp x17, #HW_ESR_EC_DABORT_EL0
    b.eq .LCheckTlbConflict
    cmp x17, #HW_ESR_EC_IABORT_EL0
    b.eq .LCheckTlbConflict

.LNotTlbConflict:
    ldp x16, x17, [sp], #(8*2)

    // 例外ハンドラ呼び出し
    sub      sp,  sp, #STACK_OFFSET
    stp      x0,  x1, [sp, #(EXCEPTION_CONTEXT_X0)]
    stp      x2,  x3, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 2)]
    stp      x4,  x5, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 4)]
    stp      x6,  x7, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 6)]
    stp      x8,  x9, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 8)]
    stp     x10, x11, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 10)]
    stp     x12, x13, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 12)]
    stp     x14, x15, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 14)]
    stp     x16, x17, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 16)]
    stp     x18, x19, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 18)]
    stp     x20, x21, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 20)]
    stp     x22, x23, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 22)]
    stp     x24, x25, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 24)]
    stp     x26, x27, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 26)]
    stp     x28, x29, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 28)]
    mrs     x20, sp_el0
    mrs     x21, elr_el1
    mrs     x22, spsr_el1
    mrs     x23, tpidr_el0
    mov     w22, w22
    stp     x30, x20, [sp, #(EXCEPTION_CONTEXT_X30)]
    stp     x21, x22, [sp, #(EXCEPTION_CONTEXT_PC)]
    str     x23,      [sp, #(EXCEPTION_CONTEXT_TPIDR)]

    mrs     x18, tpidr_el1
    mov     x0, sp
    bl _ZN2nn4kern6ARMv8A15HandleExceptionEPNS0_5ARM6416ExceptionContextE

    ldp     x30, x20, [sp, #(EXCEPTION_CONTEXT_X30)]
    ldp     x21, x22, [sp, #(EXCEPTION_CONTEXT_PC)]
    ldr     x23,      [sp, #(EXCEPTION_CONTEXT_TPIDR)]
    msr     sp_el0,   x20
    msr     elr_el1,  x21
    msr     spsr_el1, x22
    msr     tpidr_el0, x23
    ldp      x0,  x1, [sp, #(EXCEPTION_CONTEXT_X0)]
    ldp      x2,  x3, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 2)]
    ldp      x4,  x5, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 4)]
    ldp      x6,  x7, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 6)]
    ldp      x8,  x9, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 8)]
    ldp     x10, x11, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 10)]
    ldp     x12, x13, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 12)]
    ldp     x14, x15, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 14)]
    ldp     x16, x17, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 16)]
    ldp     x18, x19, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 18)]
    ldp     x20, x21, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 20)]
    ldp     x22, x23, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 22)]
    ldp     x24, x25, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 24)]
    ldp     x26, x27, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 26)]
    ldp     x28, x29, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 28)]
    add     sp,   sp, #STACK_OFFSET

    eret

1:
    ldp x16, x17, [sp], #(8*2)
    b   SvcHandler32

2:
    ldp x16, x17, [sp], #(8*2)
    b   SvcHandler64

3:
    ldp x16, x17, [sp], #(8*2)
    b   FpAccessExceptionHandler

    // Tlb Conflict Abortをチェックする
.LCheckTlbConflict:
    // DFSC, IFSC Check
    and x17, x16, #0x3F
    cmp x17, #0x30
    b.ne .LNotTlbConflict

    // get ASID
    mrs x17, ttbr0_el1
    and x17, x17, #0xFFFF000000000000

    // FAR valid Check
    tbnz x16, #10, .LTlbInvalidateAll

    mrs x16, far_el1
    lsr x16, x16, #12

    orr x17, x16, x17

    tlbi vae1, x17
    b   .LReturnFromTlbConflict

.LTlbInvalidateAll:
    tlbi aside1, x17

.LReturnFromTlbConflict:
    dsb ish
    isb

    ldp x16, x17, [sp], #(8*2)
    eret
SET_SIZE(SynchronousExceptionHandlerEL0)

ENTRY(SynchronousExceptionHandlerEL1)
    // 未使用の cntv_cval_el0 をカーネル例外ハンドリングに使用する。
    msr     cntv_cval_el0, x0
    mrs     x0, esr_el1
    lsr     x0, x0, #HW_ESR_EC_SHIFT
    cmp     x0, #HW_ESR_EC_IABORT_EL1
    b.eq    .LCheckTlbConflictEL1
    cmp     x0, #HW_ESR_EC_DABORT_EL1
    b.eq    .LCheckTlbConflictEL1

.LNotTlbConflictEL1:
    mrs     x0, tpidr_el1
    ldr     x0, [x0, #CURRENTSET_EXCEPTION_STACK_END]
    sub     x0, x0, #32
    str     x1, [x0, #8]
    mov     x1, sp
    str     x1, [x0]
    mov     sp, x0
    ldr     x1, [x0, #8]
    mrs     x0, cntv_cval_el0

    str     x0, [sp, #(8 * 1)]
    str     x1, [sp, #(8 * 2)]

    /*
     *      +----------------- <- NN_KERN_V_ADDR_STACK_CMN_END
     *      |
     *      +-----------------
     *      | X1
     *      +-----------------
     *      | X0
     *      +-----------------
     *      | 例外発生時のSP
     * SP-> +---------------- 
     */
    mrs     x0, esr_el1
    lsr     x1, x0, #HW_ESR_EC_SHIFT

    cmp     x1, #HW_ESR_EC_DABORT_EL1
    b.ne    .Lnot_in_user_memory_copy

    // User Memory Copy 内でのアボートかどうかをチェック
    mrs     x1, elr_el1
    adr     x0, _ZN2nn4kern5ARM6431BeginUserMemoryCopyFunctionAreaEv
    cmp     x1, x0
    b.lo    .Lnot_in_user_memory_copy
    adr     x0, _ZN2nn4kern5ARM6429EndUserMemoryCopyFunctionAreaEv
    cmp     x1, x0
    b.hs    .Lnot_in_user_memory_copy

    ldr     x0, [sp, #(8 * 0)]
    mov     sp, x0

    mov     x0, #0
    msr     elr_el1, x30
    eret

.Lnot_in_user_memory_copy:
    ldr     x0, [sp, #(8 * 1)]
    ldr     x1, [sp, #(8 * 2)]

    sub      sp,  sp, #STACK_OFFSET
    stp      x0,  x1, [sp, #(EXCEPTION_CONTEXT_X0)]
    stp      x2,  x3, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 2)]
    stp      x4,  x5, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 4)]
    stp      x6,  x7, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 6)]
    stp      x8,  x9, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 8)]
    stp     x10, x11, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 10)]
    stp     x12, x13, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 12)]
    stp     x14, x15, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 14)]
    stp     x16, x17, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 16)]
    stp     x18, x19, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 18)]
    stp     x20, x21, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 20)]
    stp     x22, x23, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 22)]
    stp     x24, x25, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 24)]
    stp     x26, x27, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 26)]
    stp     x28, x29, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 28)]
    mrs     x20, sp_el0
    mrs     x21, elr_el1
    mrs     x22, spsr_el1
    mrs     x23, tpidr_el0
    mov     w22, w22
    stp     x30, x20, [sp, #(EXCEPTION_CONTEXT_X30)]
    stp     x21, x22, [sp, #(EXCEPTION_CONTEXT_PC)]
    str     x23,      [sp, #(EXCEPTION_CONTEXT_TPIDR)]

    mrs     x18, tpidr_el1
    mov x0, sp
    bl _ZN2nn4kern6ARMv8A15HandleExceptionEPNS0_5ARM6416ExceptionContextE

    // カーネルの例外からは復帰しない
1:  b   1b

    // Tlb Conflict Abortをチェックする
.LCheckTlbConflictEL1:
    // DFSC or IFSC Check
    and     x0, x0, #0x3F
    cmp     x0, #0x30
    b.ne    .LNotTlbConflictEL1

.LTlbInvalidateForConflictEL1:
    // FAR valid Check
    tbnz    x0, #10, .LTlbInvalidateAllEL1

    mrs     x0, far_el1
    lsr     x0, x0, #12

    tlbi    vaae1, x0
    b       .LReturnFromTlbConflictEL1

.LTlbInvalidateAllEL1:
    tlbi    vmalle1

.LReturnFromTlbConflictEL1:
    dsb     ish
    isb
    mrs     x0, cntv_cval_el0
    eret
SET_SIZE(SynchronousExceptionHandlerEL1)

ENTRY(FpAccessExceptionHandler)
    /*
     * r19-r29, SPがcallee save
     * r15-r30 は AArch32では未使用なので、最適化可能
     */
    sub sp, sp, #(8*24)

    stp x0, x1, [sp, #(8 * 0)]
    stp x2, x3, [sp, #(8 * 2)]
    stp x4, x5, [sp, #(8 * 4)]
    stp x6, x7, [sp, #(8 * 6)]
    stp x8, x9, [sp, #(8 * 8)]
    stp x10, x11, [sp, #(8 * 10)]
    stp x12, x13, [sp, #(8 * 12)]
    stp x14, x15, [sp, #(8 * 14)]
    stp x16, x17, [sp, #(8 * 16)]
    stp x18, x19, [sp, #(8 * 18)]
    stp x20, x21, [sp, #(8 * 20)]
    stp x22, x30, [sp, #(8 * 22)]

    mrs x18, tpidr_el1
    mrs x19, sp_el0
    mrs x20, elr_el1
    mrs x21, spsr_el1

    bl _ZN2nn4kern6ARMv8A23FpuContextSwitchHandlerEv

    msr sp_el0, x19
    msr elr_el1, x20
    msr spsr_el1, x21

    ldp x0, x1, [sp, #(8 * 0)]
    ldp x2, x3, [sp, #(8 * 2)]
    ldp x4, x5, [sp, #(8 * 4)]
    ldp x6, x7, [sp, #(8 * 6)]
    ldp x8, x9, [sp, #(8 * 8)]
    ldp x10, x11, [sp, #(8 * 10)]
    ldp x12, x13, [sp, #(8 * 12)]
    ldp x14, x15, [sp, #(8 * 14)]
    ldp x16, x17, [sp, #(8 * 16)]
    ldp x18, x19, [sp, #(8 * 18)]
    ldp x20, x21, [sp, #(8 * 20)]
    ldp x22, x30, [sp, #(8 * 22)]

    add sp, sp, #(8*24)
    eret
SET_SIZE(FpAccessExceptionHandler)

ENTRY(SystemErrorHandlerEL1)
    // 未使用の cntv_cval_el0 をカーネル例外ハンドリングに使用する。
    msr     cntv_cval_el0, x0
    mrs     x0, tpidr_el1
    ldr     x0, [x0, #CURRENTSET_EXCEPTION_STACK_END]
    sub     x0, x0, #32
    str     x1, [x0, #8]
    mov     x1, sp
    str     x1, [x0]
    mov     sp, x0
    ldr     x1, [x0, #8]
    mrs     x0, cntv_cval_el0

    sub      sp,  sp, #STACK_OFFSET
    stp      x0,  x1, [sp, #(EXCEPTION_CONTEXT_X0)]
    stp      x2,  x3, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 2)]
    stp      x4,  x5, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 4)]
    stp      x6,  x7, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 6)]
    stp      x8,  x9, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 8)]
    stp     x10, x11, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 10)]
    stp     x12, x13, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 12)]
    stp     x14, x15, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 14)]
    stp     x16, x17, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 16)]
    stp     x18, x19, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 18)]
    stp     x20, x21, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 20)]
    stp     x22, x23, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 22)]
    stp     x24, x25, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 24)]
    stp     x26, x27, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 26)]
    stp     x28, x29, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 28)]
    mrs     x20, sp_el0
    mrs     x21, elr_el1
    mrs     x22, spsr_el1
    mrs     x23, tpidr_el0
    mov     w22, w22
    stp     x30, x20, [sp, #(EXCEPTION_CONTEXT_X30)]
    stp     x21, x22, [sp, #(EXCEPTION_CONTEXT_PC)]
    str     x23,      [sp, #(EXCEPTION_CONTEXT_TPIDR)]

    mrs     x18, tpidr_el1
    mov x0, sp
    bl _ZN2nn4kern6ARMv8A15HandleExceptionEPNS0_5ARM6416ExceptionContextE

    // カーネルの例外からは復帰しない
1:  b   1b
SET_SIZE(SystemErrorHandlerEL1)

ENTRY(SystemErrorHandlerEL0)
    // 例外ハンドラ呼び出し
    sub      sp,  sp, #STACK_OFFSET
    stp      x0,  x1, [sp, #(EXCEPTION_CONTEXT_X0)]
    stp      x2,  x3, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 2)]
    stp      x4,  x5, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 4)]
    stp      x6,  x7, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 6)]
    stp      x8,  x9, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 8)]
    stp     x10, x11, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 10)]
    stp     x12, x13, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 12)]
    stp     x14, x15, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 14)]
    stp     x16, x17, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 16)]
    stp     x18, x19, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 18)]
    stp     x20, x21, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 20)]
    stp     x22, x23, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 22)]
    stp     x24, x25, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 24)]
    stp     x26, x27, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 26)]
    stp     x28, x29, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 28)]
    mrs     x20, sp_el0
    mrs     x21, elr_el1
    mrs     x22, spsr_el1
    mrs     x23, tpidr_el0
    mov     w22, w22
    stp     x30, x20, [sp, #(EXCEPTION_CONTEXT_X30)]
    stp     x21, x22, [sp, #(EXCEPTION_CONTEXT_PC)]
    str     x23,      [sp, #(EXCEPTION_CONTEXT_TPIDR)]

    mrs     x18, tpidr_el1
    mov x0, sp
    bl _ZN2nn4kern6ARMv8A15HandleExceptionEPNS0_5ARM6416ExceptionContextE

    ldp     x30, x20, [sp, #(EXCEPTION_CONTEXT_X30)]
    ldp     x21, x22, [sp, #(EXCEPTION_CONTEXT_PC)]
    ldr     x23,      [sp, #(EXCEPTION_CONTEXT_TPIDR)]
    msr     sp_el0,   x20
    msr     elr_el1,  x21
    msr     spsr_el1, x22
    msr     tpidr_el0, x23
    ldp      x0,  x1, [sp, #(EXCEPTION_CONTEXT_X0)]
    ldp      x2,  x3, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 2)]
    ldp      x4,  x5, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 4)]
    ldp      x6,  x7, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 6)]
    ldp      x8,  x9, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 8)]
    ldp     x10, x11, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 10)]
    ldp     x12, x13, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 12)]
    ldp     x14, x15, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 14)]
    ldp     x16, x17, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 16)]
    ldp     x18, x19, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 18)]
    ldp     x20, x21, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 20)]
    ldp     x22, x23, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 22)]
    ldp     x24, x25, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 24)]
    ldp     x26, x27, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 26)]
    ldp     x28, x29, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 28)]
    add     sp,   sp, #STACK_OFFSET

    eret
SET_SIZE(SystemErrorHandlerEL0)

