﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*
 * このファイルを編集しないでください。
 * このファイルは自動生成されます。
 */


//
// type name                                size al abstr comon
//
// Handle                                      4  4 True  True 
// ProgramId                                   8  8 True  True 
// MemoryState                                 4  4 True  True 
// MemoryAttribute                             4  4 True  True 
// MemoryPermission                            4  4 True  True 
// InterruptType                               4  4 True  True 
// BreakReason                                 4  4 True  True 
// InfoType                                    4  4 True  True 
// SystemInfoType                              4  4 True  True 
// KernelDebugType                             4  4 True  True 
// LimitableResource                           4  4 True  True 
// ThreadActivity                              4  4 True  True 
// ProcessActivity                             4  4 True  True 
// KernelTraceState                            4  4 True  True 
// CodeMemoryOperation                         4  4 True  True 
// ArbitrationType                             4  4 True  True 
// SignalType                                  4  4 True  True 
// PageInfo                                    4  4 True  True 
// ThreadFunc                                  4  4 True  False
// MemoryInfo                                 40  8 False False
// LastThreadContext                          16  4 False False
// DebugEvent                                  4  4 True  True 
// DebugException                              4  4 True  True 
// ProcessExitReason                           4  4 True  True 
// ThreadExitReason                            4  4 True  True 
// BreakPointType                              4  4 True  True 
// DebugThreadParam                            4  4 True  True 
// HardwareBreakPointRegisterName              4  4 True  True 
// DebugInfoCreateProcess                     40  8 False False
// DebugInfoCreateThread                      16  8 False False
// DebugInfoExitProcess                        4  4 False False
// DebugInfoExitThread                         4  4 False False
// DebugInfoExceptionAccessViolationData       4  4 False False
// DebugInfoExceptionDataTypeMissaligned       4  4 False False
// DebugInfoExceptionBreakPoint                8  4 False False
// DebugInfoExceptionUserBreak                12  4 False False
// DebugInfoExceptionDebuggerBreak            32  8 False False
// DebugInfoExceptionUndefinedInstruction      4  4 False False
// DebugInfoExceptionUndefinedSystemCall       4  4 False False
// DebugInfoExceptionDetail                   32  8 False False
// DebugInfoException                         40  8 False False
// DebugInfo                                  40  8 False False
// DebugEventInfo                             56  8 False False
// ThreadContext                             332  4 True  True 
// DeviceName                                  4  4 True  True 
// PhysicalAddress                             8  8 True  True 
// DMADeviceConfig                            10  2 True  True 
// DmaConfig                                  24  2 True  True 
// PhysicalMemoryInfo                         16  8 False False
// CreateProcessParameterFlags                 4  4 True  True 
// ProcessInfoType                             4  4 True  True 
// CreateProcessParameter                     48  8 False False
//

//-------------------------------------------------
// Result SetHeapSize(uintptr_t* pOut, size_t size)
//
//     Invariant s=4 r=8 p=4       AArch32 s=4 r=4 p=4
// in  svc                         abi
//                                 Register 0  ref  4 pOut
//     Register 1       4 size     Register 1       4 size
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//     Register 1       4 pOut     
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc7Aarch3215CallSetHeapSizeEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3215CallSetHeapSizeEv
    .type    _ZN2nn4kern3svc7Aarch3215CallSetHeapSizeEv, %function
    .type    _ZN2nn4kern3svc16SvcSetHeapSize32EPjj, %function
_ZN2nn4kern3svc7Aarch3215CallSetHeapSizeEv:

    push     {lr}
    sub      sp, sp, #4

    str      r1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      r0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc16SvcSetHeapSize32EPjj

    ldr      r1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #4
    pop      {pc}

    .size _ZN2nn4kern3svc7Aarch3215CallSetHeapSizeEv, [.-_ZN2nn4kern3svc7Aarch3215CallSetHeapSizeEv]

//-------------------------------------------------
// Result QueryMemory(KUserPointer<nn::svc::ilp32::MemoryInfo*> pBlockInfo, nn::svc::PageInfo* pPageInfo, uintptr_t addr)
//
//     Invariant s=4 r=8 p=4           AArch32 s=4 r=4 p=4
// in  svc                             abi
//     Register 0  ref 40 pBlockInfo   Register 0  ref 40 pBlockInfo
//                                     Register 1  ref  4 pPageInfo
//     Register 2       4 addr         Register 2       4 addr
//
// in  svc                             abi
//     Register 0       4 return       Register 0       4 return
//     Register 1       4 pPageInfo    
//
// conversion
//   Scatter         pPageInfo

    .section .text._ZN2nn4kern3svc7Aarch3215CallQueryMemoryEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3215CallQueryMemoryEv
    .type    _ZN2nn4kern3svc7Aarch3215CallQueryMemoryEv, %function
    .type    _ZN2nn4kern3svc16SvcQueryMemory32ENS1_12KUserPointerIPNS_3svc5ilp3210MemoryInfoEvEEPNS3_8PageInfoEj, %function
_ZN2nn4kern3svc7Aarch3215CallQueryMemoryEv:

    push     {lr}
    sub      sp, sp, #4

    str      r1, [sp, #0]              // pPageInfo の第 1 ワードをレジスタからスタックへ
    add      r1, sp, #0                // pPageInfo のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc16SvcQueryMemory32ENS1_12KUserPointerIPNS_3svc5ilp3210MemoryInfoEvEEPNS3_8PageInfoEj

    ldr      r1, [sp, #0]              // pPageInfo の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #4
    pop      {pc}

    .size _ZN2nn4kern3svc7Aarch3215CallQueryMemoryEv, [.-_ZN2nn4kern3svc7Aarch3215CallQueryMemoryEv]

//-------------------------------------------------
// Result CreateThread(nn::svc::Handle* pOut, nn::svc::ilp32::ThreadFunc f, uintptr_t param, uintptr_t stackBottom, int32_t priority, int32_t idealCore)
//
//     Invariant s=4 r=8 p=4            AArch32 s=4 r=4 p=4
// in  svc                              abi
//     Register 0       4 priority      Register 0  ref  4 pOut
//     Register 1       4 f             Register 1       4 f
//     Register 2       4 param         Register 2       4 param
//     Register 3       4 stackBottom   Register 3       4 stackBottom
//     Register 4       4 idealCore     
//                                      Stack    0       4 priority
//                                      Stack    1       4 idealCore
//
// in  svc                              abi
//     Register 0       4 return        Register 0       4 return
//     Register 1       4 pOut          
//
// conversion
//   Load            priority
//   Load            idealCore
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc7Aarch3216CallCreateThreadEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3216CallCreateThreadEv
    .type    _ZN2nn4kern3svc7Aarch3216CallCreateThreadEv, %function
    .type    _ZN2nn4kern3svc17SvcCreateThread32EPNS_3svc6HandleEjjjii, %function
_ZN2nn4kern3svc7Aarch3216CallCreateThreadEv:

    push     {lr}
    sub      sp, sp, #12

    str      r0, [sp, #0]              // priority の値 をレジスタからスタックへ
    str      r4, [sp, #4]              // idealCore の値 をレジスタからスタックへ

    str      r1, [sp, #8]              // pOut の第 1 ワードをレジスタからスタックへ
    add      r0, sp, #8                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc17SvcCreateThread32EPNS_3svc6HandleEjjjii

    ldr      r1, [sp, #8]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #12
    pop      {pc}

    .size _ZN2nn4kern3svc7Aarch3216CallCreateThreadEv, [.-_ZN2nn4kern3svc7Aarch3216CallCreateThreadEv]

//-------------------------------------------------
// Result GetThreadPriority(int32_t* pOut, nn::svc::Handle thread)
//
//     Invariant s=4 r=8 p=4       AArch32 s=4 r=4 p=4
// in  svc                         abi
//                                 Register 0  ref  4 pOut
//     Register 1       4 thread   Register 1       4 thread
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//     Register 1       4 pOut     
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc7Aarch3221CallGetThreadPriorityEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3221CallGetThreadPriorityEv
    .type    _ZN2nn4kern3svc7Aarch3221CallGetThreadPriorityEv, %function
    .type    _ZN2nn4kern3svc22SvcGetThreadPriority32EPiNS_3svc6HandleE, %function
_ZN2nn4kern3svc7Aarch3221CallGetThreadPriorityEv:

    push     {lr}
    sub      sp, sp, #4

    str      r1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      r0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc22SvcGetThreadPriority32EPiNS_3svc6HandleE

    ldr      r1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #4
    pop      {pc}

    .size _ZN2nn4kern3svc7Aarch3221CallGetThreadPriorityEv, [.-_ZN2nn4kern3svc7Aarch3221CallGetThreadPriorityEv]

//-------------------------------------------------
// Result GetThreadCoreMask(int32_t* pIdealCore, nn::Bit64* pAffinityMask, nn::svc::Handle thread)
//
//     Invariant s=4 r=8 p=4              AArch32 s=4 r=4 p=4
// in  svc                                abi
//                                        Register 0  ref  4 pIdealCore
//                                        Register 1  ref  8 pAffinityMask
//     Register 2       4 thread          Register 2       4 thread
//
// in  svc                                abi
//     Register 0       4 return          Register 0       4 return
//     Register 1       4 pIdealCore      
//     Register 2       8 pAffinityMask   
//     Register 3       8 pAffinityMask   
//
// conversion
//   Scatter         pIdealCore
//   Scatter         pAffinityMask

    .section .text._ZN2nn4kern3svc7Aarch3221CallGetThreadCoreMaskEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3221CallGetThreadCoreMaskEv
    .type    _ZN2nn4kern3svc7Aarch3221CallGetThreadCoreMaskEv, %function
    .type    _ZN2nn4kern3svc22SvcGetThreadCoreMask32EPiPyNS_3svc6HandleE, %function
_ZN2nn4kern3svc7Aarch3221CallGetThreadCoreMaskEv:

    push     {lr}
    sub      sp, sp, #12

    str      r1, [sp, #0]              // pIdealCore の第 1 ワードをレジスタからスタックへ
    add      r0, sp, #0                // pIdealCore のアドレスをレジスタへ
    str      r2, [sp, #4]              // pAffinityMask の第 1 ワードをレジスタからスタックへ
    str      r3, [sp, #8]              // pAffinityMask の第 2 ワードをレジスタからスタックへ
    add      r1, sp, #4                // pAffinityMask のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc22SvcGetThreadCoreMask32EPiPyNS_3svc6HandleE

    ldr      r1, [sp, #0]              // pIdealCore の第 1 ワードをスタックからレジスタへ
    ldr      r2, [sp, #4]              // pAffinityMask の第 1 ワードをスタックからレジスタへ
    ldr      r3, [sp, #8]              // pAffinityMask の第 2 ワードをスタックからレジスタへ

    add      sp, sp, #12
    pop      {pc}

    .size _ZN2nn4kern3svc7Aarch3221CallGetThreadCoreMaskEv, [.-_ZN2nn4kern3svc7Aarch3221CallGetThreadCoreMaskEv]

//-------------------------------------------------
// Result CreateTransferMemory(nn::svc::Handle* pOut, uintptr_t addr, size_t size, nn::svc::MemoryPermission myPermission)
//
//     Invariant s=4 r=8 p=4             AArch32 s=4 r=4 p=4
// in  svc                               abi
//                                       Register 0  ref  4 pOut
//     Register 1       4 addr           Register 1       4 addr
//     Register 2       4 size           Register 2       4 size
//     Register 3       4 myPermission   Register 3       4 myPermission
//
// in  svc                               abi
//     Register 0       4 return         Register 0       4 return
//     Register 1       4 pOut           
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc7Aarch3224CallCreateTransferMemoryEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3224CallCreateTransferMemoryEv
    .type    _ZN2nn4kern3svc7Aarch3224CallCreateTransferMemoryEv, %function
    .type    _ZN2nn4kern3svc25SvcCreateTransferMemory32EPNS_3svc6HandleEjjNS2_16MemoryPermissionE, %function
_ZN2nn4kern3svc7Aarch3224CallCreateTransferMemoryEv:

    push     {lr}
    sub      sp, sp, #4

    str      r1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      r0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc25SvcCreateTransferMemory32EPNS_3svc6HandleEjjNS2_16MemoryPermissionE

    ldr      r1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #4
    pop      {pc}

    .size _ZN2nn4kern3svc7Aarch3224CallCreateTransferMemoryEv, [.-_ZN2nn4kern3svc7Aarch3224CallCreateTransferMemoryEv]

//-------------------------------------------------
// Result WaitSynchronization(int32_t* pOut, KUserPointer<const nn::svc::Handle*> handles, int32_t numHandles, int64_t ns)
//
//     Invariant s=4 r=8 p=4           AArch32 s=4 r=4 p=4
// in  svc                             abi
//     Register 0       8 ns           Register 0  ref  4 pOut
//     Register 1  ref -- handles      Register 1  ref -- handles
//     Register 2       4 numHandles   Register 2       4 numHandles
//     Register 3       8 ns           
//                                     Stack    0       8 ns
//                                     Stack    1       8 ns
//
// in  svc                             abi
//     Register 0       4 return       Register 0       4 return
//     Register 1       4 pOut         
//
// conversion
//   Load            ns
//   Load            ns
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc7Aarch3223CallWaitSynchronizationEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3223CallWaitSynchronizationEv
    .type    _ZN2nn4kern3svc7Aarch3223CallWaitSynchronizationEv, %function
    .type    _ZN2nn4kern3svc24SvcWaitSynchronization32EPiNS1_12KUserPointerIPKNS_3svc6HandleEvEEix, %function
_ZN2nn4kern3svc7Aarch3223CallWaitSynchronizationEv:

    push     {lr}
    sub      sp, sp, #12

    str      r0, [sp, #0]              // ns の値 をレジスタからスタックへ
    str      r3, [sp, #4]              // ns の値 をレジスタからスタックへ

    str      r1, [sp, #8]              // pOut の第 1 ワードをレジスタからスタックへ
    add      r0, sp, #8                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc24SvcWaitSynchronization32EPiNS1_12KUserPointerIPKNS_3svc6HandleEvEEix

    ldr      r1, [sp, #8]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #12
    pop      {pc}

    .size _ZN2nn4kern3svc7Aarch3223CallWaitSynchronizationEv, [.-_ZN2nn4kern3svc7Aarch3223CallWaitSynchronizationEv]

//-------------------------------------------------
// Result WaitProcessWideKeyAtomic(uintptr_t addr, uintptr_t cvKey, nn::Bit32 ownValue, int64_t ns)
//
//     Invariant s=4 r=8 p=4         AArch32 s=4 r=4 p=4
// in  svc                           abi
//     Register 0       4 addr       Register 0       4 addr
//     Register 1       4 cvKey      Register 1       4 cvKey
//     Register 2       4 ownValue   Register 2       4 ownValue
//     Register 3       8 ns         
//     Register 4       8 ns         
//                                   Stack    0       8 ns
//                                   Stack    1       8 ns
//
// in  svc                           abi
//     Register 0       4 return     Register 0       4 return
//
// conversion
//   Load            ns
//   Load            ns

    .section .text._ZN2nn4kern3svc7Aarch3228CallWaitProcessWideKeyAtomicEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3228CallWaitProcessWideKeyAtomicEv
    .type    _ZN2nn4kern3svc7Aarch3228CallWaitProcessWideKeyAtomicEv, %function
    .type    _ZN2nn4kern3svc29SvcWaitProcessWideKeyAtomic32Ejjjx, %function
_ZN2nn4kern3svc7Aarch3228CallWaitProcessWideKeyAtomicEv:

    push     {r12,lr}
    sub      sp, sp, #8

    str      r3, [sp, #0]              // ns の値 をレジスタからスタックへ
    str      r4, [sp, #4]              // ns の値 をレジスタからスタックへ

    bl       _ZN2nn4kern3svc29SvcWaitProcessWideKeyAtomic32Ejjjx

    add      sp, sp, #8
    pop      {r12,pc}

    .size _ZN2nn4kern3svc7Aarch3228CallWaitProcessWideKeyAtomicEv, [.-_ZN2nn4kern3svc7Aarch3228CallWaitProcessWideKeyAtomicEv]

//-------------------------------------------------
// Result ConnectToNamedPort(nn::svc::Handle* pOut, KUserPointer<const char*> name)
//
//     Invariant s=4 r=8 p=4       AArch32 s=4 r=4 p=4
// in  svc                         abi
//                                 Register 0  ref  4 pOut
//     Register 1  ref -- name     Register 1  ref -- name
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//     Register 1       4 pOut     
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc7Aarch3222CallConnectToNamedPortEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3222CallConnectToNamedPortEv
    .type    _ZN2nn4kern3svc7Aarch3222CallConnectToNamedPortEv, %function
    .type    _ZN2nn4kern3svc23SvcConnectToNamedPort32EPNS_3svc6HandleENS1_12KUserPointerIPKcvEE, %function
_ZN2nn4kern3svc7Aarch3222CallConnectToNamedPortEv:

    push     {lr}
    sub      sp, sp, #4

    str      r1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      r0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc23SvcConnectToNamedPort32EPNS_3svc6HandleENS1_12KUserPointerIPKcvEE

    ldr      r1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #4
    pop      {pc}

    .size _ZN2nn4kern3svc7Aarch3222CallConnectToNamedPortEv, [.-_ZN2nn4kern3svc7Aarch3222CallConnectToNamedPortEv]

//-------------------------------------------------
// Result SendAsyncRequestWithUserBuffer(nn::svc::Handle* pEvent, uintptr_t pMessage, size_t bufferSize, nn::svc::Handle session)
//
//     Invariant s=4 r=8 p=4           AArch32 s=4 r=4 p=4
// in  svc                             abi
//                                     Register 0  ref  4 pEvent
//     Register 1       4 pMessage     Register 1       4 pMessage
//     Register 2       4 bufferSize   Register 2       4 bufferSize
//     Register 3       4 session      Register 3       4 session
//
// in  svc                             abi
//     Register 0       4 return       Register 0       4 return
//     Register 1       4 pEvent       
//
// conversion
//   Scatter         pEvent

    .section .text._ZN2nn4kern3svc7Aarch3234CallSendAsyncRequestWithUserBufferEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3234CallSendAsyncRequestWithUserBufferEv
    .type    _ZN2nn4kern3svc7Aarch3234CallSendAsyncRequestWithUserBufferEv, %function
    .type    _ZN2nn4kern3svc35SvcSendAsyncRequestWithUserBuffer32EPNS_3svc6HandleEjjS3_, %function
_ZN2nn4kern3svc7Aarch3234CallSendAsyncRequestWithUserBufferEv:

    push     {lr}
    sub      sp, sp, #4

    str      r1, [sp, #0]              // pEvent の第 1 ワードをレジスタからスタックへ
    add      r0, sp, #0                // pEvent のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc35SvcSendAsyncRequestWithUserBuffer32EPNS_3svc6HandleEjjS3_

    ldr      r1, [sp, #0]              // pEvent の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #4
    pop      {pc}

    .size _ZN2nn4kern3svc7Aarch3234CallSendAsyncRequestWithUserBufferEv, [.-_ZN2nn4kern3svc7Aarch3234CallSendAsyncRequestWithUserBufferEv]

//-------------------------------------------------
// Result GetProcessId(nn::Bit64* pOut, nn::svc::Handle process)
//
//     Invariant s=4 r=8 p=4        AArch32 s=4 r=4 p=4
// in  svc                          abi
//                                  Register 0  ref  8 pOut
//     Register 1       4 process   Register 1       4 process
//
// in  svc                          abi
//     Register 0       4 return    Register 0       4 return
//     Register 1       8 pOut      
//     Register 2       8 pOut      
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc7Aarch3216CallGetProcessIdEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3216CallGetProcessIdEv
    .type    _ZN2nn4kern3svc7Aarch3216CallGetProcessIdEv, %function
    .type    _ZN2nn4kern3svc17SvcGetProcessId32EPyNS_3svc6HandleE, %function
_ZN2nn4kern3svc7Aarch3216CallGetProcessIdEv:

    push     {r12,lr}
    sub      sp, sp, #8

    str      r1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    str      r2, [sp, #4]              // pOut の第 2 ワードをレジスタからスタックへ
    add      r0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc17SvcGetProcessId32EPyNS_3svc6HandleE

    ldr      r1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ
    ldr      r2, [sp, #4]              // pOut の第 2 ワードをスタックからレジスタへ

    add      sp, sp, #8
    pop      {r12,pc}

    .size _ZN2nn4kern3svc7Aarch3216CallGetProcessIdEv, [.-_ZN2nn4kern3svc7Aarch3216CallGetProcessIdEv]

//-------------------------------------------------
// Result GetThreadId(nn::Bit64* pOut, nn::svc::Handle thread)
//
//     Invariant s=4 r=8 p=4       AArch32 s=4 r=4 p=4
// in  svc                         abi
//                                 Register 0  ref  8 pOut
//     Register 1       4 thread   Register 1       4 thread
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//     Register 1       8 pOut     
//     Register 2       8 pOut     
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc7Aarch3215CallGetThreadIdEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3215CallGetThreadIdEv
    .type    _ZN2nn4kern3svc7Aarch3215CallGetThreadIdEv, %function
    .type    _ZN2nn4kern3svc16SvcGetThreadId32EPyNS_3svc6HandleE, %function
_ZN2nn4kern3svc7Aarch3215CallGetThreadIdEv:

    push     {r12,lr}
    sub      sp, sp, #8

    str      r1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    str      r2, [sp, #4]              // pOut の第 2 ワードをレジスタからスタックへ
    add      r0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc16SvcGetThreadId32EPyNS_3svc6HandleE

    ldr      r1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ
    ldr      r2, [sp, #4]              // pOut の第 2 ワードをスタックからレジスタへ

    add      sp, sp, #8
    pop      {r12,pc}

    .size _ZN2nn4kern3svc7Aarch3215CallGetThreadIdEv, [.-_ZN2nn4kern3svc7Aarch3215CallGetThreadIdEv]

//-------------------------------------------------
// Result GetInfo(nn::Bit64* pOut, nn::svc::InfoType type, nn::svc::Handle handle, nn::Bit64 param)
//
//     Invariant s=4 r=8 p=4       AArch32 s=4 r=4 p=4
// in  svc                         abi
//     Register 0       8 param    Register 0  ref  8 pOut
//     Register 1       4 type     Register 1       4 type
//     Register 2       4 handle   Register 2       4 handle
//     Register 3       8 param    
//                                 Stack    0       8 param
//                                 Stack    1       8 param
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//     Register 1       8 pOut     
//     Register 2       8 pOut     
//
// conversion
//   Load            param
//   Load            param
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc7Aarch3211CallGetInfoEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3211CallGetInfoEv
    .type    _ZN2nn4kern3svc7Aarch3211CallGetInfoEv, %function
    .type    _ZN2nn4kern3svc12SvcGetInfo32EPyNS_3svc8InfoTypeENS3_6HandleEy, %function
_ZN2nn4kern3svc7Aarch3211CallGetInfoEv:

    push     {r12,lr}
    sub      sp, sp, #16

    str      r0, [sp, #0]              // param の値 をレジスタからスタックへ
    str      r3, [sp, #4]              // param の値 をレジスタからスタックへ

    str      r1, [sp, #8]              // pOut の第 1 ワードをレジスタからスタックへ
    str      r2, [sp, #12]             // pOut の第 2 ワードをレジスタからスタックへ
    add      r0, sp, #8                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc12SvcGetInfo32EPyNS_3svc8InfoTypeENS3_6HandleEy

    ldr      r1, [sp, #8]              // pOut の第 1 ワードをスタックからレジスタへ
    ldr      r2, [sp, #12]             // pOut の第 2 ワードをスタックからレジスタへ

    add      sp, sp, #16
    pop      {r12,pc}

    .size _ZN2nn4kern3svc7Aarch3211CallGetInfoEv, [.-_ZN2nn4kern3svc7Aarch3211CallGetInfoEv]

//-------------------------------------------------
// Result GetDebugFutureThreadInfo(nn::svc::ilp32::LastThreadContext* pContext, nn::Bit64* threadId, nn::svc::Handle debug, int64_t ns)
//
//     Invariant s=4 r=8 p=4         AArch32 s=4 r=4 p=4
// in  svc                           abi
//     Register 0       8 ns         Register 0  ref 16 pContext
//     Register 1       8 ns         Register 1  ref  8 threadId
//     Register 2       4 debug      Register 2       4 debug
//                                   Stack    0       8 ns
//                                   Stack    1       8 ns
//
// in  svc                           abi
//     Register 0       4 return     Register 0       4 return
//     Register 1      16 pContext   
//     Register 2      16 pContext   
//     Register 3      16 pContext   
//     Register 4      16 pContext   
//     Register 5       8 threadId   
//     Register 6       8 threadId   
//
// conversion
//   Load            ns
//   Load            ns
//   Scatter         pContext
//   Scatter         threadId

    .section .text._ZN2nn4kern3svc7Aarch3228CallGetDebugFutureThreadInfoEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3228CallGetDebugFutureThreadInfoEv
    .type    _ZN2nn4kern3svc7Aarch3228CallGetDebugFutureThreadInfoEv, %function
    .type    _ZN2nn4kern3svc29SvcGetDebugFutureThreadInfo32EPNS_3svc5ilp3217LastThreadContextEPyNS2_6HandleEx, %function
_ZN2nn4kern3svc7Aarch3228CallGetDebugFutureThreadInfoEv:

    push     {r12,lr}
    sub      sp, sp, #32

    str      r0, [sp, #0]              // ns の値 をレジスタからスタックへ
    str      r1, [sp, #4]              // ns の値 をレジスタからスタックへ

    str      r1, [sp, #8]              // pContext の第 1 ワードをレジスタからスタックへ
    str      r2, [sp, #12]             // pContext の第 2 ワードをレジスタからスタックへ
    str      r3, [sp, #16]             // pContext の第 3 ワードをレジスタからスタックへ
    str      r4, [sp, #20]             // pContext の第 4 ワードをレジスタからスタックへ
    add      r0, sp, #8                // pContext のアドレスをレジスタへ
    str      r5, [sp, #24]             // threadId の第 1 ワードをレジスタからスタックへ
    str      r6, [sp, #28]             // threadId の第 2 ワードをレジスタからスタックへ
    add      r1, sp, #24               // threadId のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc29SvcGetDebugFutureThreadInfo32EPNS_3svc5ilp3217LastThreadContextEPyNS2_6HandleEx

    ldr      r1, [sp, #8]              // pContext の第 1 ワードをスタックからレジスタへ
    ldr      r2, [sp, #12]             // pContext の第 2 ワードをスタックからレジスタへ
    ldr      r3, [sp, #16]             // pContext の第 3 ワードをスタックからレジスタへ
    ldr      r4, [sp, #20]             // pContext の第 4 ワードをスタックからレジスタへ
    ldr      r5, [sp, #24]             // threadId の第 1 ワードをスタックからレジスタへ
    ldr      r6, [sp, #28]             // threadId の第 2 ワードをスタックからレジスタへ

    add      sp, sp, #32
    pop      {r12,pc}

    .size _ZN2nn4kern3svc7Aarch3228CallGetDebugFutureThreadInfoEv, [.-_ZN2nn4kern3svc7Aarch3228CallGetDebugFutureThreadInfoEv]

//-------------------------------------------------
// Result GetLastThreadInfo(nn::svc::ilp32::LastThreadContext* pContext, uintptr_t* pTlsAddr, nn::Bit32* pFlag)
//
//     Invariant s=4 r=8 p=4         AArch32 s=4 r=4 p=4
// in  svc                           abi
//                                   Register 0  ref 16 pContext
//                                   Register 1  ref  4 pTlsAddr
//                                   Register 2  ref  4 pFlag
//
// in  svc                           abi
//     Register 0       4 return     Register 0       4 return
//     Register 1      16 pContext   
//     Register 2      16 pContext   
//     Register 3      16 pContext   
//     Register 4      16 pContext   
//     Register 5       4 pTlsAddr   
//     Register 6       4 pFlag      
//
// conversion
//   Scatter         pContext
//   Scatter         pTlsAddr
//   Scatter         pFlag

    .section .text._ZN2nn4kern3svc7Aarch3221CallGetLastThreadInfoEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3221CallGetLastThreadInfoEv
    .type    _ZN2nn4kern3svc7Aarch3221CallGetLastThreadInfoEv, %function
    .type    _ZN2nn4kern3svc22SvcGetLastThreadInfo32EPNS_3svc5ilp3217LastThreadContextEPjS6_, %function
_ZN2nn4kern3svc7Aarch3221CallGetLastThreadInfoEv:

    push     {r12,lr}
    sub      sp, sp, #24

    str      r1, [sp, #0]              // pContext の第 1 ワードをレジスタからスタックへ
    str      r2, [sp, #4]              // pContext の第 2 ワードをレジスタからスタックへ
    str      r3, [sp, #8]              // pContext の第 3 ワードをレジスタからスタックへ
    str      r4, [sp, #12]             // pContext の第 4 ワードをレジスタからスタックへ
    add      r0, sp, #0                // pContext のアドレスをレジスタへ
    str      r5, [sp, #16]             // pTlsAddr の第 1 ワードをレジスタからスタックへ
    add      r1, sp, #16               // pTlsAddr のアドレスをレジスタへ
    str      r6, [sp, #20]             // pFlag の第 1 ワードをレジスタからスタックへ
    add      r2, sp, #20               // pFlag のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc22SvcGetLastThreadInfo32EPNS_3svc5ilp3217LastThreadContextEPjS6_

    ldr      r1, [sp, #0]              // pContext の第 1 ワードをスタックからレジスタへ
    ldr      r2, [sp, #4]              // pContext の第 2 ワードをスタックからレジスタへ
    ldr      r3, [sp, #8]              // pContext の第 3 ワードをスタックからレジスタへ
    ldr      r4, [sp, #12]             // pContext の第 4 ワードをスタックからレジスタへ
    ldr      r5, [sp, #16]             // pTlsAddr の第 1 ワードをスタックからレジスタへ
    ldr      r6, [sp, #20]             // pFlag の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #24
    pop      {r12,pc}

    .size _ZN2nn4kern3svc7Aarch3221CallGetLastThreadInfoEv, [.-_ZN2nn4kern3svc7Aarch3221CallGetLastThreadInfoEv]

//-------------------------------------------------
// Result GetResourceLimitLimitValue(int64_t* value, nn::svc::Handle resourceLimit, nn::svc::LimitableResource resource)
//
//     Invariant s=4 r=8 p=4              AArch32 s=4 r=4 p=4
// in  svc                                abi
//                                        Register 0  ref  8 value
//     Register 1       4 resourceLimit   Register 1       4 resourceLimit
//     Register 2       4 resource        Register 2       4 resource
//
// in  svc                                abi
//     Register 0       4 return          Register 0       4 return
//     Register 1       8 value           
//     Register 2       8 value           
//
// conversion
//   Scatter         value

    .section .text._ZN2nn4kern3svc7Aarch3230CallGetResourceLimitLimitValueEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3230CallGetResourceLimitLimitValueEv
    .type    _ZN2nn4kern3svc7Aarch3230CallGetResourceLimitLimitValueEv, %function
    .type    _ZN2nn4kern3svc31SvcGetResourceLimitLimitValue32EPxNS_3svc6HandleENS3_17LimitableResourceE, %function
_ZN2nn4kern3svc7Aarch3230CallGetResourceLimitLimitValueEv:

    push     {r12,lr}
    sub      sp, sp, #8

    str      r1, [sp, #0]              // value の第 1 ワードをレジスタからスタックへ
    str      r2, [sp, #4]              // value の第 2 ワードをレジスタからスタックへ
    add      r0, sp, #0                // value のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc31SvcGetResourceLimitLimitValue32EPxNS_3svc6HandleENS3_17LimitableResourceE

    ldr      r1, [sp, #0]              // value の第 1 ワードをスタックからレジスタへ
    ldr      r2, [sp, #4]              // value の第 2 ワードをスタックからレジスタへ

    add      sp, sp, #8
    pop      {r12,pc}

    .size _ZN2nn4kern3svc7Aarch3230CallGetResourceLimitLimitValueEv, [.-_ZN2nn4kern3svc7Aarch3230CallGetResourceLimitLimitValueEv]

//-------------------------------------------------
// Result GetResourceLimitCurrentValue(int64_t* value, nn::svc::Handle resourceLimit, nn::svc::LimitableResource resource)
//
//     Invariant s=4 r=8 p=4              AArch32 s=4 r=4 p=4
// in  svc                                abi
//                                        Register 0  ref  8 value
//     Register 1       4 resourceLimit   Register 1       4 resourceLimit
//     Register 2       4 resource        Register 2       4 resource
//
// in  svc                                abi
//     Register 0       4 return          Register 0       4 return
//     Register 1       8 value           
//     Register 2       8 value           
//
// conversion
//   Scatter         value

    .section .text._ZN2nn4kern3svc7Aarch3232CallGetResourceLimitCurrentValueEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3232CallGetResourceLimitCurrentValueEv
    .type    _ZN2nn4kern3svc7Aarch3232CallGetResourceLimitCurrentValueEv, %function
    .type    _ZN2nn4kern3svc33SvcGetResourceLimitCurrentValue32EPxNS_3svc6HandleENS3_17LimitableResourceE, %function
_ZN2nn4kern3svc7Aarch3232CallGetResourceLimitCurrentValueEv:

    push     {r12,lr}
    sub      sp, sp, #8

    str      r1, [sp, #0]              // value の第 1 ワードをレジスタからスタックへ
    str      r2, [sp, #4]              // value の第 2 ワードをレジスタからスタックへ
    add      r0, sp, #0                // value のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc33SvcGetResourceLimitCurrentValue32EPxNS_3svc6HandleENS3_17LimitableResourceE

    ldr      r1, [sp, #0]              // value の第 1 ワードをスタックからレジスタへ
    ldr      r2, [sp, #4]              // value の第 2 ワードをスタックからレジスタへ

    add      sp, sp, #8
    pop      {r12,pc}

    .size _ZN2nn4kern3svc7Aarch3232CallGetResourceLimitCurrentValueEv, [.-_ZN2nn4kern3svc7Aarch3232CallGetResourceLimitCurrentValueEv]

//-------------------------------------------------
// Result WaitForAddress(uintptr_t addr, nn::svc::ArbitrationType type, int32_t value, int64_t ns)
//
//     Invariant s=4 r=8 p=4       AArch32 s=4 r=4 p=4
// in  svc                         abi
//     Register 0       4 addr     Register 0       4 addr
//     Register 1       4 type     Register 1       4 type
//     Register 2       4 value    Register 2       4 value
//     Register 3       8 ns       
//     Register 4       8 ns       
//                                 Stack    0       8 ns
//                                 Stack    1       8 ns
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//
// conversion
//   Load            ns
//   Load            ns

    .section .text._ZN2nn4kern3svc7Aarch3218CallWaitForAddressEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3218CallWaitForAddressEv
    .type    _ZN2nn4kern3svc7Aarch3218CallWaitForAddressEv, %function
    .type    _ZN2nn4kern3svc19SvcWaitForAddress32EjNS_3svc15ArbitrationTypeEix, %function
_ZN2nn4kern3svc7Aarch3218CallWaitForAddressEv:

    push     {r12,lr}
    sub      sp, sp, #8

    str      r3, [sp, #0]              // ns の値 をレジスタからスタックへ
    str      r4, [sp, #4]              // ns の値 をレジスタからスタックへ

    bl       _ZN2nn4kern3svc19SvcWaitForAddress32EjNS_3svc15ArbitrationTypeEix

    add      sp, sp, #8
    pop      {r12,pc}

    .size _ZN2nn4kern3svc7Aarch3218CallWaitForAddressEv, [.-_ZN2nn4kern3svc7Aarch3218CallWaitForAddressEv]

//-------------------------------------------------
// void KernelDebug(nn::svc::KernelDebugType type, nn::Bit64 param0, nn::Bit64 param1, nn::Bit64 param2)
//
//     Invariant s=4 r=8 p=4       AArch32 s=4 r=4 p=4
// in  svc                         abi
//     Register 0       4 type     Register 0       4 type
//     Register 1       8 param1   
//     Register 2       8 param0   Register 2       8 param0
//     Register 3       8 param0   Register 3       8 param0
//     Register 4       8 param1   
//     Register 5       8 param2   
//     Register 6       8 param2   
//                                 Stack    0       8 param1
//                                 Stack    1       8 param1
//                                 Stack    2       8 param2
//                                 Stack    3       8 param2
//
// in  svc                         abi
//
// conversion
//   Load            param1
//   Load            param1
//   Load            param2
//   Load            param2

    .section .text._ZN2nn4kern3svc7Aarch3215CallKernelDebugEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3215CallKernelDebugEv
    .type    _ZN2nn4kern3svc7Aarch3215CallKernelDebugEv, %function
    .type    _ZN2nn4kern3svc16SvcKernelDebug32ENS_3svc15KernelDebugTypeEyyy, %function
_ZN2nn4kern3svc7Aarch3215CallKernelDebugEv:

    push     {r12,lr}
    sub      sp, sp, #16

    str      r1, [sp, #0]              // param1 の値 をレジスタからスタックへ
    str      r4, [sp, #4]              // param1 の値 をレジスタからスタックへ
    str      r5, [sp, #8]              // param2 の値 をレジスタからスタックへ
    str      r6, [sp, #12]             // param2 の値 をレジスタからスタックへ

    bl       _ZN2nn4kern3svc16SvcKernelDebug32ENS_3svc15KernelDebugTypeEyyy

    add      sp, sp, #16
    pop      {r12,pc}

    .size _ZN2nn4kern3svc7Aarch3215CallKernelDebugEv, [.-_ZN2nn4kern3svc7Aarch3215CallKernelDebugEv]

//-------------------------------------------------
// Result CreateSession(nn::svc::Handle* pServerSession, nn::svc::Handle* pClientSession, bool isLight, uintptr_t name)
//
//     Invariant s=4 r=8 p=4               AArch32 s=4 r=4 p=4
// in  svc                                 abi
//                                         Register 0  ref  4 pServerSession
//                                         Register 1  ref  4 pClientSession
//     Register 2       1 isLight          Register 2       1 isLight
//     Register 3       4 name             Register 3       4 name
//
// in  svc                                 abi
//     Register 0       4 return           Register 0       4 return
//     Register 1       4 pServerSession   
//     Register 2       4 pClientSession   
//
// conversion
//   Scatter         pServerSession
//   Scatter         pClientSession

    .section .text._ZN2nn4kern3svc7Aarch3217CallCreateSessionEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3217CallCreateSessionEv
    .type    _ZN2nn4kern3svc7Aarch3217CallCreateSessionEv, %function
    .type    _ZN2nn4kern3svc18SvcCreateSession32EPNS_3svc6HandleES4_bj, %function
_ZN2nn4kern3svc7Aarch3217CallCreateSessionEv:

    push     {r12,lr}
    sub      sp, sp, #8

    str      r1, [sp, #0]              // pServerSession の第 1 ワードをレジスタからスタックへ
    add      r0, sp, #0                // pServerSession のアドレスをレジスタへ
    str      r2, [sp, #4]              // pClientSession の第 1 ワードをレジスタからスタックへ
    add      r1, sp, #4                // pClientSession のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc18SvcCreateSession32EPNS_3svc6HandleES4_bj

    ldr      r1, [sp, #0]              // pServerSession の第 1 ワードをスタックからレジスタへ
    ldr      r2, [sp, #4]              // pClientSession の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #8
    pop      {r12,pc}

    .size _ZN2nn4kern3svc7Aarch3217CallCreateSessionEv, [.-_ZN2nn4kern3svc7Aarch3217CallCreateSessionEv]

//-------------------------------------------------
// Result AcceptSession(nn::svc::Handle* pOut, nn::svc::Handle port)
//
//     Invariant s=4 r=8 p=4       AArch32 s=4 r=4 p=4
// in  svc                         abi
//                                 Register 0  ref  4 pOut
//     Register 1       4 port     Register 1       4 port
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//     Register 1       4 pOut     
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc7Aarch3217CallAcceptSessionEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3217CallAcceptSessionEv
    .type    _ZN2nn4kern3svc7Aarch3217CallAcceptSessionEv, %function
    .type    _ZN2nn4kern3svc18SvcAcceptSession32EPNS_3svc6HandleES3_, %function
_ZN2nn4kern3svc7Aarch3217CallAcceptSessionEv:

    push     {lr}
    sub      sp, sp, #4

    str      r1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      r0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc18SvcAcceptSession32EPNS_3svc6HandleES3_

    ldr      r1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #4
    pop      {pc}

    .size _ZN2nn4kern3svc7Aarch3217CallAcceptSessionEv, [.-_ZN2nn4kern3svc7Aarch3217CallAcceptSessionEv]

//-------------------------------------------------
// Result ReplyAndReceive(int32_t* pIndex, KUserPointer<const nn::svc::Handle*> pHandles, int32_t numHandle, nn::svc::Handle replyTarget, int64_t ns)
//
//     Invariant s=4 r=8 p=4            AArch32 s=4 r=4 p=4
// in  svc                              abi
//     Register 0       8 ns            Register 0  ref  4 pIndex
//     Register 1  ref -- pHandles      Register 1  ref -- pHandles
//     Register 2       4 numHandle     Register 2       4 numHandle
//     Register 3       4 replyTarget   Register 3       4 replyTarget
//     Register 4       8 ns            
//                                      Stack    0       8 ns
//                                      Stack    1       8 ns
//
// in  svc                              abi
//     Register 0       4 return        Register 0       4 return
//     Register 1       4 pIndex        
//
// conversion
//   Load            ns
//   Load            ns
//   Scatter         pIndex

    .section .text._ZN2nn4kern3svc7Aarch3219CallReplyAndReceiveEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3219CallReplyAndReceiveEv
    .type    _ZN2nn4kern3svc7Aarch3219CallReplyAndReceiveEv, %function
    .type    _ZN2nn4kern3svc20SvcReplyAndReceive32EPiNS1_12KUserPointerIPKNS_3svc6HandleEvEEiS5_x, %function
_ZN2nn4kern3svc7Aarch3219CallReplyAndReceiveEv:

    push     {lr}
    sub      sp, sp, #12

    str      r0, [sp, #0]              // ns の値 をレジスタからスタックへ
    str      r4, [sp, #4]              // ns の値 をレジスタからスタックへ

    str      r1, [sp, #8]              // pIndex の第 1 ワードをレジスタからスタックへ
    add      r0, sp, #8                // pIndex のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc20SvcReplyAndReceive32EPiNS1_12KUserPointerIPKNS_3svc6HandleEvEEiS5_x

    ldr      r1, [sp, #8]              // pIndex の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #12
    pop      {pc}

    .size _ZN2nn4kern3svc7Aarch3219CallReplyAndReceiveEv, [.-_ZN2nn4kern3svc7Aarch3219CallReplyAndReceiveEv]

//-------------------------------------------------
// Result ReplyAndReceiveWithUserBuffer(int32_t* pIndex, uintptr_t pMessage, size_t bufferSize, KUserPointer<const nn::svc::Handle*> pHandles, int32_t numHandle, nn::svc::Handle replyTarget, int64_t ns)
//
//     Invariant s=4 r=8 p=4            AArch32 s=4 r=4 p=4
// in  svc                              abi
//     Register 0       4 numHandle     Register 0  ref  4 pIndex
//     Register 1       4 pMessage      Register 1       4 pMessage
//     Register 2       4 bufferSize    Register 2       4 bufferSize
//     Register 3  ref -- pHandles      Register 3  ref -- pHandles
//     Register 4       4 replyTarget   
//     Register 5       8 ns            
//     Register 6       8 ns            
//                                      Stack    0       4 numHandle
//                                      Stack    1       4 replyTarget
//                                      Stack    2       8 ns
//                                      Stack    3       8 ns
//
// in  svc                              abi
//     Register 0       4 return        Register 0       4 return
//     Register 1       4 pIndex        
//
// conversion
//   Load            numHandle
//   Load            replyTarget
//   Load            ns
//   Load            ns
//   Scatter         pIndex

    .section .text._ZN2nn4kern3svc7Aarch3233CallReplyAndReceiveWithUserBufferEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3233CallReplyAndReceiveWithUserBufferEv
    .type    _ZN2nn4kern3svc7Aarch3233CallReplyAndReceiveWithUserBufferEv, %function
    .type    _ZN2nn4kern3svc34SvcReplyAndReceiveWithUserBuffer32EPijjNS1_12KUserPointerIPKNS_3svc6HandleEvEEiS5_x, %function
_ZN2nn4kern3svc7Aarch3233CallReplyAndReceiveWithUserBufferEv:

    push     {lr}
    sub      sp, sp, #20

    str      r0, [sp, #0]              // numHandle の値 をレジスタからスタックへ
    str      r4, [sp, #4]              // replyTarget の値 をレジスタからスタックへ
    str      r5, [sp, #8]              // ns の値 をレジスタからスタックへ
    str      r6, [sp, #12]             // ns の値 をレジスタからスタックへ

    str      r1, [sp, #16]             // pIndex の第 1 ワードをレジスタからスタックへ
    add      r0, sp, #16               // pIndex のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc34SvcReplyAndReceiveWithUserBuffer32EPijjNS1_12KUserPointerIPKNS_3svc6HandleEvEEiS5_x

    ldr      r1, [sp, #16]             // pIndex の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #20
    pop      {pc}

    .size _ZN2nn4kern3svc7Aarch3233CallReplyAndReceiveWithUserBufferEv, [.-_ZN2nn4kern3svc7Aarch3233CallReplyAndReceiveWithUserBufferEv]

//-------------------------------------------------
// Result CreateEvent(nn::svc::Handle* pWriteHandle, nn::svc::Handle* pReadHandle)
//
//     Invariant s=4 r=8 p=4             AArch32 s=4 r=4 p=4
// in  svc                               abi
//                                       Register 0  ref  4 pWriteHandle
//                                       Register 1  ref  4 pReadHandle
//
// in  svc                               abi
//     Register 0       4 return         Register 0       4 return
//     Register 1       4 pWriteHandle   
//     Register 2       4 pReadHandle    
//
// conversion
//   Scatter         pWriteHandle
//   Scatter         pReadHandle

    .section .text._ZN2nn4kern3svc7Aarch3215CallCreateEventEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3215CallCreateEventEv
    .type    _ZN2nn4kern3svc7Aarch3215CallCreateEventEv, %function
    .type    _ZN2nn4kern3svc16SvcCreateEvent32EPNS_3svc6HandleES4_, %function
_ZN2nn4kern3svc7Aarch3215CallCreateEventEv:

    push     {r12,lr}
    sub      sp, sp, #8

    str      r1, [sp, #0]              // pWriteHandle の第 1 ワードをレジスタからスタックへ
    add      r0, sp, #0                // pWriteHandle のアドレスをレジスタへ
    str      r2, [sp, #4]              // pReadHandle の第 1 ワードをレジスタからスタックへ
    add      r1, sp, #4                // pReadHandle のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc16SvcCreateEvent32EPNS_3svc6HandleES4_

    ldr      r1, [sp, #0]              // pWriteHandle の第 1 ワードをスタックからレジスタへ
    ldr      r2, [sp, #4]              // pReadHandle の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #8
    pop      {r12,pc}

    .size _ZN2nn4kern3svc7Aarch3215CallCreateEventEv, [.-_ZN2nn4kern3svc7Aarch3215CallCreateEventEv]

//-------------------------------------------------
// Result CreateCodeMemory(nn::svc::Handle* pOut, uintptr_t addr, size_t size)
//
//     Invariant s=4 r=8 p=4       AArch32 s=4 r=4 p=4
// in  svc                         abi
//                                 Register 0  ref  4 pOut
//     Register 1       4 addr     Register 1       4 addr
//     Register 2       4 size     Register 2       4 size
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//     Register 1       4 pOut     
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc7Aarch3220CallCreateCodeMemoryEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3220CallCreateCodeMemoryEv
    .type    _ZN2nn4kern3svc7Aarch3220CallCreateCodeMemoryEv, %function
    .type    _ZN2nn4kern3svc21SvcCreateCodeMemory32EPNS_3svc6HandleEjj, %function
_ZN2nn4kern3svc7Aarch3220CallCreateCodeMemoryEv:

    push     {lr}
    sub      sp, sp, #4

    str      r1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      r0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc21SvcCreateCodeMemory32EPNS_3svc6HandleEjj

    ldr      r1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #4
    pop      {pc}

    .size _ZN2nn4kern3svc7Aarch3220CallCreateCodeMemoryEv, [.-_ZN2nn4kern3svc7Aarch3220CallCreateCodeMemoryEv]

//-------------------------------------------------
// Result ControlCodeMemory(nn::svc::Handle handle, nn::svc::CodeMemoryOperation operation, uint64_t address, uint64_t size, nn::svc::MemoryPermission permission)
//
//     Invariant s=4 r=8 p=4           AArch32 s=4 r=4 p=4
// in  svc                             abi
//     Register 0       4 handle       Register 0       4 handle
//     Register 1       4 operation    Register 1       4 operation
//     Register 2       8 address      Register 2       8 address
//     Register 3       8 address      Register 3       8 address
//     Register 4       8 size         
//     Register 5       8 size         
//     Register 6       4 permission   
//                                     Stack    0       8 size
//                                     Stack    1       8 size
//                                     Stack    2       4 permission
//
// in  svc                             abi
//     Register 0       4 return       Register 0       4 return
//
// conversion
//   Load            size
//   Load            size
//   Load            permission

    .section .text._ZN2nn4kern3svc7Aarch3221CallControlCodeMemoryEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3221CallControlCodeMemoryEv
    .type    _ZN2nn4kern3svc7Aarch3221CallControlCodeMemoryEv, %function
    .type    _ZN2nn4kern3svc22SvcControlCodeMemory32ENS_3svc6HandleENS2_19CodeMemoryOperationEyyNS2_16MemoryPermissionE, %function
_ZN2nn4kern3svc7Aarch3221CallControlCodeMemoryEv:

    push     {lr}
    sub      sp, sp, #12

    str      r4, [sp, #0]              // size の値 をレジスタからスタックへ
    str      r5, [sp, #4]              // size の値 をレジスタからスタックへ
    str      r6, [sp, #8]              // permission の値 をレジスタからスタックへ

    bl       _ZN2nn4kern3svc22SvcControlCodeMemory32ENS_3svc6HandleENS2_19CodeMemoryOperationEyyNS2_16MemoryPermissionE

    add      sp, sp, #12
    pop      {pc}

    .size _ZN2nn4kern3svc7Aarch3221CallControlCodeMemoryEv, [.-_ZN2nn4kern3svc7Aarch3221CallControlCodeMemoryEv]

//-------------------------------------------------
// Result ReadWriteRegister(nn::Bit32* pOut, nn::svc::PhysicalAddress address, nn::Bit32 mask, nn::Bit32 value)
//
//     Invariant s=4 r=8 p=4        AArch32 s=4 r=4 p=4
// in  svc                          abi
//     Register 0       4 mask      Register 0  ref  4 pOut
//     Register 1       4 value     
//     Register 2       8 address   Register 2       8 address
//     Register 3       8 address   Register 3       8 address
//                                  Stack    0       4 mask
//                                  Stack    1       4 value
//
// in  svc                          abi
//     Register 0       4 return    Register 0       4 return
//     Register 1       4 pOut      
//
// conversion
//   Load            mask
//   Load            value
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc7Aarch3221CallReadWriteRegisterEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3221CallReadWriteRegisterEv
    .type    _ZN2nn4kern3svc7Aarch3221CallReadWriteRegisterEv, %function
    .type    _ZN2nn4kern3svc22SvcReadWriteRegister32EPjyjj, %function
_ZN2nn4kern3svc7Aarch3221CallReadWriteRegisterEv:

    push     {lr}
    sub      sp, sp, #12

    str      r0, [sp, #0]              // mask の値 をレジスタからスタックへ
    str      r1, [sp, #4]              // value の値 をレジスタからスタックへ

    str      r1, [sp, #8]              // pOut の第 1 ワードをレジスタからスタックへ
    add      r0, sp, #8                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc22SvcReadWriteRegister32EPjyjj

    ldr      r1, [sp, #8]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #12
    pop      {pc}

    .size _ZN2nn4kern3svc7Aarch3221CallReadWriteRegisterEv, [.-_ZN2nn4kern3svc7Aarch3221CallReadWriteRegisterEv]

//-------------------------------------------------
// Result CreateSharedMemory(nn::svc::Handle* pOut, size_t size, nn::svc::MemoryPermission myPermission, nn::svc::MemoryPermission otherPermission)
//
//     Invariant s=4 r=8 p=4                AArch32 s=4 r=4 p=4
// in  svc                                  abi
//                                          Register 0  ref  4 pOut
//     Register 1       4 size              Register 1       4 size
//     Register 2       4 myPermission      Register 2       4 myPermission
//     Register 3       4 otherPermission   Register 3       4 otherPermission
//
// in  svc                                  abi
//     Register 0       4 return            Register 0       4 return
//     Register 1       4 pOut              
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc7Aarch3222CallCreateSharedMemoryEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3222CallCreateSharedMemoryEv
    .type    _ZN2nn4kern3svc7Aarch3222CallCreateSharedMemoryEv, %function
    .type    _ZN2nn4kern3svc23SvcCreateSharedMemory32EPNS_3svc6HandleEjNS2_16MemoryPermissionES5_, %function
_ZN2nn4kern3svc7Aarch3222CallCreateSharedMemoryEv:

    push     {lr}
    sub      sp, sp, #4

    str      r1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      r0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc23SvcCreateSharedMemory32EPNS_3svc6HandleEjNS2_16MemoryPermissionES5_

    ldr      r1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #4
    pop      {pc}

    .size _ZN2nn4kern3svc7Aarch3222CallCreateSharedMemoryEv, [.-_ZN2nn4kern3svc7Aarch3222CallCreateSharedMemoryEv]

//-------------------------------------------------
// Result CreateInterruptEvent(nn::svc::Handle* pReadHandle, int32_t name, nn::svc::InterruptType type)
//
//     Invariant s=4 r=8 p=4            AArch32 s=4 r=4 p=4
// in  svc                              abi
//                                      Register 0  ref  4 pReadHandle
//     Register 1       4 name          Register 1       4 name
//     Register 2       4 type          Register 2       4 type
//
// in  svc                              abi
//     Register 0       4 return        Register 0       4 return
//     Register 1       4 pReadHandle   
//
// conversion
//   Scatter         pReadHandle

    .section .text._ZN2nn4kern3svc7Aarch3224CallCreateInterruptEventEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3224CallCreateInterruptEventEv
    .type    _ZN2nn4kern3svc7Aarch3224CallCreateInterruptEventEv, %function
    .type    _ZN2nn4kern3svc25SvcCreateInterruptEvent32EPNS_3svc6HandleEiNS2_13InterruptTypeE, %function
_ZN2nn4kern3svc7Aarch3224CallCreateInterruptEventEv:

    push     {lr}
    sub      sp, sp, #4

    str      r1, [sp, #0]              // pReadHandle の第 1 ワードをレジスタからスタックへ
    add      r0, sp, #0                // pReadHandle のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc25SvcCreateInterruptEvent32EPNS_3svc6HandleEiNS2_13InterruptTypeE

    ldr      r1, [sp, #0]              // pReadHandle の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #4
    pop      {pc}

    .size _ZN2nn4kern3svc7Aarch3224CallCreateInterruptEventEv, [.-_ZN2nn4kern3svc7Aarch3224CallCreateInterruptEventEv]

//-------------------------------------------------
// Result QueryPhysicalAddress(nn::svc::ilp32::PhysicalMemoryInfo* pBlockInfo, uintptr_t addr)
//
//     Invariant s=4 r=8 p=4           AArch32 s=4 r=4 p=4
// in  svc                             abi
//                                     Register 0  ref 16 pBlockInfo
//     Register 1       4 addr         Register 1       4 addr
//
// in  svc                             abi
//     Register 0       4 return       Register 0       4 return
//     Register 1      16 pBlockInfo   
//     Register 2      16 pBlockInfo   
//     Register 3      16 pBlockInfo   
//     Register 4      16 pBlockInfo   
//
// conversion
//   Scatter         pBlockInfo

    .section .text._ZN2nn4kern3svc7Aarch3224CallQueryPhysicalAddressEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3224CallQueryPhysicalAddressEv
    .type    _ZN2nn4kern3svc7Aarch3224CallQueryPhysicalAddressEv, %function
    .type    _ZN2nn4kern3svc25SvcQueryPhysicalAddress32EPNS_3svc5ilp3218PhysicalMemoryInfoEj, %function
_ZN2nn4kern3svc7Aarch3224CallQueryPhysicalAddressEv:

    push     {r12,lr}
    sub      sp, sp, #16

    str      r1, [sp, #0]              // pBlockInfo の第 1 ワードをレジスタからスタックへ
    str      r2, [sp, #4]              // pBlockInfo の第 2 ワードをレジスタからスタックへ
    str      r3, [sp, #8]              // pBlockInfo の第 3 ワードをレジスタからスタックへ
    str      r4, [sp, #12]             // pBlockInfo の第 4 ワードをレジスタからスタックへ
    add      r0, sp, #0                // pBlockInfo のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc25SvcQueryPhysicalAddress32EPNS_3svc5ilp3218PhysicalMemoryInfoEj

    ldr      r1, [sp, #0]              // pBlockInfo の第 1 ワードをスタックからレジスタへ
    ldr      r2, [sp, #4]              // pBlockInfo の第 2 ワードをスタックからレジスタへ
    ldr      r3, [sp, #8]              // pBlockInfo の第 3 ワードをスタックからレジスタへ
    ldr      r4, [sp, #12]             // pBlockInfo の第 4 ワードをスタックからレジスタへ

    add      sp, sp, #16
    pop      {r12,pc}

    .size _ZN2nn4kern3svc7Aarch3224CallQueryPhysicalAddressEv, [.-_ZN2nn4kern3svc7Aarch3224CallQueryPhysicalAddressEv]

//-------------------------------------------------
// Result QueryIoMapping(uintptr_t* pOut, nn::svc::PhysicalAddress physicalAddress, size_t size)
//
//     Invariant s=4 r=8 p=4                AArch32 s=4 r=4 p=4
// in  svc                                  abi
//     Register 0       4 size              Register 0  ref  4 pOut
//     Register 2       8 physicalAddress   Register 2       8 physicalAddress
//     Register 3       8 physicalAddress   Register 3       8 physicalAddress
//                                          Stack    0       4 size
//
// in  svc                                  abi
//     Register 0       4 return            Register 0       4 return
//     Register 1       4 pOut              
//
// conversion
//   Load            size
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc7Aarch3218CallQueryIoMappingEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3218CallQueryIoMappingEv
    .type    _ZN2nn4kern3svc7Aarch3218CallQueryIoMappingEv, %function
    .type    _ZN2nn4kern3svc19SvcQueryIoMapping32EPjyj, %function
_ZN2nn4kern3svc7Aarch3218CallQueryIoMappingEv:

    push     {r12,lr}
    sub      sp, sp, #8

    str      r0, [sp, #0]              // size の値 をレジスタからスタックへ

    str      r1, [sp, #4]              // pOut の第 1 ワードをレジスタからスタックへ
    add      r0, sp, #4                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc19SvcQueryIoMapping32EPjyj

    ldr      r1, [sp, #4]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #8
    pop      {r12,pc}

    .size _ZN2nn4kern3svc7Aarch3218CallQueryIoMappingEv, [.-_ZN2nn4kern3svc7Aarch3218CallQueryIoMappingEv]

//-------------------------------------------------
// Result CreateDeviceAddressSpace(nn::svc::Handle* pOut, uint64_t spaceAddress, uint64_t spaceSize)
//
//     Invariant s=4 r=8 p=4             AArch32 s=4 r=4 p=4
// in  svc                               abi
//     Register 0       8 spaceSize      Register 0  ref  4 pOut
//     Register 1       8 spaceSize      
//     Register 2       8 spaceAddress   Register 2       8 spaceAddress
//     Register 3       8 spaceAddress   Register 3       8 spaceAddress
//                                       Stack    0       8 spaceSize
//                                       Stack    1       8 spaceSize
//
// in  svc                               abi
//     Register 0       4 return         Register 0       4 return
//     Register 1       4 pOut           
//
// conversion
//   Load            spaceSize
//   Load            spaceSize
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc7Aarch3228CallCreateDeviceAddressSpaceEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3228CallCreateDeviceAddressSpaceEv
    .type    _ZN2nn4kern3svc7Aarch3228CallCreateDeviceAddressSpaceEv, %function
    .type    _ZN2nn4kern3svc29SvcCreateDeviceAddressSpace32EPNS_3svc6HandleEyy, %function
_ZN2nn4kern3svc7Aarch3228CallCreateDeviceAddressSpaceEv:

    push     {lr}
    sub      sp, sp, #12

    str      r0, [sp, #0]              // spaceSize の値 をレジスタからスタックへ
    str      r1, [sp, #4]              // spaceSize の値 をレジスタからスタックへ

    str      r1, [sp, #8]              // pOut の第 1 ワードをレジスタからスタックへ
    add      r0, sp, #8                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc29SvcCreateDeviceAddressSpace32EPNS_3svc6HandleEyy

    ldr      r1, [sp, #8]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #12
    pop      {pc}

    .size _ZN2nn4kern3svc7Aarch3228CallCreateDeviceAddressSpaceEv, [.-_ZN2nn4kern3svc7Aarch3228CallCreateDeviceAddressSpaceEv]

//-------------------------------------------------
// Result MapDeviceAddressSpaceByForce(nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress, nn::svc::MemoryPermission devicePermission)
//
//     Invariant s=4 r=8 p=4                 AArch32 s=4 r=4 p=4
// in  svc                                   abi
//     Register 0       4 addressSpace       Register 0       4 addressSpace
//     Register 1       4 process            Register 1       4 process
//     Register 2       8 processAddress     Register 2       8 processAddress
//     Register 3       8 processAddress     Register 3       8 processAddress
//     Register 4       4 size               
//     Register 5       8 deviceAddress      
//     Register 6       8 deviceAddress      
//     Register 7       4 devicePermission   
//                                           Stack    0       4 size
//                                           Stack    2       8 deviceAddress
//                                           Stack    3       8 deviceAddress
//                                           Stack    4       4 devicePermission
//
// in  svc                                   abi
//     Register 0       4 return             Register 0       4 return
//
// conversion
//   Load            size
//   Load            deviceAddress
//   Load            deviceAddress
//   Load            devicePermission

    .section .text._ZN2nn4kern3svc7Aarch3232CallMapDeviceAddressSpaceByForceEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3232CallMapDeviceAddressSpaceByForceEv
    .type    _ZN2nn4kern3svc7Aarch3232CallMapDeviceAddressSpaceByForceEv, %function
    .type    _ZN2nn4kern3svc33SvcMapDeviceAddressSpaceByForce32ENS_3svc6HandleES3_yjyNS2_16MemoryPermissionE, %function
_ZN2nn4kern3svc7Aarch3232CallMapDeviceAddressSpaceByForceEv:

    push     {lr}
    sub      sp, sp, #20

    str      r4, [sp, #0]              // size の値 をレジスタからスタックへ
    str      r5, [sp, #8]              // deviceAddress の値 をレジスタからスタックへ
    str      r6, [sp, #12]             // deviceAddress の値 をレジスタからスタックへ
    str      r7, [sp, #16]             // devicePermission の値 をレジスタからスタックへ

    bl       _ZN2nn4kern3svc33SvcMapDeviceAddressSpaceByForce32ENS_3svc6HandleES3_yjyNS2_16MemoryPermissionE

    add      sp, sp, #20
    pop      {pc}

    .size _ZN2nn4kern3svc7Aarch3232CallMapDeviceAddressSpaceByForceEv, [.-_ZN2nn4kern3svc7Aarch3232CallMapDeviceAddressSpaceByForceEv]

//-------------------------------------------------
// Result MapDeviceAddressSpaceAligned(nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress, nn::svc::MemoryPermission devicePermission)
//
//     Invariant s=4 r=8 p=4                 AArch32 s=4 r=4 p=4
// in  svc                                   abi
//     Register 0       4 addressSpace       Register 0       4 addressSpace
//     Register 1       4 process            Register 1       4 process
//     Register 2       8 processAddress     Register 2       8 processAddress
//     Register 3       8 processAddress     Register 3       8 processAddress
//     Register 4       4 size               
//     Register 5       8 deviceAddress      
//     Register 6       8 deviceAddress      
//     Register 7       4 devicePermission   
//                                           Stack    0       4 size
//                                           Stack    2       8 deviceAddress
//                                           Stack    3       8 deviceAddress
//                                           Stack    4       4 devicePermission
//
// in  svc                                   abi
//     Register 0       4 return             Register 0       4 return
//
// conversion
//   Load            size
//   Load            deviceAddress
//   Load            deviceAddress
//   Load            devicePermission

    .section .text._ZN2nn4kern3svc7Aarch3232CallMapDeviceAddressSpaceAlignedEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3232CallMapDeviceAddressSpaceAlignedEv
    .type    _ZN2nn4kern3svc7Aarch3232CallMapDeviceAddressSpaceAlignedEv, %function
    .type    _ZN2nn4kern3svc33SvcMapDeviceAddressSpaceAligned32ENS_3svc6HandleES3_yjyNS2_16MemoryPermissionE, %function
_ZN2nn4kern3svc7Aarch3232CallMapDeviceAddressSpaceAlignedEv:

    push     {lr}
    sub      sp, sp, #20

    str      r4, [sp, #0]              // size の値 をレジスタからスタックへ
    str      r5, [sp, #8]              // deviceAddress の値 をレジスタからスタックへ
    str      r6, [sp, #12]             // deviceAddress の値 をレジスタからスタックへ
    str      r7, [sp, #16]             // devicePermission の値 をレジスタからスタックへ

    bl       _ZN2nn4kern3svc33SvcMapDeviceAddressSpaceAligned32ENS_3svc6HandleES3_yjyNS2_16MemoryPermissionE

    add      sp, sp, #20
    pop      {pc}

    .size _ZN2nn4kern3svc7Aarch3232CallMapDeviceAddressSpaceAlignedEv, [.-_ZN2nn4kern3svc7Aarch3232CallMapDeviceAddressSpaceAlignedEv]

//-------------------------------------------------
// Result MapDeviceAddressSpace(size_t* pMappedSize, nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress, nn::svc::MemoryPermission devicePermission)
//
//     Invariant s=4 r=8 p=4                 AArch32 s=4 r=4 p=4
// in  svc                                   abi
//     Register 0       8 processAddress     Register 0  ref  4 pMappedSize
//     Register 1       4 addressSpace       Register 1       4 addressSpace
//     Register 2       4 process            Register 2       4 process
//     Register 3       8 processAddress     
//     Register 4       4 size               
//     Register 5       8 deviceAddress      
//     Register 6       8 deviceAddress      
//     Register 7       4 devicePermission   
//                                           Stack    0       8 processAddress
//                                           Stack    1       8 processAddress
//                                           Stack    2       4 size
//                                           Stack    4       8 deviceAddress
//                                           Stack    5       8 deviceAddress
//                                           Stack    6       4 devicePermission
//
// in  svc                                   abi
//     Register 0       4 return             Register 0       4 return
//     Register 1       4 pMappedSize        
//
// conversion
//   Load            processAddress
//   Load            processAddress
//   Load            size
//   Load            deviceAddress
//   Load            deviceAddress
//   Load            devicePermission
//   Scatter         pMappedSize

    .section .text._ZN2nn4kern3svc7Aarch3225CallMapDeviceAddressSpaceEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3225CallMapDeviceAddressSpaceEv
    .type    _ZN2nn4kern3svc7Aarch3225CallMapDeviceAddressSpaceEv, %function
    .type    _ZN2nn4kern3svc26SvcMapDeviceAddressSpace32EPjNS_3svc6HandleES4_yjyNS3_16MemoryPermissionE, %function
_ZN2nn4kern3svc7Aarch3225CallMapDeviceAddressSpaceEv:

    push     {r12,lr}
    sub      sp, sp, #32

    str      r0, [sp, #0]              // processAddress の値 をレジスタからスタックへ
    str      r3, [sp, #4]              // processAddress の値 をレジスタからスタックへ
    str      r4, [sp, #8]              // size の値 をレジスタからスタックへ
    str      r5, [sp, #16]             // deviceAddress の値 をレジスタからスタックへ
    str      r6, [sp, #20]             // deviceAddress の値 をレジスタからスタックへ
    str      r7, [sp, #24]             // devicePermission の値 をレジスタからスタックへ

    str      r1, [sp, #28]             // pMappedSize の第 1 ワードをレジスタからスタックへ
    add      r0, sp, #28               // pMappedSize のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc26SvcMapDeviceAddressSpace32EPjNS_3svc6HandleES4_yjyNS3_16MemoryPermissionE

    ldr      r1, [sp, #28]             // pMappedSize の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #32
    pop      {r12,pc}

    .size _ZN2nn4kern3svc7Aarch3225CallMapDeviceAddressSpaceEv, [.-_ZN2nn4kern3svc7Aarch3225CallMapDeviceAddressSpaceEv]

//-------------------------------------------------
// Result UnmapDeviceAddressSpace(nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress)
//
//     Invariant s=4 r=8 p=4               AArch32 s=4 r=4 p=4
// in  svc                                 abi
//     Register 0       4 addressSpace     Register 0       4 addressSpace
//     Register 1       4 process          Register 1       4 process
//     Register 2       8 processAddress   Register 2       8 processAddress
//     Register 3       8 processAddress   Register 3       8 processAddress
//     Register 4       4 size             
//     Register 5       8 deviceAddress    
//     Register 6       8 deviceAddress    
//                                         Stack    0       4 size
//                                         Stack    2       8 deviceAddress
//                                         Stack    3       8 deviceAddress
//
// in  svc                                 abi
//     Register 0       4 return           Register 0       4 return
//
// conversion
//   Load            size
//   Load            deviceAddress
//   Load            deviceAddress

    .section .text._ZN2nn4kern3svc7Aarch3227CallUnmapDeviceAddressSpaceEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3227CallUnmapDeviceAddressSpaceEv
    .type    _ZN2nn4kern3svc7Aarch3227CallUnmapDeviceAddressSpaceEv, %function
    .type    _ZN2nn4kern3svc28SvcUnmapDeviceAddressSpace32ENS_3svc6HandleES3_yjy, %function
_ZN2nn4kern3svc7Aarch3227CallUnmapDeviceAddressSpaceEv:

    push     {r12,lr}
    sub      sp, sp, #16

    str      r4, [sp, #0]              // size の値 をレジスタからスタックへ
    str      r5, [sp, #8]              // deviceAddress の値 をレジスタからスタックへ
    str      r6, [sp, #12]             // deviceAddress の値 をレジスタからスタックへ

    bl       _ZN2nn4kern3svc28SvcUnmapDeviceAddressSpace32ENS_3svc6HandleES3_yjy

    add      sp, sp, #16
    pop      {r12,pc}

    .size _ZN2nn4kern3svc7Aarch3227CallUnmapDeviceAddressSpaceEv, [.-_ZN2nn4kern3svc7Aarch3227CallUnmapDeviceAddressSpaceEv]

//-------------------------------------------------
// Result InvalidateProcessDataCache(nn::svc::Handle process, uint64_t addr, uint64_t size)
//
//     Invariant s=4 r=8 p=4        AArch32 s=4 r=4 p=4
// in  svc                          abi
//     Register 0       4 process   Register 0       4 process
//     Register 1       8 size      
//     Register 2       8 addr      Register 2       8 addr
//     Register 3       8 addr      Register 3       8 addr
//     Register 4       8 size      
//                                  Stack    0       8 size
//                                  Stack    1       8 size
//
// in  svc                          abi
//     Register 0       4 return    Register 0       4 return
//
// conversion
//   Load            size
//   Load            size

    .section .text._ZN2nn4kern3svc7Aarch3230CallInvalidateProcessDataCacheEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3230CallInvalidateProcessDataCacheEv
    .type    _ZN2nn4kern3svc7Aarch3230CallInvalidateProcessDataCacheEv, %function
    .type    _ZN2nn4kern3svc31SvcInvalidateProcessDataCache32ENS_3svc6HandleEyy, %function
_ZN2nn4kern3svc7Aarch3230CallInvalidateProcessDataCacheEv:

    push     {r12,lr}
    sub      sp, sp, #8

    str      r1, [sp, #0]              // size の値 をレジスタからスタックへ
    str      r4, [sp, #4]              // size の値 をレジスタからスタックへ

    bl       _ZN2nn4kern3svc31SvcInvalidateProcessDataCache32ENS_3svc6HandleEyy

    add      sp, sp, #8
    pop      {r12,pc}

    .size _ZN2nn4kern3svc7Aarch3230CallInvalidateProcessDataCacheEv, [.-_ZN2nn4kern3svc7Aarch3230CallInvalidateProcessDataCacheEv]

//-------------------------------------------------
// Result StoreProcessDataCache(nn::svc::Handle process, uint64_t addr, uint64_t size)
//
//     Invariant s=4 r=8 p=4        AArch32 s=4 r=4 p=4
// in  svc                          abi
//     Register 0       4 process   Register 0       4 process
//     Register 1       8 size      
//     Register 2       8 addr      Register 2       8 addr
//     Register 3       8 addr      Register 3       8 addr
//     Register 4       8 size      
//                                  Stack    0       8 size
//                                  Stack    1       8 size
//
// in  svc                          abi
//     Register 0       4 return    Register 0       4 return
//
// conversion
//   Load            size
//   Load            size

    .section .text._ZN2nn4kern3svc7Aarch3225CallStoreProcessDataCacheEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3225CallStoreProcessDataCacheEv
    .type    _ZN2nn4kern3svc7Aarch3225CallStoreProcessDataCacheEv, %function
    .type    _ZN2nn4kern3svc26SvcStoreProcessDataCache32ENS_3svc6HandleEyy, %function
_ZN2nn4kern3svc7Aarch3225CallStoreProcessDataCacheEv:

    push     {r12,lr}
    sub      sp, sp, #8

    str      r1, [sp, #0]              // size の値 をレジスタからスタックへ
    str      r4, [sp, #4]              // size の値 をレジスタからスタックへ

    bl       _ZN2nn4kern3svc26SvcStoreProcessDataCache32ENS_3svc6HandleEyy

    add      sp, sp, #8
    pop      {r12,pc}

    .size _ZN2nn4kern3svc7Aarch3225CallStoreProcessDataCacheEv, [.-_ZN2nn4kern3svc7Aarch3225CallStoreProcessDataCacheEv]

//-------------------------------------------------
// Result FlushProcessDataCache(nn::svc::Handle process, uint64_t addr, uint64_t size)
//
//     Invariant s=4 r=8 p=4        AArch32 s=4 r=4 p=4
// in  svc                          abi
//     Register 0       4 process   Register 0       4 process
//     Register 1       8 size      
//     Register 2       8 addr      Register 2       8 addr
//     Register 3       8 addr      Register 3       8 addr
//     Register 4       8 size      
//                                  Stack    0       8 size
//                                  Stack    1       8 size
//
// in  svc                          abi
//     Register 0       4 return    Register 0       4 return
//
// conversion
//   Load            size
//   Load            size

    .section .text._ZN2nn4kern3svc7Aarch3225CallFlushProcessDataCacheEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3225CallFlushProcessDataCacheEv
    .type    _ZN2nn4kern3svc7Aarch3225CallFlushProcessDataCacheEv, %function
    .type    _ZN2nn4kern3svc26SvcFlushProcessDataCache32ENS_3svc6HandleEyy, %function
_ZN2nn4kern3svc7Aarch3225CallFlushProcessDataCacheEv:

    push     {r12,lr}
    sub      sp, sp, #8

    str      r1, [sp, #0]              // size の値 をレジスタからスタックへ
    str      r4, [sp, #4]              // size の値 をレジスタからスタックへ

    bl       _ZN2nn4kern3svc26SvcFlushProcessDataCache32ENS_3svc6HandleEyy

    add      sp, sp, #8
    pop      {r12,pc}

    .size _ZN2nn4kern3svc7Aarch3225CallFlushProcessDataCacheEv, [.-_ZN2nn4kern3svc7Aarch3225CallFlushProcessDataCacheEv]

//-------------------------------------------------
// Result DebugActiveProcess(nn::svc::Handle* pOut, nn::Bit64 processId)
//
//     Invariant s=4 r=8 p=4          AArch32 s=4 r=4 p=4
// in  svc                            abi
//                                    Register 0  ref  4 pOut
//     Register 2       8 processId   Register 2       8 processId
//     Register 3       8 processId   Register 3       8 processId
//
// in  svc                            abi
//     Register 0       4 return      Register 0       4 return
//     Register 1       4 pOut        
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc7Aarch3222CallDebugActiveProcessEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3222CallDebugActiveProcessEv
    .type    _ZN2nn4kern3svc7Aarch3222CallDebugActiveProcessEv, %function
    .type    _ZN2nn4kern3svc23SvcDebugActiveProcess32EPNS_3svc6HandleEy, %function
_ZN2nn4kern3svc7Aarch3222CallDebugActiveProcessEv:

    push     {lr}
    sub      sp, sp, #4

    str      r1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      r0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc23SvcDebugActiveProcess32EPNS_3svc6HandleEy

    ldr      r1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #4
    pop      {pc}

    .size _ZN2nn4kern3svc7Aarch3222CallDebugActiveProcessEv, [.-_ZN2nn4kern3svc7Aarch3222CallDebugActiveProcessEv]

//-------------------------------------------------
// Result GetProcessList(int32_t* pNumProcesses, KUserPointer<nn::Bit64*> pProcessIds, int32_t arraySize)
//
//     Invariant s=4 r=8 p=4              AArch32 s=4 r=4 p=4
// in  svc                                abi
//                                        Register 0  ref  4 pNumProcesses
//     Register 1  ref -- pProcessIds     Register 1  ref -- pProcessIds
//     Register 2       4 arraySize       Register 2       4 arraySize
//
// in  svc                                abi
//     Register 0       4 return          Register 0       4 return
//     Register 1       4 pNumProcesses   
//
// conversion
//   Scatter         pNumProcesses

    .section .text._ZN2nn4kern3svc7Aarch3218CallGetProcessListEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3218CallGetProcessListEv
    .type    _ZN2nn4kern3svc7Aarch3218CallGetProcessListEv, %function
    .type    _ZN2nn4kern3svc19SvcGetProcessList32EPiNS1_12KUserPointerIPyvEEi, %function
_ZN2nn4kern3svc7Aarch3218CallGetProcessListEv:

    push     {lr}
    sub      sp, sp, #4

    str      r1, [sp, #0]              // pNumProcesses の第 1 ワードをレジスタからスタックへ
    add      r0, sp, #0                // pNumProcesses のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc19SvcGetProcessList32EPiNS1_12KUserPointerIPyvEEi

    ldr      r1, [sp, #0]              // pNumProcesses の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #4
    pop      {pc}

    .size _ZN2nn4kern3svc7Aarch3218CallGetProcessListEv, [.-_ZN2nn4kern3svc7Aarch3218CallGetProcessListEv]

//-------------------------------------------------
// Result GetThreadList(int32_t* pNumThreads, KUserPointer<nn::Bit64*> pThreadIds, int32_t arraySize, nn::svc::Handle domain)
//
//     Invariant s=4 r=8 p=4            AArch32 s=4 r=4 p=4
// in  svc                              abi
//                                      Register 0  ref  4 pNumThreads
//     Register 1  ref -- pThreadIds    Register 1  ref -- pThreadIds
//     Register 2       4 arraySize     Register 2       4 arraySize
//     Register 3       4 domain        Register 3       4 domain
//
// in  svc                              abi
//     Register 0       4 return        Register 0       4 return
//     Register 1       4 pNumThreads   
//
// conversion
//   Scatter         pNumThreads

    .section .text._ZN2nn4kern3svc7Aarch3217CallGetThreadListEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3217CallGetThreadListEv
    .type    _ZN2nn4kern3svc7Aarch3217CallGetThreadListEv, %function
    .type    _ZN2nn4kern3svc18SvcGetThreadList32EPiNS1_12KUserPointerIPyvEEiNS_3svc6HandleE, %function
_ZN2nn4kern3svc7Aarch3217CallGetThreadListEv:

    push     {lr}
    sub      sp, sp, #4

    str      r1, [sp, #0]              // pNumThreads の第 1 ワードをレジスタからスタックへ
    add      r0, sp, #0                // pNumThreads のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc18SvcGetThreadList32EPiNS1_12KUserPointerIPyvEEiNS_3svc6HandleE

    ldr      r1, [sp, #0]              // pNumThreads の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #4
    pop      {pc}

    .size _ZN2nn4kern3svc7Aarch3217CallGetThreadListEv, [.-_ZN2nn4kern3svc7Aarch3217CallGetThreadListEv]

//-------------------------------------------------
// Result GetDebugThreadContext(KUserPointer<nn::svc::ThreadContext*> pContext, nn::svc::Handle debug, nn::Bit64 threadId, nn::Bit32 controlFlags)
//
//     Invariant s=4 r=8 p=4             AArch32 s=4 r=4 p=4
// in  svc                               abi
//     Register 0  ref 332 pContext      Register 0  ref 332 pContext
//     Register 1       4 debug          Register 1       4 debug
//     Register 2       8 threadId       Register 2       8 threadId
//     Register 3       8 threadId       Register 3       8 threadId
//     Register 4       4 controlFlags   
//                                       Stack    0       4 controlFlags
//
// in  svc                               abi
//     Register 0       4 return         Register 0       4 return
//
// conversion
//   Load            controlFlags

    .section .text._ZN2nn4kern3svc7Aarch3225CallGetDebugThreadContextEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3225CallGetDebugThreadContextEv
    .type    _ZN2nn4kern3svc7Aarch3225CallGetDebugThreadContextEv, %function
    .type    _ZN2nn4kern3svc26SvcGetDebugThreadContext32ENS1_12KUserPointerIPNS_3svc13ThreadContextEvEENS3_6HandleEyj, %function
_ZN2nn4kern3svc7Aarch3225CallGetDebugThreadContextEv:

    push     {lr}
    sub      sp, sp, #4

    str      r4, [sp, #0]              // controlFlags の値 をレジスタからスタックへ

    bl       _ZN2nn4kern3svc26SvcGetDebugThreadContext32ENS1_12KUserPointerIPNS_3svc13ThreadContextEvEENS3_6HandleEyj

    add      sp, sp, #4
    pop      {pc}

    .size _ZN2nn4kern3svc7Aarch3225CallGetDebugThreadContextEv, [.-_ZN2nn4kern3svc7Aarch3225CallGetDebugThreadContextEv]

//-------------------------------------------------
// Result SetDebugThreadContext(nn::svc::Handle debug, nn::Bit64 threadId, KUserPointer<const nn::svc::ThreadContext*> context, nn::Bit32 controlFlags)
//
//     Invariant s=4 r=8 p=4             AArch32 s=4 r=4 p=4
// in  svc                               abi
//     Register 0       4 debug          Register 0       4 debug
//     Register 1  ref 332 context       
//     Register 2       8 threadId       Register 2       8 threadId
//     Register 3       8 threadId       Register 3       8 threadId
//     Register 4       4 controlFlags   
//                                       Stack    0  ref 332 context
//                                       Stack    1       4 controlFlags
//
// in  svc                               abi
//     Register 0       4 return         Register 0       4 return
//
// conversion
//   Load            context
//   Load            controlFlags

    .section .text._ZN2nn4kern3svc7Aarch3225CallSetDebugThreadContextEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3225CallSetDebugThreadContextEv
    .type    _ZN2nn4kern3svc7Aarch3225CallSetDebugThreadContextEv, %function
    .type    _ZN2nn4kern3svc26SvcSetDebugThreadContext32ENS_3svc6HandleEyNS1_12KUserPointerIPKNS2_13ThreadContextEvEEj, %function
_ZN2nn4kern3svc7Aarch3225CallSetDebugThreadContextEv:

    push     {r12,lr}
    sub      sp, sp, #8

    str      r1, [sp, #0]              // context の値 をレジスタからスタックへ
    str      r4, [sp, #4]              // controlFlags の値 をレジスタからスタックへ

    bl       _ZN2nn4kern3svc26SvcSetDebugThreadContext32ENS_3svc6HandleEyNS1_12KUserPointerIPKNS2_13ThreadContextEvEEj

    add      sp, sp, #8
    pop      {r12,pc}

    .size _ZN2nn4kern3svc7Aarch3225CallSetDebugThreadContextEv, [.-_ZN2nn4kern3svc7Aarch3225CallSetDebugThreadContextEv]

//-------------------------------------------------
// Result QueryDebugProcessMemory(KUserPointer<nn::svc::ilp32::MemoryInfo*> pBlockInfo, nn::svc::PageInfo* pPageInfo, nn::svc::Handle process, uintptr_t addr)
//
//     Invariant s=4 r=8 p=4           AArch32 s=4 r=4 p=4
// in  svc                             abi
//     Register 0  ref 40 pBlockInfo   Register 0  ref 40 pBlockInfo
//                                     Register 1  ref  4 pPageInfo
//     Register 2       4 process      Register 2       4 process
//     Register 3       4 addr         Register 3       4 addr
//
// in  svc                             abi
//     Register 0       4 return       Register 0       4 return
//     Register 1       4 pPageInfo    
//
// conversion
//   Scatter         pPageInfo

    .section .text._ZN2nn4kern3svc7Aarch3227CallQueryDebugProcessMemoryEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3227CallQueryDebugProcessMemoryEv
    .type    _ZN2nn4kern3svc7Aarch3227CallQueryDebugProcessMemoryEv, %function
    .type    _ZN2nn4kern3svc28SvcQueryDebugProcessMemory32ENS1_12KUserPointerIPNS_3svc5ilp3210MemoryInfoEvEEPNS3_8PageInfoENS3_6HandleEj, %function
_ZN2nn4kern3svc7Aarch3227CallQueryDebugProcessMemoryEv:

    push     {lr}
    sub      sp, sp, #4

    str      r1, [sp, #0]              // pPageInfo の第 1 ワードをレジスタからスタックへ
    add      r1, sp, #0                // pPageInfo のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc28SvcQueryDebugProcessMemory32ENS1_12KUserPointerIPNS_3svc5ilp3210MemoryInfoEvEEPNS3_8PageInfoENS3_6HandleEj

    ldr      r1, [sp, #0]              // pPageInfo の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #4
    pop      {pc}

    .size _ZN2nn4kern3svc7Aarch3227CallQueryDebugProcessMemoryEv, [.-_ZN2nn4kern3svc7Aarch3227CallQueryDebugProcessMemoryEv]

//-------------------------------------------------
// Result SetHardwareBreakPoint(nn::svc::HardwareBreakPointRegisterName regNo, nn::Bit64 control, nn::Bit64 value)
//
//     Invariant s=4 r=8 p=4        AArch32 s=4 r=4 p=4
// in  svc                          abi
//     Register 0       4 regNo     Register 0       4 regNo
//     Register 1       8 value     
//     Register 2       8 control   Register 2       8 control
//     Register 3       8 control   Register 3       8 control
//     Register 4       8 value     
//                                  Stack    0       8 value
//                                  Stack    1       8 value
//
// in  svc                          abi
//     Register 0       4 return    Register 0       4 return
//
// conversion
//   Load            value
//   Load            value

    .section .text._ZN2nn4kern3svc7Aarch3225CallSetHardwareBreakPointEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3225CallSetHardwareBreakPointEv
    .type    _ZN2nn4kern3svc7Aarch3225CallSetHardwareBreakPointEv, %function
    .type    _ZN2nn4kern3svc26SvcSetHardwareBreakPoint32ENS_3svc30HardwareBreakPointRegisterNameEyy, %function
_ZN2nn4kern3svc7Aarch3225CallSetHardwareBreakPointEv:

    push     {r12,lr}
    sub      sp, sp, #8

    str      r1, [sp, #0]              // value の値 をレジスタからスタックへ
    str      r4, [sp, #4]              // value の値 をレジスタからスタックへ

    bl       _ZN2nn4kern3svc26SvcSetHardwareBreakPoint32ENS_3svc30HardwareBreakPointRegisterNameEyy

    add      sp, sp, #8
    pop      {r12,pc}

    .size _ZN2nn4kern3svc7Aarch3225CallSetHardwareBreakPointEv, [.-_ZN2nn4kern3svc7Aarch3225CallSetHardwareBreakPointEv]

//-------------------------------------------------
// Result GetDebugThreadParam(nn::Bit64* pOut1, nn::Bit32* pOut2, nn::svc::Handle debug, nn::Bit64 threadId, nn::svc::DebugThreadParam select)
//
//     Invariant s=4 r=8 p=4         AArch32 s=4 r=4 p=4
// in  svc                           abi
//     Register 0       8 threadId   Register 0  ref  8 pOut1
//     Register 1       8 threadId   Register 1  ref  4 pOut2
//     Register 2       4 debug      Register 2       4 debug
//     Register 3       4 select     
//                                   Stack    0       8 threadId
//                                   Stack    1       8 threadId
//                                   Stack    2       4 select
//
// in  svc                           abi
//     Register 0       4 return     Register 0       4 return
//     Register 1       8 pOut1      
//     Register 2       8 pOut1      
//     Register 3       4 pOut2      
//
// conversion
//   Load            threadId
//   Load            threadId
//   Load            select
//   Scatter         pOut1
//   Scatter         pOut2

    .section .text._ZN2nn4kern3svc7Aarch3223CallGetDebugThreadParamEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3223CallGetDebugThreadParamEv
    .type    _ZN2nn4kern3svc7Aarch3223CallGetDebugThreadParamEv, %function
    .type    _ZN2nn4kern3svc24SvcGetDebugThreadParam32EPyPjNS_3svc6HandleEyNS4_16DebugThreadParamE, %function
_ZN2nn4kern3svc7Aarch3223CallGetDebugThreadParamEv:

    push     {r12,lr}
    sub      sp, sp, #24

    str      r0, [sp, #0]              // threadId の値 をレジスタからスタックへ
    str      r1, [sp, #4]              // threadId の値 をレジスタからスタックへ
    str      r3, [sp, #8]              // select の値 をレジスタからスタックへ

    str      r1, [sp, #12]             // pOut1 の第 1 ワードをレジスタからスタックへ
    str      r2, [sp, #16]             // pOut1 の第 2 ワードをレジスタからスタックへ
    add      r0, sp, #12               // pOut1 のアドレスをレジスタへ
    str      r3, [sp, #20]             // pOut2 の第 1 ワードをレジスタからスタックへ
    add      r1, sp, #20               // pOut2 のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc24SvcGetDebugThreadParam32EPyPjNS_3svc6HandleEyNS4_16DebugThreadParamE

    ldr      r1, [sp, #12]             // pOut1 の第 1 ワードをスタックからレジスタへ
    ldr      r2, [sp, #16]             // pOut1 の第 2 ワードをスタックからレジスタへ
    ldr      r3, [sp, #20]             // pOut2 の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #24
    pop      {r12,pc}

    .size _ZN2nn4kern3svc7Aarch3223CallGetDebugThreadParamEv, [.-_ZN2nn4kern3svc7Aarch3223CallGetDebugThreadParamEv]

//-------------------------------------------------
// Result GetSystemInfo(nn::Bit64* pOut, nn::svc::SystemInfoType type, nn::svc::Handle handle, nn::Bit64 param)
//
//     Invariant s=4 r=8 p=4       AArch32 s=4 r=4 p=4
// in  svc                         abi
//     Register 0       8 param    Register 0  ref  8 pOut
//     Register 1       4 type     Register 1       4 type
//     Register 2       4 handle   Register 2       4 handle
//     Register 3       8 param    
//                                 Stack    0       8 param
//                                 Stack    1       8 param
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//     Register 1       8 pOut     
//     Register 2       8 pOut     
//
// conversion
//   Load            param
//   Load            param
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc7Aarch3217CallGetSystemInfoEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3217CallGetSystemInfoEv
    .type    _ZN2nn4kern3svc7Aarch3217CallGetSystemInfoEv, %function
    .type    _ZN2nn4kern3svc18SvcGetSystemInfo32EPyNS_3svc14SystemInfoTypeENS3_6HandleEy, %function
_ZN2nn4kern3svc7Aarch3217CallGetSystemInfoEv:

    push     {r12,lr}
    sub      sp, sp, #16

    str      r0, [sp, #0]              // param の値 をレジスタからスタックへ
    str      r3, [sp, #4]              // param の値 をレジスタからスタックへ

    str      r1, [sp, #8]              // pOut の第 1 ワードをレジスタからスタックへ
    str      r2, [sp, #12]             // pOut の第 2 ワードをレジスタからスタックへ
    add      r0, sp, #8                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc18SvcGetSystemInfo32EPyNS_3svc14SystemInfoTypeENS3_6HandleEy

    ldr      r1, [sp, #8]              // pOut の第 1 ワードをスタックからレジスタへ
    ldr      r2, [sp, #12]             // pOut の第 2 ワードをスタックからレジスタへ

    add      sp, sp, #16
    pop      {r12,pc}

    .size _ZN2nn4kern3svc7Aarch3217CallGetSystemInfoEv, [.-_ZN2nn4kern3svc7Aarch3217CallGetSystemInfoEv]

//-------------------------------------------------
// Result CreatePort(nn::svc::Handle* pOutServer, nn::svc::Handle* pOutClient, int32_t maxSessions, bool isLight, uintptr_t name)
//
//     Invariant s=4 r=8 p=4            AArch32 s=4 r=4 p=4
// in  svc                              abi
//     Register 0       4 name          Register 0  ref  4 pOutServer
//                                      Register 1  ref  4 pOutClient
//     Register 2       4 maxSessions   Register 2       4 maxSessions
//     Register 3       1 isLight       Register 3       1 isLight
//                                      Stack    0       4 name
//
// in  svc                              abi
//     Register 0       4 return        Register 0       4 return
//     Register 1       4 pOutServer    
//     Register 2       4 pOutClient    
//
// conversion
//   Load            name
//   Scatter         pOutServer
//   Scatter         pOutClient

    .section .text._ZN2nn4kern3svc7Aarch3214CallCreatePortEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3214CallCreatePortEv
    .type    _ZN2nn4kern3svc7Aarch3214CallCreatePortEv, %function
    .type    _ZN2nn4kern3svc15SvcCreatePort32EPNS_3svc6HandleES4_ibj, %function
_ZN2nn4kern3svc7Aarch3214CallCreatePortEv:

    push     {lr}
    sub      sp, sp, #12

    str      r0, [sp, #0]              // name の値 をレジスタからスタックへ

    str      r1, [sp, #4]              // pOutServer の第 1 ワードをレジスタからスタックへ
    add      r0, sp, #4                // pOutServer のアドレスをレジスタへ
    str      r2, [sp, #8]              // pOutClient の第 1 ワードをレジスタからスタックへ
    add      r1, sp, #8                // pOutClient のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc15SvcCreatePort32EPNS_3svc6HandleES4_ibj

    ldr      r1, [sp, #4]              // pOutServer の第 1 ワードをスタックからレジスタへ
    ldr      r2, [sp, #8]              // pOutClient の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #12
    pop      {pc}

    .size _ZN2nn4kern3svc7Aarch3214CallCreatePortEv, [.-_ZN2nn4kern3svc7Aarch3214CallCreatePortEv]

//-------------------------------------------------
// Result ManageNamedPort(nn::svc::Handle* pOutServer, KUserPointer<const char*> name, int32_t maxSessions)
//
//     Invariant s=4 r=8 p=4            AArch32 s=4 r=4 p=4
// in  svc                              abi
//                                      Register 0  ref  4 pOutServer
//     Register 1  ref -- name          Register 1  ref -- name
//     Register 2       4 maxSessions   Register 2       4 maxSessions
//
// in  svc                              abi
//     Register 0       4 return        Register 0       4 return
//     Register 1       4 pOutServer    
//
// conversion
//   Scatter         pOutServer

    .section .text._ZN2nn4kern3svc7Aarch3219CallManageNamedPortEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3219CallManageNamedPortEv
    .type    _ZN2nn4kern3svc7Aarch3219CallManageNamedPortEv, %function
    .type    _ZN2nn4kern3svc20SvcManageNamedPort32EPNS_3svc6HandleENS1_12KUserPointerIPKcvEEi, %function
_ZN2nn4kern3svc7Aarch3219CallManageNamedPortEv:

    push     {lr}
    sub      sp, sp, #4

    str      r1, [sp, #0]              // pOutServer の第 1 ワードをレジスタからスタックへ
    add      r0, sp, #0                // pOutServer のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc20SvcManageNamedPort32EPNS_3svc6HandleENS1_12KUserPointerIPKcvEEi

    ldr      r1, [sp, #0]              // pOutServer の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #4
    pop      {pc}

    .size _ZN2nn4kern3svc7Aarch3219CallManageNamedPortEv, [.-_ZN2nn4kern3svc7Aarch3219CallManageNamedPortEv]

//-------------------------------------------------
// Result ConnectToPort(nn::svc::Handle* pOut, nn::svc::Handle port)
//
//     Invariant s=4 r=8 p=4       AArch32 s=4 r=4 p=4
// in  svc                         abi
//                                 Register 0  ref  4 pOut
//     Register 1       4 port     Register 1       4 port
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//     Register 1       4 pOut     
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc7Aarch3217CallConnectToPortEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3217CallConnectToPortEv
    .type    _ZN2nn4kern3svc7Aarch3217CallConnectToPortEv, %function
    .type    _ZN2nn4kern3svc18SvcConnectToPort32EPNS_3svc6HandleES3_, %function
_ZN2nn4kern3svc7Aarch3217CallConnectToPortEv:

    push     {lr}
    sub      sp, sp, #4

    str      r1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      r0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc18SvcConnectToPort32EPNS_3svc6HandleES3_

    ldr      r1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #4
    pop      {pc}

    .size _ZN2nn4kern3svc7Aarch3217CallConnectToPortEv, [.-_ZN2nn4kern3svc7Aarch3217CallConnectToPortEv]

//-------------------------------------------------
// Result SetProcessMemoryPermission(nn::svc::Handle process, uint64_t addr, uint64_t size, nn::svc::MemoryPermission permission)
//
//     Invariant s=4 r=8 p=4           AArch32 s=4 r=4 p=4
// in  svc                             abi
//     Register 0       4 process      Register 0       4 process
//     Register 1       8 size         
//     Register 2       8 addr         Register 2       8 addr
//     Register 3       8 addr         Register 3       8 addr
//     Register 4       8 size         
//     Register 5       4 permission   
//                                     Stack    0       8 size
//                                     Stack    1       8 size
//                                     Stack    2       4 permission
//
// in  svc                             abi
//     Register 0       4 return       Register 0       4 return
//
// conversion
//   Load            size
//   Load            size
//   Load            permission

    .section .text._ZN2nn4kern3svc7Aarch3230CallSetProcessMemoryPermissionEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3230CallSetProcessMemoryPermissionEv
    .type    _ZN2nn4kern3svc7Aarch3230CallSetProcessMemoryPermissionEv, %function
    .type    _ZN2nn4kern3svc31SvcSetProcessMemoryPermission32ENS_3svc6HandleEyyNS2_16MemoryPermissionE, %function
_ZN2nn4kern3svc7Aarch3230CallSetProcessMemoryPermissionEv:

    push     {lr}
    sub      sp, sp, #12

    str      r1, [sp, #0]              // size の値 をレジスタからスタックへ
    str      r4, [sp, #4]              // size の値 をレジスタからスタックへ
    str      r5, [sp, #8]              // permission の値 をレジスタからスタックへ

    bl       _ZN2nn4kern3svc31SvcSetProcessMemoryPermission32ENS_3svc6HandleEyyNS2_16MemoryPermissionE

    add      sp, sp, #12
    pop      {pc}

    .size _ZN2nn4kern3svc7Aarch3230CallSetProcessMemoryPermissionEv, [.-_ZN2nn4kern3svc7Aarch3230CallSetProcessMemoryPermissionEv]

//-------------------------------------------------
// Result MapProcessMemory(uintptr_t toAddr, nn::svc::Handle process, uint64_t fromAddr, size_t size)
//
//     Invariant s=4 r=8 p=4         AArch32 s=4 r=4 p=4
// in  svc                           abi
//     Register 0       4 toAddr     Register 0       4 toAddr
//     Register 1       4 process    Register 1       4 process
//     Register 2       8 fromAddr   Register 2       8 fromAddr
//     Register 3       8 fromAddr   Register 3       8 fromAddr
//     Register 4       4 size       
//                                   Stack    0       4 size
//
// in  svc                           abi
//     Register 0       4 return     Register 0       4 return
//
// conversion
//   Load            size

    .section .text._ZN2nn4kern3svc7Aarch3220CallMapProcessMemoryEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3220CallMapProcessMemoryEv
    .type    _ZN2nn4kern3svc7Aarch3220CallMapProcessMemoryEv, %function
    .type    _ZN2nn4kern3svc21SvcMapProcessMemory32EjNS_3svc6HandleEyj, %function
_ZN2nn4kern3svc7Aarch3220CallMapProcessMemoryEv:

    push     {lr}
    sub      sp, sp, #4

    str      r4, [sp, #0]              // size の値 をレジスタからスタックへ

    bl       _ZN2nn4kern3svc21SvcMapProcessMemory32EjNS_3svc6HandleEyj

    add      sp, sp, #4
    pop      {pc}

    .size _ZN2nn4kern3svc7Aarch3220CallMapProcessMemoryEv, [.-_ZN2nn4kern3svc7Aarch3220CallMapProcessMemoryEv]

//-------------------------------------------------
// Result UnmapProcessMemory(uintptr_t toAddr, nn::svc::Handle process, uint64_t fromAddr, size_t size)
//
//     Invariant s=4 r=8 p=4         AArch32 s=4 r=4 p=4
// in  svc                           abi
//     Register 0       4 toAddr     Register 0       4 toAddr
//     Register 1       4 process    Register 1       4 process
//     Register 2       8 fromAddr   Register 2       8 fromAddr
//     Register 3       8 fromAddr   Register 3       8 fromAddr
//     Register 4       4 size       
//                                   Stack    0       4 size
//
// in  svc                           abi
//     Register 0       4 return     Register 0       4 return
//
// conversion
//   Load            size

    .section .text._ZN2nn4kern3svc7Aarch3222CallUnmapProcessMemoryEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3222CallUnmapProcessMemoryEv
    .type    _ZN2nn4kern3svc7Aarch3222CallUnmapProcessMemoryEv, %function
    .type    _ZN2nn4kern3svc23SvcUnmapProcessMemory32EjNS_3svc6HandleEyj, %function
_ZN2nn4kern3svc7Aarch3222CallUnmapProcessMemoryEv:

    push     {lr}
    sub      sp, sp, #4

    str      r4, [sp, #0]              // size の値 をレジスタからスタックへ

    bl       _ZN2nn4kern3svc23SvcUnmapProcessMemory32EjNS_3svc6HandleEyj

    add      sp, sp, #4
    pop      {pc}

    .size _ZN2nn4kern3svc7Aarch3222CallUnmapProcessMemoryEv, [.-_ZN2nn4kern3svc7Aarch3222CallUnmapProcessMemoryEv]

//-------------------------------------------------
// Result QueryProcessMemory(KUserPointer<nn::svc::ilp32::MemoryInfo*> pBlockInfo, nn::svc::PageInfo* pPageInfo, nn::svc::Handle process, uint64_t addr)
//
//     Invariant s=4 r=8 p=4           AArch32 s=4 r=4 p=4
// in  svc                             abi
//     Register 0  ref 40 pBlockInfo   Register 0  ref 40 pBlockInfo
//     Register 1       8 addr         Register 1  ref  4 pPageInfo
//     Register 2       4 process      Register 2       4 process
//     Register 3       8 addr         
//                                     Stack    0       8 addr
//                                     Stack    1       8 addr
//
// in  svc                             abi
//     Register 0       4 return       Register 0       4 return
//     Register 1       4 pPageInfo    
//
// conversion
//   Load            addr
//   Load            addr
//   Scatter         pPageInfo

    .section .text._ZN2nn4kern3svc7Aarch3222CallQueryProcessMemoryEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3222CallQueryProcessMemoryEv
    .type    _ZN2nn4kern3svc7Aarch3222CallQueryProcessMemoryEv, %function
    .type    _ZN2nn4kern3svc23SvcQueryProcessMemory32ENS1_12KUserPointerIPNS_3svc5ilp3210MemoryInfoEvEEPNS3_8PageInfoENS3_6HandleEy, %function
_ZN2nn4kern3svc7Aarch3222CallQueryProcessMemoryEv:

    push     {lr}
    sub      sp, sp, #12

    str      r1, [sp, #0]              // addr の値 をレジスタからスタックへ
    str      r3, [sp, #4]              // addr の値 をレジスタからスタックへ

    str      r1, [sp, #8]              // pPageInfo の第 1 ワードをレジスタからスタックへ
    add      r1, sp, #8                // pPageInfo のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc23SvcQueryProcessMemory32ENS1_12KUserPointerIPNS_3svc5ilp3210MemoryInfoEvEEPNS3_8PageInfoENS3_6HandleEy

    ldr      r1, [sp, #8]              // pPageInfo の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #12
    pop      {pc}

    .size _ZN2nn4kern3svc7Aarch3222CallQueryProcessMemoryEv, [.-_ZN2nn4kern3svc7Aarch3222CallQueryProcessMemoryEv]

//-------------------------------------------------
// Result MapProcessCodeMemory(nn::svc::Handle process, uint64_t toAddr, uint64_t fromAddr, uint64_t size)
//
//     Invariant s=4 r=8 p=4         AArch32 s=4 r=4 p=4
// in  svc                           abi
//     Register 0       4 process    Register 0       4 process
//     Register 1       8 fromAddr   
//     Register 2       8 toAddr     Register 2       8 toAddr
//     Register 3       8 toAddr     Register 3       8 toAddr
//     Register 4       8 fromAddr   
//     Register 5       8 size       
//     Register 6       8 size       
//                                   Stack    0       8 fromAddr
//                                   Stack    1       8 fromAddr
//                                   Stack    2       8 size
//                                   Stack    3       8 size
//
// in  svc                           abi
//     Register 0       4 return     Register 0       4 return
//
// conversion
//   Load            fromAddr
//   Load            fromAddr
//   Load            size
//   Load            size

    .section .text._ZN2nn4kern3svc7Aarch3224CallMapProcessCodeMemoryEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3224CallMapProcessCodeMemoryEv
    .type    _ZN2nn4kern3svc7Aarch3224CallMapProcessCodeMemoryEv, %function
    .type    _ZN2nn4kern3svc25SvcMapProcessCodeMemory32ENS_3svc6HandleEyyy, %function
_ZN2nn4kern3svc7Aarch3224CallMapProcessCodeMemoryEv:

    push     {r12,lr}
    sub      sp, sp, #16

    str      r1, [sp, #0]              // fromAddr の値 をレジスタからスタックへ
    str      r4, [sp, #4]              // fromAddr の値 をレジスタからスタックへ
    str      r5, [sp, #8]              // size の値 をレジスタからスタックへ
    str      r6, [sp, #12]             // size の値 をレジスタからスタックへ

    bl       _ZN2nn4kern3svc25SvcMapProcessCodeMemory32ENS_3svc6HandleEyyy

    add      sp, sp, #16
    pop      {r12,pc}

    .size _ZN2nn4kern3svc7Aarch3224CallMapProcessCodeMemoryEv, [.-_ZN2nn4kern3svc7Aarch3224CallMapProcessCodeMemoryEv]

//-------------------------------------------------
// Result UnmapProcessCodeMemory(nn::svc::Handle process, uint64_t toAddr, uint64_t fromAddr, uint64_t size)
//
//     Invariant s=4 r=8 p=4         AArch32 s=4 r=4 p=4
// in  svc                           abi
//     Register 0       4 process    Register 0       4 process
//     Register 1       8 fromAddr   
//     Register 2       8 toAddr     Register 2       8 toAddr
//     Register 3       8 toAddr     Register 3       8 toAddr
//     Register 4       8 fromAddr   
//     Register 5       8 size       
//     Register 6       8 size       
//                                   Stack    0       8 fromAddr
//                                   Stack    1       8 fromAddr
//                                   Stack    2       8 size
//                                   Stack    3       8 size
//
// in  svc                           abi
//     Register 0       4 return     Register 0       4 return
//
// conversion
//   Load            fromAddr
//   Load            fromAddr
//   Load            size
//   Load            size

    .section .text._ZN2nn4kern3svc7Aarch3226CallUnmapProcessCodeMemoryEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3226CallUnmapProcessCodeMemoryEv
    .type    _ZN2nn4kern3svc7Aarch3226CallUnmapProcessCodeMemoryEv, %function
    .type    _ZN2nn4kern3svc27SvcUnmapProcessCodeMemory32ENS_3svc6HandleEyyy, %function
_ZN2nn4kern3svc7Aarch3226CallUnmapProcessCodeMemoryEv:

    push     {r12,lr}
    sub      sp, sp, #16

    str      r1, [sp, #0]              // fromAddr の値 をレジスタからスタックへ
    str      r4, [sp, #4]              // fromAddr の値 をレジスタからスタックへ
    str      r5, [sp, #8]              // size の値 をレジスタからスタックへ
    str      r6, [sp, #12]             // size の値 をレジスタからスタックへ

    bl       _ZN2nn4kern3svc27SvcUnmapProcessCodeMemory32ENS_3svc6HandleEyyy

    add      sp, sp, #16
    pop      {r12,pc}

    .size _ZN2nn4kern3svc7Aarch3226CallUnmapProcessCodeMemoryEv, [.-_ZN2nn4kern3svc7Aarch3226CallUnmapProcessCodeMemoryEv]

//-------------------------------------------------
// Result CreateProcess(nn::svc::Handle* pOut, KUserPointer<const nn::svc::ilp32::CreateProcessParameter*> params, KUserPointer<const nn::Bit32*> flags, int32_t flagsNum)
//
//     Invariant s=4 r=8 p=4         AArch32 s=4 r=4 p=4
// in  svc                           abi
//                                   Register 0  ref  4 pOut
//     Register 1  ref 48 params     Register 1  ref 48 params
//     Register 2  ref -- flags      Register 2  ref -- flags
//     Register 3       4 flagsNum   Register 3       4 flagsNum
//
// in  svc                           abi
//     Register 0       4 return     Register 0       4 return
//     Register 1       4 pOut       
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc7Aarch3217CallCreateProcessEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3217CallCreateProcessEv
    .type    _ZN2nn4kern3svc7Aarch3217CallCreateProcessEv, %function
    .type    _ZN2nn4kern3svc18SvcCreateProcess32EPNS_3svc6HandleENS1_12KUserPointerIPKNS2_5ilp3222CreateProcessParameterEvEENS5_IPKjvEEi, %function
_ZN2nn4kern3svc7Aarch3217CallCreateProcessEv:

    push     {lr}
    sub      sp, sp, #4

    str      r1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      r0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc18SvcCreateProcess32EPNS_3svc6HandleENS1_12KUserPointerIPKNS2_5ilp3222CreateProcessParameterEvEENS5_IPKjvEEi

    ldr      r1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #4
    pop      {pc}

    .size _ZN2nn4kern3svc7Aarch3217CallCreateProcessEv, [.-_ZN2nn4kern3svc7Aarch3217CallCreateProcessEv]

//-------------------------------------------------
// Result StartProcess(nn::svc::Handle runner, int32_t priority, int32_t coreNo, uint64_t stackSize)
//
//     Invariant s=4 r=8 p=4          AArch32 s=4 r=4 p=4
// in  svc                            abi
//     Register 0       4 runner      Register 0       4 runner
//     Register 1       4 priority    Register 1       4 priority
//     Register 2       4 coreNo      Register 2       4 coreNo
//     Register 3       8 stackSize   
//     Register 4       8 stackSize   
//                                    Stack    0       8 stackSize
//                                    Stack    1       8 stackSize
//
// in  svc                            abi
//     Register 0       4 return      Register 0       4 return
//
// conversion
//   Load            stackSize
//   Load            stackSize

    .section .text._ZN2nn4kern3svc7Aarch3216CallStartProcessEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3216CallStartProcessEv
    .type    _ZN2nn4kern3svc7Aarch3216CallStartProcessEv, %function
    .type    _ZN2nn4kern3svc17SvcStartProcess32ENS_3svc6HandleEiiy, %function
_ZN2nn4kern3svc7Aarch3216CallStartProcessEv:

    push     {r12,lr}
    sub      sp, sp, #8

    str      r3, [sp, #0]              // stackSize の値 をレジスタからスタックへ
    str      r4, [sp, #4]              // stackSize の値 をレジスタからスタックへ

    bl       _ZN2nn4kern3svc17SvcStartProcess32ENS_3svc6HandleEiiy

    add      sp, sp, #8
    pop      {r12,pc}

    .size _ZN2nn4kern3svc7Aarch3216CallStartProcessEv, [.-_ZN2nn4kern3svc7Aarch3216CallStartProcessEv]

//-------------------------------------------------
// Result GetProcessInfo(int64_t* pOut, nn::svc::Handle handle, nn::svc::ProcessInfoType type)
//
//     Invariant s=4 r=8 p=4       AArch32 s=4 r=4 p=4
// in  svc                         abi
//                                 Register 0  ref  8 pOut
//     Register 1       4 handle   Register 1       4 handle
//     Register 2       4 type     Register 2       4 type
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//     Register 1       8 pOut     
//     Register 2       8 pOut     
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc7Aarch3218CallGetProcessInfoEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3218CallGetProcessInfoEv
    .type    _ZN2nn4kern3svc7Aarch3218CallGetProcessInfoEv, %function
    .type    _ZN2nn4kern3svc19SvcGetProcessInfo32EPxNS_3svc6HandleENS3_15ProcessInfoTypeE, %function
_ZN2nn4kern3svc7Aarch3218CallGetProcessInfoEv:

    push     {r12,lr}
    sub      sp, sp, #8

    str      r1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    str      r2, [sp, #4]              // pOut の第 2 ワードをレジスタからスタックへ
    add      r0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc19SvcGetProcessInfo32EPxNS_3svc6HandleENS3_15ProcessInfoTypeE

    ldr      r1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ
    ldr      r2, [sp, #4]              // pOut の第 2 ワードをスタックからレジスタへ

    add      sp, sp, #8
    pop      {r12,pc}

    .size _ZN2nn4kern3svc7Aarch3218CallGetProcessInfoEv, [.-_ZN2nn4kern3svc7Aarch3218CallGetProcessInfoEv]

//-------------------------------------------------
// Result CreateResourceLimit(nn::svc::Handle* pOut)
//
//     Invariant s=4 r=8 p=4       AArch32 s=4 r=4 p=4
// in  svc                         abi
//                                 Register 0  ref  4 pOut
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//     Register 1       4 pOut     
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc7Aarch3223CallCreateResourceLimitEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch3223CallCreateResourceLimitEv
    .type    _ZN2nn4kern3svc7Aarch3223CallCreateResourceLimitEv, %function
    .type    _ZN2nn4kern3svc24SvcCreateResourceLimit32EPNS_3svc6HandleE, %function
_ZN2nn4kern3svc7Aarch3223CallCreateResourceLimitEv:

    push     {lr}
    sub      sp, sp, #4

    str      r1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      r0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc24SvcCreateResourceLimit32EPNS_3svc6HandleE

    ldr      r1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #4
    pop      {pc}

    .size _ZN2nn4kern3svc7Aarch3223CallCreateResourceLimitEv, [.-_ZN2nn4kern3svc7Aarch3223CallCreateResourceLimitEv]

    .end

