﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/TargetConfigs/build_Base.h>

#include "kern_InitElf32.h"
#include "kern_InitElf64.h"

namespace nn { namespace kern {
namespace init {
namespace Elf {

enum DynamicArrayTag
{
    DT_NULL,
    DT_NEEDED,
    DT_PLTRELSZ,
    DT_PLTGOT,
    DT_HASH,
    DT_STRTAB,
    DT_SYMTAB,
    DT_RELA,
    DT_RELASZ,
    DT_RELAENT,
    DT_STRSZ,
    DT_SYMENT,
    DT_INIT,
    DT_FINI,
    DT_SONAME,
    DT_RPATH,
    DT_SYMBOLIC,
    DT_REL,
    DT_RELSZ,
    DT_RELENT,
    DT_PLTREL,
    DT_DEBUG,
    DT_TEXTREL,
    DT_JMPREL,
    DT_BIND_NOW,
    DT_INIT_ARRAY,
    DT_FINI_ARRAY,
    DT_INIT_ARRAYSZ,
    DT_FINI_ARRAYSZ,
    DT_RELCOUNT = 0x6ffffffa,
    DT_RELACOUNT = 0x6ffffff9,
    DT_LOPROC = 0x70000000,
    DT_HIPROC = 0x7fffffff
};

enum SymbolBinding
{
    STB_LOCAL,
    STB_GLOBAL,
    STB_WEAK,
    STB_LOOS   = 10,
    STB_HIOS   = 12,
    STB_LOPROC = 13,
    STB_HIPROC = 15
};

enum SymbolType
{
    STT_NOTYPE,
    STT_OBJECT,
    STT_FUNC,
    STT_SECTION,
    STT_FILE,
    STT_LOOS   = 10,
    STT_HIOS   = 12,
    STT_LOPROC = 13,
    STT_HIPROC = 15
};

enum SpecialSectionIndex
{
    SHN_UNDEF,
    SHN_LORESERVE   = 0xff00,
    SHN_LOPROC      = 0xff00,
    SHN_HIPROC      = 0xff1f,
    SHN_LOOS        = 0xff20,
    SHN_HIOS        = 0xff3f,
    SHN_ABS         = 0xfff1,
    SHN_COMMON      = 0xfff2,
    SHN_HIRESERVE   = 0xffff
};

enum Visibility
{
    STV_DEFAULT,
    STV_INTERNAL,
    STV_HIDDEN,
    STV_PROTECTED
};

inline Bit32 NameToHash(const char* pName)
{
    Bit32 hash = 0;

    while (*pName)
    {
        Bit8 uc = *pName++;
        hash = (hash << 4) + uc;
        Bit32 g = (hash & 0xf0000000);
        if (g != 0)
        {
            hash ^= (g >> 24);
        }
        hash &= 0x0fffffff;
    }
    return hash;
}

#if defined NN_BUILD_CONFIG_ABI_ILP32
using namespace nn::kern::init::Elf::Elf32;
#endif

#if defined NN_BUILD_CONFIG_ABI_LP64
using namespace nn::kern::init::Elf::Elf64;
#endif

}
}
}}

