﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/svc/svc_Kernel.h>
#include "../../kern_Platform.h"
#include "../../kern_KInterruptTask.h"
#include "../../kern_KMemoryManager.h"

namespace nn { namespace kern {

    class KSystemControlBase
    {
    public:
        static KMemoryManager::Region GetCreateProcessMemoryRegion();
        static void GetHeapArrange(KHeapArrange* p);
        static void SystemInitialize0();
        static void SystemInitialize1();
        static void CallSecureMonitor64(Bit64* pBuf);
        static void CallSecureMonitor32(Bit32* pBuf);
        static void SleepSystem();
        static uint64_t GetRandomValue(uint64_t randMin, uint64_t randMax);
        static void GenerateRandom(Bit64* pBuffer, size_t num);
        static Result ReadWriteRegister(Bit32* pOut, nn::svc::PhysicalAddress address, Bit32 mask, Bit32 value);
        static NN_NORETURN void StopSystem();

        static bool IsIoMappablePhysicalAddress(KPhysicalAddress addr, size_t size);
        static bool IsStaticMappablePhysicalAddress(KPhysicalAddress addr, size_t size);

        static size_t ComputeMemoryRequirementForSecureMemory(size_t size, KMemoryManager::Region region);
        static Result AllocateSecureMemory(KVirtualAddress* pAddr, size_t size, KMemoryManager::Region region);
        static void FreeSecureMemory(KVirtualAddress addr, size_t size, KMemoryManager::Region region);
    };

    class KTargetSystemBase
    {
    public:
        static bool IsDevelopmentHardware()         { return m_IsDevelopmentHardware; }
        static bool IsPrintEnabled()                { return m_IsPrintEnabled; }
        static bool IsUserExceptionHandlerEnabled() { return m_IsUserExceptionHandlerEnabled; }
        static bool IsNonZeroFillMemoryEnabled()    { return m_IsNonZeroFillMemoryEnabled; }
        static bool IsUserPmuAccessEnabled()        { return m_IsUserPmuAccessEnabled; }
        static bool IsInternalDebugEnabled()        { return m_IsInternalDebugEnabled; }

        static void SetDevelopmentHardware(bool yes)    { m_IsDevelopmentHardware = yes; }
        static void EnablePrint(bool yes)               { m_IsPrintEnabled = yes; }
        static void EnableUserExceptionHandler(bool yes){ m_IsUserExceptionHandlerEnabled = yes; }
        static void EnableNonZeroFillMemory(bool yes)   { m_IsNonZeroFillMemoryEnabled = yes; }
        static void EnableUserPmuAccess(bool yes)       { m_IsUserPmuAccessEnabled = yes; }
        static void EnableInternalDebug(bool yes)       { m_IsInternalDebugEnabled = yes; }

    private:
        static bool     m_IsDevelopmentHardware;
        static bool     m_IsPrintEnabled;
        static bool     m_IsUserExceptionHandlerEnabled;
        static bool     m_IsNonZeroFillMemoryEnabled;
        static bool     m_IsUserPmuAccessEnabled;
        static bool     m_IsInternalDebugEnabled;
    };

}}

